/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import tfar.craftingstation.Configs;
import tfar.craftingstation.CraftingInventoryPersistant;
import tfar.craftingstation.CraftingStation;
import tfar.craftingstation.CraftingStationBlockEntity;
import tfar.craftingstation.init.ModMenuTypes;
import tfar.craftingstation.network.PacketHandler;
import tfar.craftingstation.network.S2CLastRecipePacket;
import tfar.craftingstation.slot.BigSlot;
import tfar.craftingstation.slot.SlotFastCraft;

public class CraftingStationContainer
extends AbstractContainerMenu {
    private static final Method GET_TILE_ENTITY_METHOD;
    public final CraftingInventoryPersistant craftMatrix;
    public final ResultContainer craftResult = new ResultContainer();
    public final Level world;
    public final CraftingStationBlockEntity tileEntity;
    public final List<Pair<Integer, Integer>> containerStarts = new ArrayList<Pair<Integer, Integer>>();
    public final List<ItemStack> blocks = new ArrayList<ItemStack>();
    public final List<Component> containerNames = new ArrayList<Component>();
    private final Player player;
    private ContainerData data;
    public Recipe<CraftingContainer> lastRecipe;
    public int subContainerSize = 0;
    public boolean hasSideContainers;
    protected Recipe<CraftingContainer> lastLastRecipe;
    protected DataSlot slot;

    private static BlockEntity getTileEntityAtPos(BlockPos pos, Level world) {
        try {
            return GET_TILE_ENTITY_METHOD != null ? (BlockEntity)GET_TILE_ENTITY_METHOD.invoke(null, pos, world) : world.m_7702_(pos);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return world.m_7702_(pos);
        }
    }

    public CraftingStationContainer(int id, Inventory inv, BlockPos pos) {
        this(id, inv, pos, (ContainerData)new SimpleContainerData(1));
    }

    public CraftingStationContainer(int id, Inventory inv, BlockPos pos, ContainerData data) {
        super(ModMenuTypes.crafting_station, id);
        this.player = inv.f_35978_;
        this.data = data;
        this.world = this.player.f_19853_;
        this.tileEntity = (CraftingStationBlockEntity)CraftingStationContainer.getTileEntityAtPos(pos, this.world);
        this.data = data;
        this.craftMatrix = new CraftingInventoryPersistant(this, this.tileEntity.input);
        this.hasSideContainers = false;
        this.addOwnSlots();
        if (((Boolean)Configs.Server.sideInventories.get()).booleanValue()) {
            this.searchSideInventories(pos);
        }
        this.addPlayerSlots(inv);
        this.m_6199_((Container)this.craftMatrix);
        if (this.hasSideContainers) {
            this.changeContainer(this.getCurrentContainer());
        }
        this.m_38884_(data);
    }

    protected void searchSideInventories(BlockPos pos) {
        Direction accessDir = null;
        ArrayList<BlockEntity> tileEntities = new ArrayList<BlockEntity>();
        for (Direction dir : Direction.values()) {
            Container container;
            BlockPos neighbor = pos.m_142300_(dir);
            BlockEntity te = this.world.m_7702_(neighbor);
            if (te == null || te instanceof CraftingStationBlockEntity || ForgeRegistries.BLOCK_ENTITIES.tags().getTag(CraftingStation.blacklisted).contains((Object)te.m_58903_()) || te instanceof Container && !(container = (Container)te).m_6542_(this.player) || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).filter(IItemHandlerModifiable.class::isInstance).isPresent()) continue;
            tileEntities.add(te);
            this.blocks.add(new ItemStack((ItemLike)this.world.m_8055_(neighbor).m_60734_()));
        }
        if (!tileEntities.isEmpty()) {
            for (BlockEntity tileEntity : tileEntities) {
                tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(this::accept);
            }
        }
        if (!tileEntities.isEmpty()) {
            this.addSideContainerSlots(tileEntities, accessDir, -125, 17);
        }
    }

    public static Recipe<CraftingContainer> findRecipe(CraftingContainer inv, Level world, Player player) {
        return world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)inv, world).stream().findFirst().orElse(null);
    }

    private void addOwnSlots() {
        this.m_38897_((Slot)new SlotFastCraft(this, this.craftMatrix, (Container)this.craftResult, 0, 124, 35, this.player));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.m_38897_(new Slot((Container)this.craftMatrix, x + 3 * y, 30 + 18 * x, 17 + 18 * y));
            }
        }
    }

    private void addSideContainerSlots(List<BlockEntity> tes, Direction dir, int xPos, int yPos) {
        int i = 0;
        while (i < tes.size()) {
            MutableComponent mutableComponent;
            BlockEntity te = tes.get(i);
            if (te instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)te;
                mutableComponent = menuProvider.m_5446_();
            } else {
                mutableComponent = te.m_58900_().m_60734_().m_49954_();
            }
            this.containerNames.add((Component)mutableComponent);
            int number = i++;
            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                int size = h.getSlots();
                this.subContainerSize += size;
                int offsetx = this.needsScroll() ? 0 : 8;
                for (int y = 0; y < (int)Math.ceil((double)size / 6.0); ++y) {
                    for (int x = 0; x < 6; ++x) {
                        int index = 6 * y + x;
                        if (index >= size) continue;
                        boolean hidden = y >= 9 || number != 0;
                        BigSlot wrapper = new BigSlot((IItemHandler)h, index, 18 * x + xPos + offsetx, 18 * y + yPos);
                        if (hidden) {
                            this.hideSlot((Slot)wrapper);
                        }
                        this.m_38897_((Slot)wrapper);
                    }
                }
            });
        }
        this.hasSideContainers = true;
    }

    public void hideSlot(Slot slot) {
        slot.f_40221_ = Integer.MAX_VALUE;
    }

    void setCurrentContainer(int container) {
        this.data.m_8050_(0, container);
    }

    public int getCurrentContainer() {
        return this.data.m_6413_(0);
    }

    private void addPlayerSlots(Inventory playerInventory) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + x + 9 * y, 8 + 18 * x, 84 + 18 * y));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, 8 + 18 * x, 142));
        }
    }

    public void m_6199_(Container inventory) {
        this.slotChangedCraftingGrid(this.world, this.player, this.craftMatrix, this.craftResult);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        boolean nothingDone;
        if (this.hasSideContainers) {
            return this.handleTransferWithSides(playerIn, index);
        }
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = slot.m_7993_().m_41777_();
        ItemStack stack = slot.m_7993_().m_41777_();
        if (index == 0) {
            nothingDone = !this.moveToPlayerInventory(stack);
        } else if (index < 10) {
            nothingDone = !this.moveToPlayerInventory(stack);
        } else {
            boolean bl = nothingDone = !this.moveToCraftingStation(stack);
        }
        if (nothingDone) {
            return ItemStack.f_41583_;
        }
        return this.notifySlotAfterTransfer(playerIn, stack, ret, slot);
    }

    protected ItemStack handleTransferWithSides(Player player, int index) {
        boolean nothingDone;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = slot.m_7993_().m_41777_();
        ItemStack stack = ret.m_41777_();
        if (index == 0) {
            nothingDone = !this.refillSideInventory(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
            nothingDone &= !this.mergeItemStackMove(stack, 10, 10 + this.subContainerSize);
        } else if (index < 10) {
            nothingDone = !this.refillSideInventory(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
            nothingDone &= !this.moveToSideInventory(stack);
        } else if (index < 10 + this.subContainerSize) {
            nothingDone = !this.moveToCraftingStation(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
        } else if (index >= 10 + this.subContainerSize) {
            nothingDone = !this.moveToCraftingStation(stack);
            nothingDone &= !this.moveToSideInventory(stack);
        } else {
            return ItemStack.f_41583_;
        }
        if (nothingDone) {
            return ItemStack.f_41583_;
        }
        return this.notifySlotAfterTransfer(player, stack, ret, slot);
    }

    protected void slotChangedCraftingGrid(Level world, Player player, CraftingContainer inv, ResultContainer result) {
        ItemStack itemstack = ItemStack.f_41583_;
        if (this.lastRecipe == null || !this.lastRecipe.m_5818_((Container)inv, world)) {
            this.lastRecipe = CraftingStationContainer.findRecipe(inv, world, player);
        }
        if (this.lastRecipe != null) {
            itemstack = this.lastRecipe.m_5874_((Container)inv);
        }
        result.m_6836_(0, itemstack);
        if (!world.f_46443_) {
            ServerPlayer entityplayermp = (ServerPlayer)player;
            List<ServerPlayer> relevantPlayers = this.getAllPlayersWithThisContainerOpen(this, entityplayermp.m_183503_());
            this.syncResultToAllOpenWindows(itemstack, relevantPlayers);
            if (this.lastLastRecipe != this.lastRecipe) {
                this.syncRecipeToAllOpenWindows(this.lastRecipe, relevantPlayers);
                this.lastLastRecipe = this.lastRecipe;
            }
        }
    }

    private void syncResultToAllOpenWindows(ItemStack stack, List<ServerPlayer> players) {
        players.forEach(otherPlayer -> otherPlayer.f_36096_.m_182406_(0, this.m_182424_(), stack));
    }

    private void syncRecipeToAllOpenWindows(Recipe<CraftingContainer> lastRecipe, List<ServerPlayer> players) {
        players.forEach(otherPlayer -> {
            ((CraftingStationContainer)otherPlayer.f_36096_).lastRecipe = lastRecipe;
            PacketHandler.INSTANCE.sendTo((Object)new S2CLastRecipePacket(lastRecipe), otherPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        });
    }

    private List<ServerPlayer> getAllPlayersWithThisContainerOpen(CraftingStationContainer container, ServerLevel server) {
        return server.m_6907_().stream().filter(player -> this.hasSameContainerOpen(container, (Player)player)).collect(Collectors.toList());
    }

    private boolean hasSameContainerOpen(CraftingStationContainer container, Player playerToCheck) {
        return playerToCheck instanceof ServerPlayer && playerToCheck.f_36096_.getClass().isAssignableFrom(((Object)((Object)container)).getClass()) && this.sameGui((CraftingStationContainer)playerToCheck.f_36096_);
    }

    public boolean sameGui(CraftingStationContainer otherContainer) {
        return this.tileEntity == otherContainer.tileEntity;
    }

    @Nonnull
    protected ItemStack notifySlotAfterTransfer(Player player, @Nonnull ItemStack stack, @Nonnull ItemStack original, Slot slot) {
        slot.m_40234_(stack, original);
        if (stack.m_41613_() == original.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_5852_(stack);
        slot.m_142406_(player, stack);
        if (slot.m_6657_() && slot.m_7993_().m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        return original;
    }

    protected boolean moveToSideInventory(@Nonnull ItemStack itemstack) {
        return this.hasSideContainers && this.mergeItemStackMove(itemstack, 10, 10 + this.subContainerSize);
    }

    protected boolean moveToPlayerInventory(@Nonnull ItemStack itemstack) {
        return this.m_38903_(itemstack, 10 + this.subContainerSize, this.f_38839_.size(), false);
    }

    protected boolean refillSideInventory(@Nonnull ItemStack itemStack) {
        return this.mergeItemStackRefill(itemStack, 10, 10 + this.subContainerSize);
    }

    protected boolean moveToCraftingStation(@Nonnull ItemStack itemstack) {
        return this.m_38903_(itemstack, 1, 10, false);
    }

    protected boolean m_38903_(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean didSomething = this.mergeItemStackRefill(stack, startIndex, endIndex);
        if (!stack.m_41619_()) {
            didSomething |= this.mergeItemStackMove(stack, startIndex, endIndex);
        }
        return didSomething;
    }

    protected boolean mergeItemStackRefill(@Nonnull ItemStack stack, int startIndex, int endIndex) {
        if (stack.m_41619_()) {
            return false;
        }
        boolean didSomething = false;
        if (stack.m_41753_()) {
            for (int k = startIndex; k < endIndex && !stack.m_41619_(); ++k) {
                int limit;
                Slot targetSlot = (Slot)this.f_38839_.get(k);
                ItemStack slotStack = targetSlot.m_7993_();
                if (slotStack.m_41619_() || slotStack.m_41720_() != stack.m_41720_() || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)slotStack) || !this.m_5882_(stack, targetSlot)) continue;
                int l = slotStack.m_41613_() + stack.m_41613_();
                if (l <= (limit = targetSlot.m_5866_(stack))) {
                    stack.m_41764_(0);
                    slotStack.m_41764_(l);
                    targetSlot.m_6654_();
                    didSomething = true;
                    continue;
                }
                if (slotStack.m_41613_() >= limit) continue;
                stack.m_41774_(limit - slotStack.m_41613_());
                slotStack.m_41764_(limit);
                targetSlot.m_6654_();
                didSomething = true;
            }
        }
        return didSomething;
    }

    protected boolean mergeItemStackMove(@Nonnull ItemStack stack, int startIndex, int endIndex) {
        if (stack.m_41619_()) {
            return false;
        }
        boolean didSomething = false;
        for (int k = startIndex; k < endIndex; ++k) {
            Slot targetSlot = (Slot)this.f_38839_.get(k);
            ItemStack slotStack = targetSlot.m_7993_();
            if (!slotStack.m_41619_() || !targetSlot.m_5857_(stack) || !this.m_5882_(stack, targetSlot)) continue;
            int limit = targetSlot.m_5866_(stack);
            ItemStack stack2 = stack.m_41777_();
            if (stack2.m_41613_() > limit) {
                stack2.m_41764_(limit);
                stack.m_41774_(limit);
            } else {
                stack.m_41764_(0);
            }
            targetSlot.m_5852_(stack2);
            targetSlot.m_6654_();
            didSomething = true;
            if (stack.m_41619_()) break;
        }
        return didSomething;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.craftResult && super.m_5882_(stack, slot);
    }

    public void updateSlotPositions(int offset) {
        int start;
        Pair<Integer, Integer> range = this.containerStarts.get(this.getCurrentContainer());
        for (int i = start = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            int index = (i - start) / 6 - offset;
            slot.f_40221_ = index >= 9 || index < 0 ? -10000 : 17 + 18 * index;
        }
    }

    public void changeContainer(int newContainer) {
        Slot slot;
        int i;
        this.setCurrentContainer(newContainer);
        Pair<Integer, Integer> range = this.containerStarts.get(this.getCurrentContainer());
        int start = (Integer)range.getLeft();
        int finish = (Integer)range.getRight();
        for (i = 10; i < this.subContainerSize + 10; ++i) {
            slot = (Slot)this.f_38839_.get(i);
            if (!(slot instanceof BigSlot) || i >= start && i < finish) continue;
            this.hideSlot(slot);
        }
        for (i = start; i < finish; ++i) {
            slot = (Slot)this.f_38839_.get(i);
            int row = (i - start) / 6;
            int column = (i - start) % 6;
            slot.f_40221_ = row >= 9 || row < 0 ? -10000 : 17 + 18 * row;
            int offsetx = this.needsScroll() ? 0 : 8;
            slot.f_40220_ = 18 * column - 125 + offsetx;
        }
    }

    public void updateLastRecipeFromServer(Recipe<CraftingContainer> recipe) {
        this.lastRecipe = recipe;
        this.craftResult.m_6836_(0, recipe != null ? recipe.m_5874_((Container)this.craftMatrix) : ItemStack.f_41583_);
    }

    public boolean needsScroll() {
        return this.getSlotCount() > 54;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.getSlotCount() / 6.0);
    }

    public int getSlotCount() {
        if (this.containerStarts.isEmpty()) {
            return 0;
        }
        if (this.getCurrentContainer() >= this.containerStarts.size()) {
            this.setCurrentContainer(this.containerStarts.size() - 1);
        }
        Pair<Integer, Integer> range = this.containerStarts.get(this.getCurrentContainer());
        return (Integer)range.getRight() - (Integer)range.getLeft();
    }

    private void accept(IItemHandler handler) {
        if (this.containerStarts.size() == 0) {
            int left = 10;
            int right = handler.getSlots() + left;
            this.containerStarts.add((Pair<Integer, Integer>)Pair.of((Object)left, (Object)right));
            return;
        }
        int left = (Integer)this.containerStarts.get(this.containerStarts.size() - 1).getRight();
        int right = handler.getSlots() + left;
        this.containerStarts.add((Pair<Integer, Integer>)Pair.of((Object)left, (Object)right));
    }

    public NonNullList<ItemStack> getRemainingItems() {
        return this.lastRecipe != null && this.lastRecipe.m_5818_((Container)this.craftMatrix, this.world) ? this.lastRecipe.m_7457_((Container)this.craftMatrix) : this.craftMatrix.getStackList();
    }

    static {
        Method doubleSlabsGetTileEntity1 = null;
        if (ModList.get().isLoaded("doubleslabs")) {
            try {
                Class<?> doubleSlabsFlags = Class.forName("cjminecraft.doubleslabs.api.Flags");
                doubleSlabsGetTileEntity1 = doubleSlabsFlags.getDeclaredMethod("getTileEntityAtPos", BlockPos.class, BlockGetter.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        GET_TILE_ENTITY_METHOD = doubleSlabsGetTileEntity1;
    }
}

