/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.ModList;
import tfar.craftingstation.CraftingStationContainer;
import tfar.craftingstation.client.ClearButton;
import tfar.craftingstation.client.TabButton;
import tfar.craftingstation.network.C2SClearPacket;
import tfar.craftingstation.network.PacketHandler;

public class CraftingStationScreen
extends AbstractContainerScreen<CraftingStationContainer> {
    public static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/crafting_table.png");
    public static final ResourceLocation SCROLLBAR_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation SCROLLBAR_BACKGROUND_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    public static final ResourceLocation SECONDARY_GUI_TEXTURE = new ResourceLocation("craftingstation", "textures/gui/secondary.png");
    private double currentScroll;
    private boolean isScrolling = false;
    private int topRow = 0;

    public CraftingStationScreen(CraftingStationContainer p_i51094_1_, Inventory p_i51094_2_, Component p_i51094_3_) {
        super((AbstractContainerMenu)p_i51094_1_, p_i51094_2_, p_i51094_3_);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (((CraftingStationContainer)this.f_97732_).hasSideContainers) {
            for (int i2 = 0; i2 < ((CraftingStationContainer)this.f_97732_).containerStarts.size(); ++i2) {
                Button.OnTooltip widget = (button, poseStack, x, y) -> this.m_6057_(poseStack, ((TabButton)button).stack, x, y);
                this.m_142416_((GuiEventListener)new TabButton(this.f_97735_ - 128 + 21 * i2, this.f_97736_ - 22, 22, 28, button -> this.changeContainer(((TabButton)button).index), widget, i2, ((CraftingStationContainer)this.f_97732_).blocks.get(i2)));
            }
        }
        if (!ModList.get().isLoaded("craftingtweaks")) {
            Button.OnTooltip tooltip = (button, matrices, i, i1) -> this.m_96617_(matrices, this.f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent("text.crafting_station.clear"), Math.max(this.f_96543_ / 2 - 43, 170)), i, i1);
            this.m_142416_((GuiEventListener)new ClearButton(this.f_97735_ + 85, this.f_97736_ + 16, 7, 7, b -> PacketHandler.INSTANCE.sendToServer((Object)new C2SClearPacket()), tooltip));
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean b = super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && (!((CraftingStationContainer)this.f_97732_).hasSideContainers || !this.m_6774_(-126, -16, 126, 32 + this.f_97727_, mouseX, mouseY));
        return b;
    }

    public void changeContainer(int container) {
        ((CraftingStationContainer)this.f_97732_).changeContainer(container);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack stack, int p_146979_1_, int p_146979_2_) {
        super.m_7027_(stack, p_146979_1_, p_146979_2_);
        if (((CraftingStationContainer)this.f_97732_).hasSideContainers) {
            this.f_96547_.m_92883_(stack, this.getTruncatedString(), -122.0f, 6.0f, 0x404040);
        }
    }

    String getTruncatedString() {
        String string = ((CraftingStationContainer)this.f_97732_).containerNames.get(((CraftingStationContainer)this.f_97732_).getCurrentContainer()).getString();
        if (string.length() > 23) {
            return string.substring(0, 23) + "...";
        }
        return string;
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CraftingStationScreen.bind(CRAFTING_TABLE_GUI_TEXTURES);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int i = this.f_97735_;
        int i1 = i - 16;
        int i2 = i1 + 14;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (((CraftingStationContainer)this.f_97732_).hasSideContainers) {
            CraftingStationScreen.bind(SECONDARY_GUI_TEXTURE);
            this.m_93228_(stack, i - 130, j, 0, 0, this.f_97726_, this.f_97727_ + 18);
            CraftingStationScreen.bind(SCROLLBAR_BACKGROUND_AND_TAB);
            int totalSlots = ((CraftingStationContainer)this.f_97732_).getSlotCount();
            int slotsToDraw = 54;
            if (totalSlots < slotsToDraw) {
                slotsToDraw = totalSlots;
            } else if (this.hasScrollbar() && this.topRow == ((CraftingStationContainer)this.f_97732_).getRows() - 9 && totalSlots % 6 != 0) {
                slotsToDraw = 48 + totalSlots % 6;
            }
            int offset = this.hasScrollbar() ? -126 : -118;
            for (int i3 = 0; i3 < slotsToDraw; ++i3) {
                int j1 = i3 % 6;
                int k1 = i3 / 6;
                this.m_93228_(stack, i + j1 * 18 + offset, 18 * k1 + j + 16, 8, 17, 18, 18);
            }
            if (this.hasScrollbar()) {
                this.m_93228_(stack, i - 17, j + 16, 174, 17, 14, 100);
                this.m_93228_(stack, i - 17, j + 67, 174, 18, 14, 111);
                CraftingStationScreen.bind(SCROLLBAR_AND_TAB);
                int k = (int)((double)(j + 17) + 145.0 * this.currentScroll);
                if (this.isScrolling && mouseX <= i2 && mouseX >= i1) {
                    this.m_93228_(stack, i - 16, k, 244, 0, 12, 15);
                } else {
                    this.m_93228_(stack, i - 16, k, 232, 0, 12, 15);
                }
            }
        }
    }

    private static void bind(ResourceLocation tex) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)tex);
    }

    public boolean m_6375_(double mouseX, double mouseY, int scroll) {
        this.isScrolling = this.hasScrollbar();
        return super.m_6375_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.isScrolling) {
            int j = this.f_97736_;
            int j1 = j + 24;
            int j2 = j1 + 145;
            int k = this.f_97735_;
            int k1 = k - 16;
            int k2 = k1 + 14;
            if (mouseX <= (double)k2 && mouseX >= (double)k1) {
                this.currentScroll = (mouseY - (double)j1) / (double)((float)(j2 - j1) - 0.0f);
                this.currentScroll = Mth.m_14008_((double)this.currentScroll, (double)0.0, (double)1.0);
                this.scrollTo(this.currentScroll);
            }
        }
        return super.m_7979_(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean m_6348_(double mouseX, double mouseY, int scroll) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, scroll);
    }

    private boolean hasScrollbar() {
        return ((CraftingStationContainer)this.f_97732_).getRows() > 9;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.hasScrollbar() && mouseX < (double)this.f_97735_ && mouseX > (double)(this.f_97735_ - 20)) {
            this.setTopRow((int)((double)this.topRow - scrollDelta), false);
            return true;
        }
        return false;
    }

    private void scrollTo(double scroll) {
        this.setTopRow((int)Math.round((double)(((CraftingStationContainer)this.f_97732_).getRows() - 9) * scroll), true);
    }

    private void setTopRow(int offset, boolean smooth) {
        this.topRow = offset;
        if (this.topRow < 0) {
            this.topRow = 0;
        } else if (this.topRow > ((CraftingStationContainer)this.f_97732_).getRows() - 9) {
            this.topRow = ((CraftingStationContainer)this.f_97732_).getRows() - 9;
        }
        ((CraftingStationContainer)this.f_97732_).updateSlotPositions(this.topRow);
        if (!smooth) {
            this.currentScroll = (double)this.topRow / (double)(((CraftingStationContainer)this.f_97732_).getRows() - 9);
        }
    }
}

