/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderBlock;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtrudingBehaviour;
import com.oierbravo.createmechanicalextruder.register.ModPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ExtruderInstance
extends ShaftInstance<ExtruderBlockEntity>
implements DynamicInstance {
    private final OrientedData extruderPole;
    private final ExtruderBlockEntity extruder;

    public ExtruderInstance(MaterialManager dispatcher, ExtruderBlockEntity tile) {
        super(dispatcher, (KineticBlockEntity)tile);
        this.extruder = tile;
        this.extruderPole = (OrientedData)dispatcher.defaultSolid().material(Materials.ORIENTED).getModel(ModPartials.MECHANICAL_EXTRUDER_POLE, this.blockState).createInstance();
        Quaternion q = Vector3f.f_122225_.m_122240_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(ExtruderBlock.HORIZONTAL_FACING))));
        this.extruderPole.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset(this.extruder);
        this.extruderPole.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset + this.extruder.getExtrudingBehaviour().headOffset, 0.0f);
    }

    private float getRenderedHeadOffset(ExtruderBlockEntity press) {
        ExtrudingBehaviour pressingBehaviour = press.getExtrudingBehaviour();
        return pressingBehaviour.getRenderedPoleOffset(AnimationTickHolder.getPartialTicks());
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.extruderPole});
    }

    public void remove() {
        super.remove();
        this.extruderPole.delete();
    }

    protected Instancer<RotatingData> getModel() {
        BlockState referenceState = this.blockState.rotate((LevelAccessor)((ExtruderBlockEntity)this.blockEntity).m_58904_(), ((ExtruderBlockEntity)this.blockEntity).m_58899_(), Rotation.CLOCKWISE_180);
        Direction facing = (Direction)referenceState.m_61143_((Property)BlockStateProperties.f_61374_);
        return this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, referenceState, facing);
    }
}

