/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExtrudingBehaviour
extends BlockEntityBehaviour {
    public static final int CYCLE = 240;
    public static final BehaviourType<ExtrudingBehaviour> TYPE = new BehaviourType();
    public ExtrudingBehaviourSpecifics specifics;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    public float headOffset = 0.44f;

    public <T extends SmartBlockEntity> ExtrudingBehaviour(T te) {
        super(te);
        this.specifics = (ExtrudingBehaviourSpecifics)te;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.finished = compound.m_128471_("Finished");
        this.prevRunningTicks = this.runningTicks = compound.m_128451_("Ticks");
        super.read(compound, clientPacket);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128379_("Finished", this.finished);
        compound.m_128405_("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
    }

    public float getRenderedPoleOffset(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.m_14179_((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        if (runningTicks < 160) {
            return (float)Mth.m_14008_((double)Math.pow(ticks / 240.0f * 2.0f, 3.0), (double)0.0, (double)1.0);
        }
        return Mth.m_14036_((float)((240.0f - ticks) / 240.0f * 3.0f), (float)0.0f, (float)1.0f);
    }

    public void start() {
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.blockEntity.sendData();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        BlockPos worldPosition = this.getPos();
        if (!this.running || level == null) {
            if (level != null && !level.f_46443_) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.specifics.tryProcess(true)) {
                    this.start();
                }
            }
            return;
        }
        if (level.f_46443_ && this.runningTicks == -120) {
            this.prevRunningTicks = 120;
            return;
        }
        if (this.runningTicks == 120 && this.specifics.getKineticSpeed() != 0.0f) {
            this.apply();
            AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(level, (Vec3i)worldPosition);
            if (!level.f_46443_) {
                this.blockEntity.sendData();
            }
        }
        if (!level.f_46443_ && this.runningTicks > 240) {
            this.finished = true;
            this.running = false;
            this.specifics.onExtrudingCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 120 && this.runningTicks >= 120) {
            this.runningTicks = 120;
            if (level.f_46443_ && !this.blockEntity.isVirtual()) {
                this.runningTicks = -120;
            }
        }
    }

    protected void apply() {
        Level level = this.getWorld();
        if (level.f_46443_) {
            return;
        }
        if (this.specifics.tryProcess(false)) {
            this.blockEntity.sendData();
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    public void makeCompactingParticleEffect(Vec3 pos, ItemStack stack) {
        Level level = this.getWorld();
        if (level == null || !level.f_46443_) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (Random)level.f_46441_, (float)0.175f).m_82542_(1.0, 0.0, 1.0);
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_ + 0.25, motion.f_82481_);
        }
    }

    public static interface ExtrudingBehaviourSpecifics {
        public void onExtrudingCompleted();

        public float getKineticSpeed();

        public boolean tryProcess(boolean var1);
    }
}

