/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtrudingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ExtrudingRecipe
implements Recipe<SimpleContainer>,
IRecipeTypeInfo {
    public static Comparator<? super ExtrudingRecipe> hasCatalyst;
    private static final Random r;
    private ResourceLocation id;
    private NonNullList<Ingredient> itemIngredients;
    private NonNullList<FluidIngredient> fluidIngredients;
    private ItemStack catalyst;
    private ProcessingOutput result;
    private int requiredBonks;

    public ExtrudingRecipe(ExtrudingRecipeBuilder.ExtrudingRecipeParams params) {
        this.id = params.id;
        this.result = params.result;
        this.itemIngredients = params.itemIngredients;
        this.fluidIngredients = params.fluidIngredients;
        this.catalyst = params.catalyst;
        this.requiredBonks = params.requiredBonks;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return false;
    }

    public static boolean match(ExtruderBlockEntity extruderBlockEntity, ExtrudingRecipe recipe) {
        FilteringBehaviour filter = extruderBlockEntity.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_());
        if (!ExtrudingRecipe.getAllIngredients(recipe).equals(extruderBlockEntity.getAllIngredients())) {
            return false;
        }
        if (!recipe.catalyst.m_41619_() && !recipe.catalyst.m_150930_(extruderBlockEntity.getCatalystItem())) {
            return false;
        }
        return filterTest;
    }

    private static boolean checkBlockInRecipe(Block block, ExtrudingRecipe recipe) {
        if (block instanceof LiquidBlock) {
            return ExtrudingRecipe.hasFluidStack(new FluidStack((Fluid)((LiquidBlock)block).getFluid(), 1000), recipe.getFluidIngredients());
        }
        return ExtrudingRecipe.hasItemStack(new ItemStack((ItemLike)block.m_5456_()), recipe.getItemIngredients());
    }

    private static boolean hasItemStack(ItemStack itemStack, List<Ingredient> itemIngredients) {
        if (itemStack.m_41619_()) {
            return false;
        }
        boolean hasItemStack = false;
        for (int i = 0; i < itemIngredients.size(); ++i) {
            if (!itemIngredients.get(i).test(itemStack)) continue;
            hasItemStack = true;
        }
        return hasItemStack;
    }

    private static boolean hasFluidStack(FluidStack fluidStack, List<FluidIngredient> fluidIngredients) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        boolean hasFluidStack = false;
        for (int i = 0; i < fluidIngredients.size(); ++i) {
            if (!fluidIngredients.get(i).test(fluidStack)) continue;
            hasFluidStack = true;
        }
        return hasFluidStack;
    }

    public boolean hasCatalyst() {
        return !this.getCatalyst().m_41619_();
    }

    public List<Ingredient> getItemIngredients() {
        return this.itemIngredients;
    }

    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public static List<String> getAllIngredients(ExtrudingRecipe recipe) {
        ArrayList<String> list = new ArrayList<String>();
        recipe.getItemIngredients().forEach(ingredient -> list.add(ingredient.m_43908_()[0].m_41720_().toString()));
        recipe.getFluidIngredients().forEach(ingredient -> list.add(((FluidStack)ingredient.getMatchingFluidStacks().get(0)).getFluid().getRegistryName().toString()));
        Collections.sort(list);
        return list;
    }

    public ItemStack assemble(SimpleContainer pContainer) {
        return this.result.rollOutput();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result.getStack();
    }

    public ProcessingOutput getResult() {
        return this.result;
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    static {
        r = new Random();
    }

    public static class Serializer
    implements RecipeSerializer<ExtrudingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("create_mechanical_extruder", "extruding");

        public ExtrudingRecipe fromJson(ResourceLocation id, JsonObject json) {
            ExtrudingRecipeBuilder builder = new ExtrudingRecipeBuilder(id);
            NonNullList itemIngredients = NonNullList.m_122779_();
            NonNullList fluidIngredients = NonNullList.m_122779_();
            ProcessingOutput result = ProcessingOutput.EMPTY;
            ItemStack catalyst = ItemStack.f_41583_;
            int requiredBonks = 0;
            for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
                if (FluidIngredient.isFluidIngredient((JsonElement)je)) {
                    fluidIngredients.add((Object)FluidIngredient.deserialize((JsonElement)je));
                    continue;
                }
                itemIngredients.add((Object)Ingredient.m_43917_((JsonElement)je));
            }
            result = ProcessingOutput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            if (GsonHelper.m_13900_((JsonObject)json, (String)"catalyst")) {
                catalyst = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"catalyst"));
            }
            if (GsonHelper.m_13900_((JsonObject)json, (String)"requiredBonks")) {
                requiredBonks = GsonHelper.m_13927_((JsonObject)json, (String)"requiredBonks");
            }
            builder.withItemIngredients((NonNullList<Ingredient>)itemIngredients).withSingleItemOutput(result).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withCatalyst(catalyst).requiredBonks(requiredBonks);
            return builder.build();
        }

        public ExtrudingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int i;
            ExtrudingRecipeBuilder builder = new ExtrudingRecipeBuilder(id);
            NonNullList itemIngredients = NonNullList.m_122779_();
            NonNullList fluidIngredients = NonNullList.m_122779_();
            ProcessingOutput result = ProcessingOutput.EMPTY;
            ItemStack catalyst = ItemStack.f_41583_;
            int requiredBonks = 1;
            int size = buffer.m_130242_();
            for (i = 0; i < size; ++i) {
                itemIngredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            size = buffer.m_130242_();
            for (i = 0; i < size; ++i) {
                fluidIngredients.add((Object)FluidIngredient.read((FriendlyByteBuf)buffer));
            }
            result = ProcessingOutput.read((FriendlyByteBuf)buffer);
            catalyst = buffer.m_130267_();
            requiredBonks = buffer.readInt();
            builder.withItemIngredients((NonNullList<Ingredient>)itemIngredients).withSingleItemOutput(result).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withCatalyst(catalyst).requiredBonks(requiredBonks);
            return builder.build();
        }

        public void toNetwork(FriendlyByteBuf buffer, ExtrudingRecipe recipe) {
            NonNullList<Ingredient> itemIngredients = recipe.itemIngredients;
            NonNullList<FluidIngredient> fluidIngredients = recipe.fluidIngredients;
            ProcessingOutput result = recipe.result;
            ItemStack catalyst = recipe.catalyst;
            int requiredBonks = recipe.requiredBonks;
            buffer.m_130130_(itemIngredients.size());
            itemIngredients.forEach(i -> i.m_43923_(buffer));
            buffer.m_130130_(fluidIngredients.size());
            fluidIngredients.forEach(i -> i.write(buffer));
            result.write(buffer);
            buffer.writeItemStack(catalyst, false);
            buffer.writeInt(requiredBonks);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }

    public static class Type
    implements RecipeType<ExtrudingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "extruding";

        private Type() {
        }
    }
}

