/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.components.extruder;

import com.oierbravo.createmechanicalextruder.components.extruder.ExtrudingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ExtrudingRecipeBuilder {
    protected ExtrudingRecipeParams params;
    protected List<ICondition> recipeConditions;

    public ExtrudingRecipeBuilder(ResourceLocation recipeId) {
        this.params = new ExtrudingRecipeParams(recipeId);
        this.recipeConditions = new ArrayList<ICondition>();
    }

    public ExtrudingRecipeBuilder withItemIngredients(Ingredient ... itemIngredients) {
        return this.withItemIngredients((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])itemIngredients));
    }

    public ExtrudingRecipeBuilder withItemIngredients(NonNullList<Ingredient> itemIngredients) {
        this.params.itemIngredients = itemIngredients;
        return this;
    }

    public ExtrudingRecipeBuilder withSingleItemOutput(ItemStack output) {
        this.params.result = new ProcessingOutput(output, 1.0f);
        return this;
    }

    public ExtrudingRecipeBuilder withSingleItemOutput(ProcessingOutput output) {
        this.params.result = output;
        return this;
    }

    public ExtrudingRecipeBuilder withCatalyst(ItemStack catalyst) {
        this.params.catalyst = catalyst;
        return this;
    }

    public ExtrudingRecipeBuilder withFluidIngredients(FluidIngredient ... ingredients) {
        return this.withFluidIngredients((NonNullList<FluidIngredient>)NonNullList.m_122783_((Object)FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public ExtrudingRecipeBuilder withFluidIngredients(NonNullList<FluidIngredient> ingredients) {
        this.params.fluidIngredients = ingredients;
        return this;
    }

    public ExtrudingRecipeBuilder requiredBonks(int requiredBonks) {
        this.params.requiredBonks = requiredBonks;
        return this;
    }

    public ExtrudingRecipe build() {
        return new ExtrudingRecipe(this.params);
    }

    public static class ExtrudingRecipeParams {
        protected ResourceLocation id;
        protected NonNullList<Ingredient> itemIngredients;
        protected ProcessingOutput result;
        protected NonNullList<FluidIngredient> fluidIngredients;
        protected ItemStack catalyst;
        protected int requiredBonks;

        protected ExtrudingRecipeParams(ResourceLocation id) {
            this.id = id;
            this.itemIngredients = NonNullList.m_122779_();
            this.result = ProcessingOutput.EMPTY;
            this.fluidIngredients = NonNullList.m_122779_();
            this.catalyst = ItemStack.f_41583_;
            this.requiredBonks = 1;
        }
    }
}

