/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.register;

import com.oierbravo.createmechanicalextruder.components.extruder.ExtruderBlockEntity;
import com.oierbravo.createmechanicalextruder.components.extruder.ExtrudingRecipe;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"create_mechanical_extruder");
    public static final RegistryObject<RecipeSerializer<ExtrudingRecipe>> EXTRUDING_SERIALIZER = SERIALIZERS.register("extruding", () -> ExtrudingRecipe.Serializer.INSTANCE);

    public static void register(IEventBus eventBus) {
        SERIALIZERS.register(eventBus);
    }

    public static Optional<ExtrudingRecipe> findExtruding(ExtruderBlockEntity extruder, Level level) {
        if (level.m_5776_()) {
            return Optional.empty();
        }
        List allExtrudingRecipes = level.m_7465_().m_44013_((RecipeType)ExtrudingRecipe.Type.INSTANCE);
        Stream<ExtrudingRecipe> allExtrudingRecipesFiltered = allExtrudingRecipes.stream().filter(extrudingRecipe -> ExtrudingRecipe.match(extruder, extrudingRecipe));
        Stream<ExtrudingRecipe> allExtrudingRecipesFilteredSorted = allExtrudingRecipesFiltered.sorted(Comparator.comparing(ExtrudingRecipe::hasCatalyst, Comparator.reverseOrder()));
        Optional<ExtrudingRecipe> recipe = allExtrudingRecipesFilteredSorted.findFirst();
        return recipe;
    }
}

