/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.core.ModBlocks;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.core.ModRegistries;
import io.github.lightman314.lctech.common.crafting.condition.TechCraftingConditions;
import io.github.lightman314.lctech.common.notifications.types.EnergyTradeNotification;
import io.github.lightman314.lctech.common.notifications.types.FluidTradeNotification;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.terminal.traderSearching.FluidTraderSearchFilter;
import io.github.lightman314.lctech.integration.lcdiscord.TechDiscord;
import io.github.lightman314.lctech.network.LCTechPacketHandler;
import io.github.lightman314.lctech.proxy.ClientProxy;
import io.github.lightman314.lctech.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.ModCreativeGroups;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.integration.IntegrationUtil;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lctech")
public class LCTech {
    public static final String MODID = "lctech";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final Logger LOGGER = LogManager.getLogger();

    public LCTech() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TechConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TechConfig.serverSpec);
        ModRegistries.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        IntegrationUtil.SafeRunIfLoaded((String)"lightmansdiscord", TechDiscord::setup, (String)"Error setting up Tech Discord Integration");
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        LCTech.safeEnqueueWork((ParallelDispatchEvent)event, "Error during common setup!", this::commonSetupWork);
    }

    private void commonSetupWork() {
        LCTechPacketHandler.init();
        TraderSearchFilter.addFilter((TraderSearchFilter)new FluidTraderSearchFilter());
        TraderData.register((ResourceLocation)FluidTraderData.TYPE, FluidTraderData::new);
        TraderData.register((ResourceLocation)EnergyTraderData.TYPE, EnergyTraderData::new);
        Notification.register((ResourceLocation)FluidTradeNotification.TYPE, FluidTradeNotification::new);
        Notification.register((ResourceLocation)EnergyTradeNotification.TYPE, EnergyTradeNotification::new);
        CraftingHelper.register(TechCraftingConditions.FluidTrader.SERIALIZER);
        CraftingHelper.register(TechCraftingConditions.FluidTank.SERIALIZER);
        CraftingHelper.register(TechCraftingConditions.EnergyTrader.SERIALIZER);
        CraftingHelper.register(TechCraftingConditions.Batteries.SERIALIZER);
        try {
            ModCreativeGroups.getMachineGroup().addToSortingList((List)Lists.newArrayList((Object[])new ItemLike[]{(ItemLike)ModBlocks.IRON_TANK.get(), (ItemLike)ModBlocks.GOLD_TANK.get(), (ItemLike)ModBlocks.DIAMOND_TANK.get(), (ItemLike)ModBlocks.FLUID_TRADER_INTERFACE.get(), (ItemLike)ModItems.BATTERY.get(), (ItemLike)ModItems.BATTERY_LARGE.get(), (ItemLike)ModBlocks.ENERGY_TRADER_INTERFACE.get()}));
            ModCreativeGroups.getUpgradeGroup().addToSortingList((List)Lists.newArrayList((Object[])new ItemLike[]{(ItemLike)ModItems.FLUID_CAPACITY_UPGRADE_1.get(), (ItemLike)ModItems.FLUID_CAPACITY_UPGRADE_2.get(), (ItemLike)ModItems.FLUID_CAPACITY_UPGRADE_3.get(), (ItemLike)ModItems.ENERGY_CAPACITY_UPGRADE_1.get(), (ItemLike)ModItems.ENERGY_CAPACITY_UPGRADE_2.get(), (ItemLike)ModItems.ENERGY_CAPACITY_UPGRADE_3.get()}));
            ModCreativeGroups.getTradingGroup().addToSortingList((List)Lists.newArrayList((Object[])new ItemLike[]{(ItemLike)ModBlocks.FLUID_TAP.get(), (ItemLike)ModBlocks.FLUID_TAP_BUNDLE.get(), (ItemLike)ModBlocks.FLUID_NETWORK_TRADER_1.get(), (ItemLike)ModBlocks.FLUID_NETWORK_TRADER_2.get(), (ItemLike)ModBlocks.FLUID_NETWORK_TRADER_3.get(), (ItemLike)ModBlocks.FLUID_NETWORK_TRADER_4.get(), (ItemLike)ModBlocks.BATTERY_SHOP.get(), (ItemLike)ModBlocks.ENERGY_NETWORK_TRADER.get()}));
        }
        catch (Throwable t) {
            LOGGER.error("Error adding items to LC Creative Tabs.", t);
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LCTech.safeEnqueueWork((ParallelDispatchEvent)event, "Error during client setup!", PROXY::setupClient);
    }

    public static void safeEnqueueWork(ParallelDispatchEvent event, String errorMessage, Runnable work) {
        event.enqueueWork(() -> {
            try {
                work.run();
            }
            catch (Throwable t) {
                LOGGER.error(errorMessage, t);
            }
        });
    }
}

