/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.energy;

import io.github.lightman314.lctech.common.blockentities.EnergyTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.items.IBatteryItem;
import io.github.lightman314.lctech.common.menu.traderinterface.energy.EnergyStorageTab;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.ConfigurableSidedHandler;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EnergyStorageClientTab
extends TraderInterfaceClientTab<EnergyStorageTab> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lctech", "textures/gui/energy_trade_extras.png");
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int FRAME_HEIGHT = 90;
    private static final int ENERGY_BAR_HEIGHT = 88;
    private static final int WIDGET_OFFSET = 53;
    DirectionalSettingsWidget inputSettings;
    DirectionalSettingsWidget outputSettings;

    public EnergyStorageClientTab(TraderInterfaceScreen screen, EnergyStorageTab commonTab) {
        super(screen, (TraderInterfaceTab)commonTab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemStack)IBatteryItem.HideEnergyBar(ModItems.BATTERY_LARGE));
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable((String)"tooltip.lightmanscurrency.interface.storage", (Object[])new Object[0]);
    }

    public boolean blockInventoryClosing() {
        return false;
    }

    private ConfigurableSidedHandler.DirectionalSettings getInputSettings() {
        if (this.menu.getBE() instanceof EnergyTraderInterfaceBlockEntity) {
            return ((EnergyTraderInterfaceBlockEntity)this.menu.getBE()).getEnergyHandler().getInputSides();
        }
        return new ConfigurableSidedHandler.DirectionalSettings();
    }

    private ConfigurableSidedHandler.DirectionalSettings getOutputSettings() {
        if (this.menu.getBE() instanceof EnergyTraderInterfaceBlockEntity) {
            return ((EnergyTraderInterfaceBlockEntity)this.menu.getBE()).getEnergyHandler().getOutputSides();
        }
        return new ConfigurableSidedHandler.DirectionalSettings();
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.inputSettings = new DirectionalSettingsWidget(screenArea.pos.offset(33, 62), arg_0 -> ((ConfigurableSidedHandler.DirectionalSettings)this.getInputSettings()).get(arg_0), this.getInputSettings().ignoreSides, this::ToggleInputSide, arg_0 -> ((EnergyStorageClientTab)this).addChild(arg_0));
        this.outputSettings = new DirectionalSettingsWidget(screenArea.pos.offset(116, 62), arg_0 -> ((ConfigurableSidedHandler.DirectionalSettings)this.getOutputSettings()).get(arg_0), this.getOutputSettings().ignoreSides, this::ToggleOutputSide, arg_0 -> ((EnergyStorageClientTab)this).addChild(arg_0));
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable((String)"tooltip.lightmanscurrency.interface.storage", (Object[])new Object[0]), 8, 6, 0x404040);
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = this.menu.getBE();
        if (traderInterfaceBlockEntity instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            gui.resetColor();
            for (Slot slot : ((EnergyStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderInterfaceScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 206, 0, 18, 18);
            }
            gui.blit(GUI_TEXTURE, 40, 121, 36, 0, 18, 18);
            gui.blit(GUI_TEXTURE, 13, 17, 0, 0, 18, 90);
            double fillPercent = (double)be.getStoredEnergy() / (double)be.getMaxEnergy();
            int fillHeight = MathUtil.clamp((int)((int)(88.0 * fillPercent)), (int)0, (int)88);
            int yOffset = 88 - fillHeight + 1;
            gui.blit(GUI_TEXTURE, 13, 17 + yOffset, 18, yOffset, 18, fillHeight);
            gui.drawString((Component)EasyText.translatable((String)"gui.lctech.settings.fluidinput.side", (Object[])new Object[0]), 33, 53, 0x404040);
            int textWidth = gui.font.m_92852_((FormattedText)EasyText.translatable((String)"gui.lctech.settings.fluidoutput.side", (Object[])new Object[0]));
            gui.drawString((Component)EasyText.translatable((String)"gui.lctech.settings.fluidoutput.side", (Object[])new Object[0]), 173 - textWidth, 53, 0x404040);
        }
    }

    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = this.menu.getBE();
        if (traderInterfaceBlockEntity instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            if (this.isMouseOverEnergy(gui.mousePos)) {
                gui.renderTooltip((Component)EasyText.literal((String)(EnergyUtil.formatEnergyAmount(be.getStoredEnergy()) + "/" + EnergyUtil.formatEnergyAmount(be.getMaxEnergy()))).m_130940_(ChatFormatting.AQUA));
            }
        }
    }

    private boolean isMouseOverEnergy(ScreenPosition mousePos) {
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        return mousePos.x >= leftEdge && mousePos.x < leftEdge + 18 && mousePos.y >= topEdge && mousePos.y < topEdge + 90;
    }

    private void ToggleInputSide(Direction side) {
        ((EnergyStorageTab)this.commonTab).toggleInputSlot(side);
    }

    private void ToggleOutputSide(Direction side) {
        ((EnergyStorageTab)this.commonTab).toggleOutputSlot(side);
    }
}

