/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.fluid;

import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import io.github.lightman314.lctech.common.blockentities.FluidTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.core.ModBlocks;
import io.github.lightman314.lctech.common.menu.traderinterface.fluid.FluidStorageTab;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.ConfigurableSidedHandler;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class FluidStorageClientTab
extends TraderInterfaceClientTab<FluidStorageTab>
implements IScrollable,
IMouseListener {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lctech", "textures/gui/fluid_trade_extras.png");
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int TANKS = 8;
    private static final int WIDGET_OFFSET = 72;
    ScrollBarWidget scrollBar;
    DirectionalSettingsWidget inputSettings;
    DirectionalSettingsWidget outputSettings;
    int scroll = 0;

    public FluidStorageClientTab(TraderInterfaceScreen screen, FluidStorageTab commonTab) {
        super(screen, (TraderInterfaceTab)commonTab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.IRON_TANK);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable((String)"tooltip.lightmanscurrency.interface.storage", (Object[])new Object[0]);
    }

    public boolean blockInventoryClosing() {
        return false;
    }

    private ConfigurableSidedHandler.DirectionalSettings getInputSettings() {
        if (this.menu.getBE() instanceof FluidTraderInterfaceBlockEntity) {
            return ((FluidTraderInterfaceBlockEntity)this.menu.getBE()).getFluidHandler().getInputSides();
        }
        return new ConfigurableSidedHandler.DirectionalSettings();
    }

    private ConfigurableSidedHandler.DirectionalSettings getOutputSettings() {
        if (this.menu.getBE() instanceof FluidTraderInterfaceBlockEntity) {
            return ((FluidTraderInterfaceBlockEntity)this.menu.getBE()).getFluidHandler().getOutputSides();
        }
        return new ConfigurableSidedHandler.DirectionalSettings();
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild((Object)this);
        this.scrollBar = (ScrollBarWidget)this.addChild(new ScrollBarWidget(screenArea.pos.offset(157, 17), 53, (IScrollable)this));
        this.scrollBar.smallKnob = true;
        this.addChild(new ScrollListener(screenArea.pos, screenArea.width, 118, this::mouseScrolled));
        this.inputSettings = new DirectionalSettingsWidget(screenArea.pos.offset(33, 81), arg_0 -> ((ConfigurableSidedHandler.DirectionalSettings)this.getInputSettings()).get(arg_0), this.getInputSettings().ignoreSides, this::ToggleInputSide, arg_0 -> ((FluidStorageClientTab)this).addChild(arg_0));
        this.outputSettings = new DirectionalSettingsWidget(screenArea.pos.offset(116, 81), arg_0 -> ((ConfigurableSidedHandler.DirectionalSettings)this.getOutputSettings()).get(arg_0), this.getOutputSettings().ignoreSides, this::ToggleOutputSide, arg_0 -> ((FluidStorageClientTab)this).addChild(arg_0));
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable((String)"tooltip.lightmanscurrency.interface.storage", (Object[])new Object[0]), 8, 6, 0x404040);
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = this.menu.getBE();
        if (traderInterfaceBlockEntity instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            this.validateScroll();
            int index = this.scroll;
            TraderFluidStorage storage = be.getFluidBuffer();
            int yPos = 17;
            for (int x = 0; x < 8 && index < storage.getTanks(); ++index, ++x) {
                int n = 13 + x * 18;
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(index);
                gui.resetColor();
                gui.blit(GUI_TEXTURE, n, yPos, 36, 16, 18, 53);
                FluidRenderUtil.drawFluidTankInGUI(entry.filter, this.screen.getCorner(), n + 1, yPos + 1, 16, 51, (double)entry.getStoredAmount() / (double)storage.getTankCapacity());
                gui.resetColor();
                gui.blit(GUI_TEXTURE, n, yPos, 54, 16, 18, 53);
            }
            gui.resetColor();
            for (Slot slot : ((FluidStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderInterfaceScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 206, 0, 18, 18);
            }
            gui.drawString((Component)EasyText.translatable((String)"gui.lctech.settings.fluidinput.side", (Object[])new Object[0]), 33, 72, 0x404040);
            int textWidth = gui.font.m_92852_((FormattedText)EasyText.translatable((String)"gui.lctech.settings.fluidoutput.side", (Object[])new Object[0]));
            gui.drawString((Component)EasyText.translatable((String)"gui.lctech.settings.fluidoutput.side", (Object[])new Object[0]), 173 - textWidth, 72, 0x404040);
        }
    }

    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = this.menu.getBE();
        if (traderInterfaceBlockEntity instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            TraderFluidStorage storage = be.getFluidBuffer();
            int hoveredSlot = this.isMouseOverTank(gui.mousePos);
            if (hoveredSlot >= 0) {
                if ((hoveredSlot += this.scroll) < 0 || hoveredSlot >= storage.getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(hoveredSlot);
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(FluidFormatUtil.getFluidName(entry.filter));
                tooltips.add(EasyText.literal((String)(FluidFormatUtil.formatFluidAmount(entry.getStoredAmount()) + "mB/" + FluidFormatUtil.formatFluidAmount(storage.getTankCapacity()) + "mB")).m_130940_(ChatFormatting.GRAY));
                tooltips.add(EasyText.translatable((String)"tooltip.lctech.trader.fluid.fill_tank", (Object[])new Object[0]));
                gui.renderComponentTooltip(tooltips);
            }
        }
    }

    private int isMouseOverTank(ScreenPosition mousePos) {
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        if (mousePos.y < topEdge || mousePos.y >= topEdge + 53) {
            return -1;
        }
        for (int x = 0; x < 8; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            return x;
        }
        return -1;
    }

    private int totalTankSlots() {
        if (this.menu.getBE() instanceof FluidTraderInterfaceBlockEntity) {
            return ((FluidTraderInterfaceBlockEntity)this.menu.getBE()).getFluidBuffer().getTanks();
        }
        return 0;
    }

    private boolean canScrollDown() {
        return this.totalTankSlots() - this.scroll > 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getBE() instanceof FluidTraderInterfaceBlockEntity && (hoveredSlot = this.isMouseOverTank(ScreenPosition.of((double)mouseX, (double)mouseY))) >= 0) {
            ((FluidStorageTab)this.commonTab).interactWithTank(hoveredSlot += this.scroll, Screen.m_96638_());
            return true;
        }
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public int currentScroll() {
        return this.scroll;
    }

    public int getMaxScroll() {
        return Math.max(0, this.totalTankSlots() - 8);
    }

    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    private void ToggleInputSide(Direction side) {
        ((FluidStorageTab)this.commonTab).toggleInputSlot(side);
    }

    private void ToggleOutputSide(Direction side) {
        ((FluidStorageTab)this.commonTab).toggleOutputSlot(side);
    }
}

