/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.energy;

import io.github.lightman314.lctech.common.menu.traderstorage.energy.EnergyTradeEditTab;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.registries.RegistryObject;

public class EnergyTradeEditClientTab
extends TraderStorageClientTab<EnergyTradeEditTab>
implements TradeButtonArea.InteractionConsumer,
IMouseListener {
    TradeButton tradeDisplay;
    CoinValueInput priceSelection;
    EditBox quantityInput;
    EasyButton buttonToggleTradeType;
    private int selection;

    public EnergyTradeEditClientTab(Object screen, EnergyTradeEditTab commonTab) {
        super(screen, (TraderStorageTab)commonTab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of((RegistryObject)ModItems.TRADING_CORE);
    }

    public MutableComponent getTooltip() {
        return EasyText.empty();
    }

    public boolean tabButtonVisible() {
        return false;
    }

    public boolean blockInventoryClosing() {
        return true;
    }

    public int getTradeRuleTradeIndex() {
        return ((EnergyTradeEditTab)this.commonTab).getTradeIndex();
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild((Object)this);
        EnergyTradeData trade = ((EnergyTradeEditTab)this.commonTab).getTrade();
        this.tradeDisplay = (TradeButton)this.addChild(new TradeButton(() -> ((TraderStorageMenu)this.menu).getContext(), ((EnergyTradeEditTab)this.commonTab)::getTrade, button -> {}));
        this.tradeDisplay.setPosition(screenArea.pos.offset(10, 18));
        this.priceSelection = (CoinValueInput)this.addChild(new CoinValueInput(screenArea.pos.offset(screenArea.width / 2 - 88, 40), (Component)EasyText.empty(), trade == null ? CoinValue.EMPTY : trade.getCost(), this.getFont(), this::onValueChanged));
        this.priceSelection.drawBG = false;
        this.quantityInput = (EditBox)this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 75, this.screen.getXSize() - 42 - this.getFont().m_92895_("FE"), 20, (Component)EasyText.empty()));
        this.quantityInput.m_94144_(trade != null ? String.valueOf(trade.getAmount()) : "");
        this.buttonToggleTradeType = (EasyButton)this.addChild(new EasyTextButton(screenArea.pos.offset(20, 120), 72, 20, (Component)EasyText.empty(), this::ToggleTradeType));
    }

    protected void closeAction() {
        this.selection = -1;
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.getTrade() == null) {
            return;
        }
        this.validateRenderables();
        gui.resetColor();
        gui.blit(TraderScreen.GUI_TEXTURE, this.getArrowPosition(), 10, 214, 18, 8, 6);
        if (this.selection >= 0) {
            gui.drawShadowed("FE", this.screen.getXSize() - 20 - gui.font.m_92895_("FE"), 78, 0xFFFFFF);
        }
    }

    private int getArrowPosition() {
        EnergyTradeData trade = this.getTrade();
        if (this.selection < 0) {
            if (trade.isSale()) {
                return 25;
            }
            return 116;
        }
        if (trade.isSale()) {
            return 99;
        }
        return 41;
    }

    private void validateRenderables() {
        this.priceSelection.f_93624_ = this.selection < 0;
        boolean bl = this.quantityInput.f_93624_ = this.selection >= 0;
        if (this.quantityInput.f_93624_) {
            int maxSellAmount = Integer.MAX_VALUE;
            if (this.menu.getTrader() instanceof EnergyTraderData) {
                maxSellAmount = ((EnergyTraderData)this.menu.getTrader()).getMaxEnergy();
            }
            TextInputUtil.whitelistInteger((EditBox)this.quantityInput, (long)0L, (long)maxSellAmount);
            int currentAmount = TextInputUtil.getIntegerValue((EditBox)this.quantityInput);
            if (currentAmount != this.getTrade().getAmount()) {
                ((EnergyTradeEditTab)this.commonTab).setQuantity(currentAmount);
            }
        }
        this.buttonToggleTradeType.m_93666_((Component)EasyText.translatable((String)("gui.button.lightmanscurrency.tradedirection." + ((EnergyTradeEditTab)this.commonTab).getTrade().getTradeDirection().name().toLowerCase()), (Object[])new Object[0]));
    }

    public void receiveSelfMessage(LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            ((EnergyTradeEditTab)this.commonTab).setTradeIndex(message.getInt("TradeIndex"));
        }
        if (message.contains("StartingSlot")) {
            this.selection = message.getInt("StartingSlot");
        }
    }

    public void onTradeButtonInputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof EnergyTradeData) {
            EnergyTradeData t = (EnergyTradeData)trade;
            if (t.isSale()) {
                this.changeSelection(-1);
            } else if (t.isPurchase()) {
                this.changeSelection(0);
            }
        }
    }

    public void onTradeButtonOutputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof EnergyTradeData) {
            EnergyTradeData t = (EnergyTradeData)trade;
            if (t.isSale()) {
                this.changeSelection(0);
            } else if (t.isPurchase()) {
                this.changeSelection(-1);
            }
        }
    }

    private void changeSelection(int newSelection) {
        this.selection = newSelection;
        if (this.selection == -1) {
            this.priceSelection.setCoinValue(((EnergyTradeEditTab)this.commonTab).getTrade().getCost());
        }
        if (this.selection >= 0) {
            this.quantityInput.m_94144_(String.valueOf(((EnergyTradeEditTab)this.commonTab).getTrade().getAmount()));
        }
    }

    public void onTradeButtonInteraction(TraderData trader, TradeData trade, int localMouseX, int localMouseY, int mouseButton) {
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.onInteractionClick((int)mouseX, (int)mouseY, button, (TradeButtonArea.InteractionConsumer)this);
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public void onValueChanged(CoinValue value) {
        ((EnergyTradeEditTab)this.commonTab).setPrice(value);
    }

    public EnergyTradeData getTrade() {
        return ((EnergyTradeEditTab)this.commonTab).getTrade();
    }

    private void ToggleTradeType(EasyButton button) {
        EnergyTradeData trade = this.getTrade();
        if (trade != null) {
            ((EnergyTradeEditTab)this.commonTab).setType(trade.isSale() ? TradeData.TradeDirection.PURCHASE : TradeData.TradeDirection.SALE);
        }
    }
}

