/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lctech.client.util.FluidRenderUtil;
import io.github.lightman314.lctech.common.core.ModBlocks;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidStorageTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class FluidStorageClientTab
extends TraderStorageClientTab<FluidStorageTab>
implements IScrollable,
IMouseListener {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lctech", "textures/gui/fluid_trade_extras.png");
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int TANKS = 8;
    public static final int ENABLED_COLOR = 65280;
    public static final int DISABLED_COLOR = 0xFF0000;
    int scroll = 0;
    ScrollBarWidget scrollBar;

    public FluidStorageClientTab(Object screen, FluidStorageTab tab) {
        super(screen, (TraderStorageTab)tab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.IRON_TANK);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable((String)"tooltip.lightmanscurrency.trader.storage", (Object[])new Object[0]);
    }

    public boolean tabButtonVisible() {
        return true;
    }

    public boolean blockInventoryClosing() {
        return false;
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild((Object)this);
        this.scrollBar = (ScrollBarWidget)this.addChild(new ScrollBarWidget(screenArea.pos.offset(157, 17), 90, (IScrollable)this));
        this.addChild(new ScrollListener(this.screen.getGuiLeft(), this.screen.getGuiTop(), this.screen.getXSize(), 118, (IScrollable)this));
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable((String)"gui.lightmanscurrency.storage", (Object[])new Object[0]), 8, 6, 0x404040);
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            this.validateScroll();
            int index = this.scroll;
            TraderFluidStorage storage = trader.getStorage();
            int yPos = 17;
            for (int x = 0; x < 8 && index < storage.getTanks(); ++index, ++x) {
                int n = 13 + x * 18;
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(index);
                gui.renderItem(FluidItemUtil.getFluidDisplayItem(entry.filter), n + 1, yPos);
                gui.resetColor();
                if (trader.drainCapable()) {
                    gui.blit(GUI_TEXTURE, n + 1, yPos + 16, entry.drainable ? 0 : 8, 0, 8, 8);
                    gui.blit(GUI_TEXTURE, n + 9, yPos + 16, entry.fillable ? 16 : 24, 0, 8, 8);
                }
                gui.blit(GUI_TEXTURE, n, yPos + 24, 0, 16, 18, 66);
                FluidRenderUtil.drawFluidTankInGUI(entry.filter, this.screen.getCorner(), n + 1, yPos + 25, 16, 64, (double)entry.getStoredAmount() / (double)storage.getTankCapacity());
                gui.resetColor();
                gui.blit(GUI_TEXTURE, n, yPos + 24, 18, 16, 18, 66);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)TraderScreen.GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.resetColor();
            for (Slot slot : ((FluidStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 206, 0, 18, 18);
            }
        }
    }

    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        if (this.menu.getTrader() instanceof FluidTraderData) {
            Pair<Integer, Boolean> hoveredToggle;
            TraderFluidStorage storage = ((FluidTraderData)this.menu.getTrader()).getStorage();
            int hoveredSlot = this.isMouseOverTank(gui.mousePos);
            if (hoveredSlot >= 0) {
                if ((hoveredSlot += this.scroll) < 0 || hoveredSlot >= storage.getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(hoveredSlot);
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(FluidFormatUtil.getFluidName(entry.filter));
                tooltips.add(EasyText.literal((String)(FluidFormatUtil.formatFluidAmount(entry.getStoredAmount()) + "mB/" + FluidFormatUtil.formatFluidAmount(storage.getTankCapacity()) + "mB")).m_130940_(ChatFormatting.GRAY));
                if (entry.hasPendingDrain()) {
                    tooltips.add(EasyText.translatable((String)"gui.lctech.fluidtrade.pending_drain", (Object[])new Object[]{FluidFormatUtil.formatFluidAmount(entry.getPendingDrain())}));
                }
                tooltips.add(EasyText.translatable((String)"tooltip.lctech.trader.fluid.fill_tank", (Object[])new Object[0]));
                gui.renderComponentTooltip(tooltips);
            }
            if ((hoveredToggle = this.isMouseOverDrainFill(gui.mousePos)) != null) {
                int tank = (Integer)hoveredToggle.getFirst() + this.scroll;
                boolean drainState = (Boolean)hoveredToggle.getSecond();
                if (tank < 0 || tank >= storage.getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry entry = storage.getContents().get(tank);
                if (drainState) {
                    gui.renderTooltip((Component)EasyText.translatable((String)("tooltip.lctech.trader.fluid_settings.drain." + (entry.drainable ? "enabled" : "disabled")), (Object[])new Object[0]).m_130948_(Style.f_131099_.m_178520_(entry.drainable ? 65280 : 0xFF0000)));
                } else {
                    gui.renderTooltip((Component)EasyText.translatable((String)("tooltip.lctech.trader.fluid_settings.fill." + (entry.fillable ? "enabled" : "disabled")), (Object[])new Object[0]).m_130948_(Style.f_131099_.m_178520_(entry.fillable ? 65280 : 0xFF0000)));
                }
            }
        }
    }

    private Pair<Integer, Boolean> isMouseOverDrainFill(ScreenPosition mousePos) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (!trader.drainCapable()) {
                return null;
            }
            int leftEdge = this.screen.getGuiLeft() + 13;
            int topEdge = this.screen.getGuiTop() + 17 + 16;
            if (mousePos.y < topEdge || mousePos.y >= topEdge + 8) {
                return null;
            }
            for (int x = 0; x < 8; ++x) {
                if (mousePos.x >= leftEdge + x * 18 + 1 && mousePos.x < leftEdge + x * 18 + 9) {
                    return Pair.of((Object)x, (Object)true);
                }
                if (mousePos.x < leftEdge + x * 18 + 9 || mousePos.x >= leftEdge + x * 18 + 17) continue;
                return Pair.of((Object)x, (Object)false);
            }
        }
        return null;
    }

    private int isMouseOverTank(ScreenPosition mousePos) {
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17 + 24;
        if (mousePos.y < topEdge || mousePos.y >= topEdge + 66) {
            return -1;
        }
        for (int x = 0; x < 8; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            return x;
        }
        return -1;
    }

    private int totalTankSlots() {
        if (this.menu.getTrader() instanceof FluidTraderData) {
            return ((FluidTraderData)this.menu.getTrader()).getStorage().getTanks();
        }
        return 0;
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            ScreenPosition mousePos = ScreenPosition.of((double)mouseX, (double)mouseY);
            int hoveredSlot = this.isMouseOverTank(mousePos);
            if (hoveredSlot >= 0) {
                ((FluidStorageTab)this.commonTab).interactWithTank(hoveredSlot += this.scroll, Screen.m_96638_());
                return true;
            }
            Pair<Integer, Boolean> hoveredToggle = this.isMouseOverDrainFill(mousePos);
            if (hoveredToggle != null) {
                int tank = (Integer)hoveredToggle.getFirst() + this.scroll;
                boolean drainState = (Boolean)hoveredToggle.getSecond();
                TraderFluidStorage storage = trader.getStorage();
                if (tank < 0 || tank >= storage.getTanks()) {
                    return false;
                }
                boolean currentState = drainState ? storage.getContents().get((int)tank).drainable : storage.getContents().get((int)tank).fillable;
                ((FluidStorageTab)this.commonTab).toggleDrainFillState(tank, (Boolean)hoveredToggle.getSecond(), !currentState);
                return true;
            }
        }
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public int currentScroll() {
        return this.scroll;
    }

    public int getMaxScroll() {
        return Math.max(0, this.totalTankSlots() - 8);
    }

    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }
}

