/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.client.gui.widget.FluidEditWidget;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidTradeEditTab;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.RegistryObject;

public class FluidTradeEditClientTab
extends TraderStorageClientTab<FluidTradeEditTab>
implements TradeButtonArea.InteractionConsumer,
FluidEditWidget.IFluidEditListener,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 71;
    private static final int COLUMNS = 10;
    private static final int ROWS = 2;
    TradeButton tradeDisplay;
    CoinValueInput priceSelection;
    EasyButton buttonAddBucket;
    EasyButton buttonRemoveBucket;
    FluidEditWidget fluidEdit;
    ScrollBarWidget fluidEditScroll;
    EasyButton buttonToggleTradeType;
    private int selection;

    public FluidTradeEditClientTab(Object screen, FluidTradeEditTab commonTab) {
        super(screen, (TraderStorageTab)commonTab);
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of((RegistryObject)ModItems.TRADING_CORE);
    }

    public MutableComponent getTooltip() {
        return EasyText.empty();
    }

    public boolean tabButtonVisible() {
        return false;
    }

    public boolean blockInventoryClosing() {
        return true;
    }

    public int getTradeRuleTradeIndex() {
        return ((FluidTradeEditTab)this.commonTab).getTradeIndex();
    }

    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(this);
        FluidTradeData trade = this.getTrade();
        this.tradeDisplay = (TradeButton)this.addChild(new TradeButton(() -> ((TraderStorageMenu)this.menu).getContext(), ((FluidTradeEditTab)this.commonTab)::getTrade, button -> {}));
        this.tradeDisplay.setPosition(screenArea.pos.offset(10, 18));
        this.priceSelection = (CoinValueInput)this.addChild(new CoinValueInput(screenArea.pos.offset(screenArea.width / 2 - 88, 40), (Component)EasyText.empty(), trade == null ? CoinValue.EMPTY : trade.getCost(), this.getFont(), this::onValueChanged));
        this.priceSelection.drawBG = false;
        this.fluidEdit = (FluidEditWidget)((Object)this.addChild((Object)new FluidEditWidget(screenArea.pos.offset(13, 71), 10, 2, this)));
        this.fluidEditScroll = (ScrollBarWidget)this.addChild(new ScrollBarWidget(screenArea.pos.offset(193, 71), 36, (IScrollable)this.fluidEdit));
        this.fluidEditScroll.smallKnob = true;
        this.buttonAddBucket = (EasyButton)this.addChild(new IconButton(screenArea.pos.offset(74, 38), this::ChangeQuantity, IconData.of((ResourceLocation)FluidStorageClientTab.GUI_TEXTURE, (int)32, (int)0)));
        this.buttonRemoveBucket = (EasyButton)this.addChild(new IconButton(screenArea.pos.offset(113, 38), this::ChangeQuantity, IconData.of((ResourceLocation)FluidStorageClientTab.GUI_TEXTURE, (int)48, (int)0)));
        this.buttonToggleTradeType = (EasyButton)this.addChild(new EasyTextButton(this.screen.getGuiLeft() + 113, this.screen.getGuiTop() + 15, 80, 20, (Component)EasyText.empty(), this::ToggleTradeType));
    }

    public void closeAction() {
        this.selection = -1;
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.getTrade() == null) {
            return;
        }
        this.validateRenderables();
        if (this.selection >= 0) {
            String quantityText = this.getTrade().getBucketQuantity() + "B";
            int textWidth = gui.font.m_92895_(quantityText);
            gui.drawString(quantityText, 1 + this.screen.getXSize() / 2 - textWidth / 2, 42, 0xFFFFFF);
        }
        gui.resetColor();
        gui.blit(TraderScreen.GUI_TEXTURE, this.getArrowPosition(), 10, 214, 18, 8, 6);
    }

    private int getArrowPosition() {
        FluidTradeData trade = this.getTrade();
        if (this.selection == -1) {
            if (trade.isSale()) {
                return 25;
            }
            return 63;
        }
        if (trade.isSale()) {
            return 72;
        }
        return 16;
    }

    private void validateRenderables() {
        this.priceSelection.f_93624_ = this.selection < 0;
        this.fluidEdit.f_93624_ = this.selection >= 0;
        this.buttonRemoveBucket.f_93624_ = this.selection >= 0;
        this.buttonAddBucket.f_93624_ = this.buttonRemoveBucket.f_93624_;
        if (this.buttonAddBucket.f_93624_) {
            boolean bl = this.buttonAddBucket.f_93623_ = this.getTrade().getBucketQuantity() < this.getTrade().getMaxBucketQuantity();
        }
        if (this.buttonRemoveBucket.f_93624_) {
            this.buttonRemoveBucket.f_93623_ = this.getTrade().getBucketQuantity() > 1;
        }
        this.buttonToggleTradeType.m_93666_((Component)EasyText.translatable((String)("gui.button.lightmanscurrency.tradedirection." + this.getTrade().getTradeDirection().name().toLowerCase()), (Object[])new Object[0]));
    }

    public void receiveSelfMessage(LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            ((FluidTradeEditTab)this.commonTab).setTradeIndex(message.getInt("TradeIndex"));
        }
        if (message.contains("StartingSlot")) {
            this.selection = message.getInt("StartingSlot");
        }
    }

    public void onTradeButtonInputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof FluidTradeData) {
            FluidTradeData t = (FluidTradeData)trade;
            ItemStack heldItem = this.menu.m_142621_();
            if (t.isSale()) {
                this.changeSelection(-1);
            } else if (t.isPurchase()) {
                if (this.selection != 0 && heldItem.m_41619_()) {
                    this.changeSelection(0);
                } else {
                    ((FluidTradeEditTab)this.commonTab).setFluid(FluidUtil.getFluidContained((ItemStack)heldItem).orElse(FluidStack.EMPTY));
                }
            }
        }
    }

    public void onTradeButtonOutputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof FluidTradeData) {
            FluidTradeData t = (FluidTradeData)trade;
            ItemStack heldItem = this.menu.m_142621_();
            if (t.isSale()) {
                if (this.selection != 0 && heldItem.m_41619_()) {
                    this.changeSelection(0);
                } else {
                    ((FluidTradeEditTab)this.commonTab).setFluid(FluidUtil.getFluidContained((ItemStack)heldItem).orElse(FluidStack.EMPTY));
                }
            } else if (t.isPurchase()) {
                this.changeSelection(-1);
            }
        }
    }

    private void changeSelection(int newSelection) {
        this.selection = newSelection;
        if (this.selection == -1) {
            this.priceSelection.setCoinValue(this.getTrade().getCost());
        }
        if (this.selection == 0 && !this.getTrade().isSale()) {
            this.fluidEdit.refreshSearch();
        }
    }

    public void onTradeButtonInteraction(TraderData trader, TradeData trade, int localMouseX, int localMouseY, int mouseButton) {
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.onInteractionClick((int)mouseX, (int)mouseY, button, (TradeButtonArea.InteractionConsumer)this);
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public void onValueChanged(CoinValue value) {
        ((FluidTradeEditTab)this.commonTab).setPrice(value);
    }

    public FluidTradeData getTrade() {
        return ((FluidTradeEditTab)this.commonTab).getTrade();
    }

    @Override
    public void onFluidClicked(FluidStack fluid) {
        ((FluidTradeEditTab)this.commonTab).setFluid(fluid);
    }

    private void ChangeQuantity(EasyButton button) {
        if (this.getTrade() != null) {
            int deltaQuantity = 1;
            if (button == this.buttonRemoveBucket) {
                deltaQuantity = -1;
            }
            ((FluidTradeEditTab)this.commonTab).setQuantity(this.getTrade().getBucketQuantity() + deltaQuantity);
        }
    }

    private void ToggleTradeType(EasyButton button) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            ((FluidTradeEditTab)this.commonTab).setType(trade.isSale() ? TradeData.TradeDirection.PURCHASE : TradeData.TradeDirection.SALE);
        }
    }
}

