/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.gui.widget;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidEditWidget
extends EasyWidgetWithChildren
implements IScrollable,
ITooltipSource {
    private static final List<Fluid> BLACKLISTED_FLUIDS = Lists.newArrayList((Object[])new Fluid[]{Fluids.f_76191_});
    private int scroll = 0;
    private final int columns;
    private final int rows;
    private final int searchOffX;
    private final int searchOffY;
    private static List<Fluid> allFluids = null;
    List<Fluid> searchResultFluids;
    private String searchString;
    EditBox searchInput;
    private final IFluidEditListener listener;
    private final Font font;

    public static void BlacklistFluid(Fluid fluid) {
        if (!BLACKLISTED_FLUIDS.contains(fluid)) {
            BLACKLISTED_FLUIDS.add(fluid);
        }
    }

    public FluidEditWidget(ScreenPosition pos, int columns, int rows, IFluidEditListener listener) {
        this(pos.x, pos.y, columns, rows, listener);
    }

    public FluidEditWidget(int x, int y, int columns, int rows, IFluidEditListener listener) {
        super(x, y, columns * 18, rows * 18);
        this.listener = listener;
        this.columns = columns;
        this.rows = rows;
        this.searchOffX = this.f_93618_ - 90;
        this.searchOffY = -13;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        this.modifySearch("");
    }

    public FluidEditWidget withAddons(WidgetAddon ... widgetAddons) {
        this.withAddonsInternal(widgetAddons);
        return this;
    }

    public static void initFluidList() {
        if (allFluids != null) {
            return;
        }
        allFluids = Lists.newArrayList();
        ForgeRegistries.FLUIDS.forEach(fluid -> {
            if (!BLACKLISTED_FLUIDS.contains(fluid) && fluid.m_7444_(fluid.m_76145_())) {
                allFluids.add((Fluid)fluid);
            }
        });
    }

    public int getMaxScroll() {
        return Math.max((this.searchResultFluids.size() - 1) / this.columns - this.rows + 1, 0);
    }

    public void refreshPage() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    public void refreshSearch() {
        this.modifySearch(this.searchString);
    }

    public void modifySearch(String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (this.searchString.length() > 0) {
            this.searchResultFluids = Lists.newArrayList();
            for (Fluid fluid : allFluids) {
                if (fluid.getAttributes().getDisplayName(new FluidStack(fluid, 1000)).getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultFluids.add(fluid);
                    continue;
                }
                if (!ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fluid).toString().contains(this.searchString)) continue;
                this.searchResultFluids.add(fluid);
            }
        } else {
            this.searchResultFluids = allFluids;
        }
    }

    public void addChildren() {
        this.searchInput = (EditBox)this.addChild(new EditBox(this.font, this.getX() + this.searchOffX + 2, this.getY() + this.searchOffY + 2, 79, 9, (Component)EasyText.translatable((String)"gui.lightmanscurrency.item_edit.search", (Object[])new Object[0])));
        this.searchInput.m_94182_(false);
        this.searchInput.m_94199_(32);
        this.searchInput.m_94202_(0xFFFFFF);
        this.searchInput.m_94151_(this::modifySearch);
    }

    protected void renderTick() {
        this.searchInput.f_93624_ = this.f_93624_;
    }

    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        int index = this.scroll * this.columns;
        for (int y = 0; y < this.rows && index < this.searchResultFluids.size(); ++y) {
            int yPos = y * 18;
            for (int x = 0; x < this.columns && index < this.searchResultFluids.size(); ++index, ++x) {
                int xPos = x * 18;
                gui.resetColor();
                gui.blit(ItemEditWidget.GUI_TEXTURE, xPos, yPos, 0, 0, 18, 18);
                gui.renderItem(FluidItemUtil.getFluidDispayItem(this.searchResultFluids.get(index)), xPos + 1, yPos + 1);
            }
        }
        gui.resetColor();
        gui.blit(ItemEditWidget.GUI_TEXTURE, this.searchOffX, this.searchOffY, 18, 0, 90, 12);
    }

    public List<Component> getTooltipText(int mouseX, int mouseY) {
        if (!this.f_93624_) {
            return null;
        }
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultFluids.size()) {
            return Lists.newArrayList((Object[])new Component[]{FluidFormatUtil.getFluidName(new FluidStack(this.searchResultFluids.get(hoveredSlot), 1000))});
        }
        return null;
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(this.getX() + x * 18)) || !(mouseX < (double)(this.getX() + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < this.rows && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(this.getY() + y * 18)) || !(mouseY < (double)(this.getY() + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultFluids.size()) {
            FluidStack fluid = new FluidStack(this.searchResultFluids.get(hoveredSlot), 1000);
            this.listener.onFluidClicked(fluid);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll >= this.getMaxScroll()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    public int currentScroll() {
        return this.scroll;
    }

    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.refreshPage();
    }

    public static interface IFluidEditListener {
        public void onFluidClicked(FluidStack var1);
    }
}

