/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.util;

import io.github.lightman314.lctech.client.util.FluidSides;
import io.github.lightman314.lightmanscurrency.util.MathUtil;

public class FluidRenderData {
    public final float x;
    public final float y;
    public final float z;
    public final float width;
    public final float height;
    public final float depth;
    public final FluidSides sides;
    private float fillPercent = 1.0f;

    public final float getHeight() {
        return this.height * this.fillPercent;
    }

    public void setFillPercent(float fillPercent) {
        this.fillPercent = MathUtil.clamp((float)fillPercent, (float)0.0f, (float)1.0f);
    }

    private FluidRenderData(float x, float y, float z, float width, float height, float depth, FluidSides sides) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.sides = sides;
    }

    public FluidRenderData withSides(FluidSides sidesOverride) {
        return new FluidRenderData(this.x, this.y, this.z, this.width, this.height, this.depth, sidesOverride);
    }

    public FluidRenderData withSides(boolean shouldOverride, FluidSides sidesOverride) {
        return shouldOverride ? this.withSides(sidesOverride) : this;
    }

    public FluidRenderData withSides(boolean overrideFlag, FluidSides sidesOverride1, FluidSides sidesOverride2) {
        return overrideFlag ? this.withSides(sidesOverride1) : this.withSides(sidesOverride2);
    }

    public static FluidRenderData CreateFluidRender(float x, float y, float z, float width, float height, float depth) {
        return FluidRenderData.CreateFluidRender(x, y, z, width, height, depth, FluidSides.ALL);
    }

    public static FluidRenderData CreateFluidRender(float x, float y, float z, float width, float height, float depth, FluidSides sides) {
        return new FluidRenderData(x / 16.0f, y / 16.0f, z / 16.0f, width / 16.0f, height / 16.0f, depth / 16.0f, sides);
    }
}

