/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.util;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import io.github.lightman314.lctech.client.util.FluidRenderData;
import io.github.lightman314.lctech.client.util.FluidSides;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class FluidRenderUtil {
    public static void drawFluidTankInGUI(FluidStack tank, ScreenPosition corner, int x, int y, int width, int height, double percent) {
        FluidRenderUtil.drawFluidTankInGUI(tank, corner.x + x, corner.y + y, width, height, percent);
    }

    public static void drawFluidTankInGUI(FluidStack tank, int x, int y, int width, int height, double percent) {
        if (tank == null || tank.isEmpty()) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(tank.getFluid().getAttributes().getStillTexture());
        if (sprite != null) {
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            float deltaU = maxU - minU;
            float deltaV = maxV - minV;
            double tankLevel = Math.min(1.0, percent) * (double)height;
            int waterColor = tank.getFluid().getAttributes().getColor(tank);
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.m_69478_();
            int xCount = 1 + width / 16;
            int count = 1 + (int)Math.ceil(tankLevel) / 16;
            for (int z = 0; z < xCount; ++z) {
                double subWidth = Math.min(16.0, (double)(width - 16 * z));
                double offsetX = (double)width - 16.0 * (double)z - subWidth;
                for (int i = 0; i < count; ++i) {
                    double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                    double offsetY = (double)height - 16.0 * (double)i - subHeight;
                    FluidRenderUtil.drawQuad((double)x + offsetX, (double)y + offsetY, subWidth, subHeight, (float)((double)maxU - (double)deltaU * (subWidth / 16.0)), (float)((double)maxV - (double)deltaV * (subHeight / 16.0)), maxU, maxV, red, green, blue);
                }
            }
            RenderSystem.m_69461_();
        }
    }

    private static void drawQuad(double x, double y, double width, double height, float minU, float minV, float maxU, float maxV, float red, float green, float blue) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(x, y + height, 0.0).m_7421_(minU, maxV).m_5752_();
        buffer.m_5483_(x + width, y + height, 0.0).m_7421_(maxU, maxV).m_5752_();
        buffer.m_5483_(x + width, y, 0.0).m_7421_(maxU, minV).m_5752_();
        buffer.m_5483_(x, y, 0.0).m_7421_(minU, minV).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawFluidInWorld(FluidStack tank, Level world, BlockPos pos, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidRenderData renderData, int light) {
        FluidRenderUtil.drawFluidInWorld(tank, world, pos, matrixStack, renderTypeBuffer, renderData.x, renderData.y, renderData.z, renderData.width, renderData.height, renderData.depth, renderData.getHeight(), light, renderData.sides);
    }

    public static void drawFluidInWorld(FluidStack tank, Level world, BlockPos pos, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, float x, float y, float z, float width, float top, float depth, float height, int light, FluidSides sides) {
        if (tank == null || tank.isEmpty()) {
            return;
        }
        TextureAtlasSprite sprite = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)world, (BlockPos)pos, (FluidState)tank.getFluid().m_76145_())[0];
        int waterColor = tank.getFluid().getAttributes().getColor(tank);
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        float minU = sprite.m_118409_();
        float maxU = Math.min(minU + (sprite.m_118410_() - minU) * depth, sprite.m_118410_());
        float minV = sprite.m_118411_();
        float maxV = Math.min(minV + (sprite.m_118412_() - minV) * height, sprite.m_118412_());
        float x2 = x + width;
        float y2 = y + height;
        float z2 = z + depth;
        if (tank.getFluid().getAttributes().isLighterThanAir()) {
            y2 = top;
            y = y2 - height;
        }
        VertexConsumer buffer = renderTypeBuffer.m_6299_(RenderType.m_110466_());
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        if (sides.test(Direction.WEST)) {
            buffer.m_85982_(matrix, x2, y, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y, z).m_85950_(red, green, blue, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y2, z).m_85950_(red, green, blue, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (sides.test(Direction.EAST)) {
            buffer.m_85982_(matrix, x, y, z2).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y2, z2).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        maxU = Math.min(minU + (sprite.m_118410_() - minU), sprite.m_118410_());
        if (sides.test(Direction.SOUTH)) {
            buffer.m_85982_(matrix, x2, y, z2).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y, z).m_85950_(red, green, blue, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z).m_85950_(red, green, blue, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (sides.test(Direction.NORTH)) {
            buffer.m_85982_(matrix, x, y, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y2, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y2, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        maxV = Math.min(minV + (sprite.m_118412_() - minV), sprite.m_118412_());
        if (sides.test(Direction.UP)) {
            buffer.m_85982_(matrix, x, y2, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y2, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (sides.test(Direction.DOWN)) {
            buffer.m_85982_(matrix, x2, y, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x2, y, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y, z2).m_85950_(red, green, blue, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, x, y, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        }
    }

    public static List<BakedQuad> getBakedFluidQuads(FluidStack tank, int capacity, FluidRenderData renderData) {
        if (tank.isEmpty()) {
            return Lists.newArrayList();
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(tank.getFluid().getAttributes().getStillTexture());
        int fluidColor = tank.getFluid().getAttributes().getColor(tank);
        if (fluidColor != -1) {
            int red = fluidColor >> 16 & 0xFF;
            int green = fluidColor >> 8 & 0xFF;
            int blue = fluidColor & 0xFF;
            fluidColor = 0xFF000000 | red | green << 8 | blue << 16;
        }
        double fillPercent = MathUtil.clamp((double)((double)tank.getAmount() / (double)capacity), (double)0.0, (double)1.0);
        renderData.setFillPercent((float)fillPercent);
        boolean inverted = tank.getFluid().getAttributes().isLighterThanAir();
        boolean ITEM_RENDER_LAYER0 = false;
        ArrayList returnList = Lists.newArrayList();
        int color = fluidColor;
        renderData.sides.forEach(face -> {
            BakedQuad faceQuad = FluidRenderUtil.createBakedQuadForFace(renderData, 0, color, sprite, face, inverted);
            returnList.add(faceQuad);
        });
        return returnList;
    }

    private static BakedQuad createBakedQuadForFace(FluidRenderData data, int itemRenderLayer, int fluidColor, TextureAtlasSprite texture, Direction face, boolean inverted) {
        float y1;
        float y2;
        float y3;
        float y4;
        float z2;
        float z3;
        float z1;
        float z4;
        float x3;
        float x4;
        float x1;
        float x2;
        float bottom = data.y;
        float top = bottom + data.getHeight();
        if (inverted) {
            top = data.y + data.height;
            bottom = top - data.getHeight();
        }
        switch (face) {
            case UP: {
                x1 = x2 = data.x + data.width;
                x3 = x4 = data.x;
                z1 = z4 = data.z + data.depth;
                z2 = z3 = data.z;
                y3 = y4 = top;
                y2 = y4;
                y1 = y4;
                break;
            }
            case DOWN: {
                x1 = x2 = data.x + data.width;
                x3 = x4 = data.x;
                z1 = z4 = data.z;
                z2 = z3 = data.z + data.depth;
                y3 = y4 = bottom;
                y2 = y4;
                y1 = y4;
                break;
            }
            case WEST: {
                z1 = z2 = data.z + data.depth;
                z3 = z4 = data.z;
                y1 = y4 = bottom;
                y2 = y3 = top;
                x3 = x4 = data.x;
                x2 = x4;
                x1 = x4;
                break;
            }
            case EAST: {
                z1 = z2 = data.z;
                z3 = z4 = data.z + data.depth;
                y1 = y4 = bottom;
                y2 = y3 = top;
                x3 = x4 = data.x + data.width;
                x2 = x4;
                x1 = x4;
                break;
            }
            case NORTH: {
                x1 = x2 = data.x;
                x3 = x4 = data.x + data.width;
                y1 = y4 = bottom;
                y2 = y3 = top;
                z3 = z4 = data.z;
                z2 = z4;
                z1 = z4;
                break;
            }
            case SOUTH: {
                x1 = x2 = data.x + data.width;
                x3 = x4 = data.x;
                y1 = y4 = bottom;
                y2 = y3 = top;
                z3 = z4 = data.z + data.depth;
                z2 = z4;
                z1 = z4;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected Direction in createBakedQuadForFace:" + face));
            }
        }
        int packednormal = FluidRenderUtil.calculatePackedNormal(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        int BLOCK_LIGHT = 15;
        int SKY_LIGHT = 15;
        int lightMapValue = LightTexture.m_109885_((int)15, (int)15);
        boolean minU = false;
        int maxU = 16;
        boolean minV = false;
        int maxV = 16;
        int[] vertexData1 = FluidRenderUtil.vertexToInts(x1, y1, z1, fluidColor, texture, 16.0f, 16.0f, lightMapValue, packednormal);
        int[] vertexData2 = FluidRenderUtil.vertexToInts(x2, y2, z2, fluidColor, texture, 16.0f, 0.0f, lightMapValue, packednormal);
        int[] vertexData3 = FluidRenderUtil.vertexToInts(x3, y3, z3, fluidColor, texture, 0.0f, 0.0f, lightMapValue, packednormal);
        int[] vertexData4 = FluidRenderUtil.vertexToInts(x4, y4, z4, fluidColor, texture, 0.0f, 16.0f, lightMapValue, packednormal);
        int[] vertexDataAll = Ints.concat((int[][])new int[][]{vertexData1, vertexData2, vertexData3, vertexData4});
        boolean APPLY_DIFFUSE_LIGHTING = true;
        return new BakedQuad(vertexDataAll, itemRenderLayer, face, texture, true);
    }

    private static int calculatePackedNormal(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        float xp = x4 - x2;
        float yp = y4 - y2;
        float zp = z4 - z2;
        float xq = x3 - x1;
        float yq = y3 - y1;
        float zq = z3 - z1;
        float xn = yq * zp - zq * yp;
        float yn = zq * xp - xq * zp;
        float zn = xq * yp - yq * xp;
        float norm = (float)Math.sqrt(xn * xn + yn * yn + zn * zn);
        float SMALL_LENGTH = 1.0E-4f;
        if (norm < 1.0E-4f) {
            norm = 1.0f;
        }
        norm = 1.0f / norm;
        int x = (byte)((xn *= norm) * 127.0f) & 0xFF;
        int y = (byte)((yn *= norm) * 127.0f) & 0xFF;
        int z = (byte)((zn *= norm) * 127.0f) & 0xFF;
        return x | y << 8 | z << 16;
    }

    private static int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v, int lightmapvalue, int normal) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.m_118367_((double)u)), Float.floatToRawIntBits(texture.m_118393_((double)v)), lightmapvalue, normal};
    }
}

