/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.client.util;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Direction;

public class FluidSides {
    public static final FluidSides ALL = FluidSides.Create(Direction.values());
    public static final FluidSides NO_TOP = FluidSides.Create((Direction side) -> side != Direction.UP);
    public static final FluidSides NO_BOTTOM = FluidSides.Create((Direction side) -> side != Direction.DOWN);
    public static final FluidSides NO_TOP_OR_BOTTOM = FluidSides.Create((Direction side) -> !side.m_122434_().m_122478_());
    private final EnumMap<Direction, Boolean> map = new EnumMap(Direction.class);

    public static FluidSides Create(Direction ... sides) {
        return new FluidSides(sides);
    }

    public static FluidSides Create(Predicate<Direction> allowSide) {
        return new FluidSides(Stream.of(Direction.values()).filter(allowSide).toList());
    }

    private FluidSides(Iterable<Direction> sides) {
        Stream.of(Direction.values()).forEach((? super T direction) -> this.map.put((Direction)direction, false));
        sides.forEach((? super T direction) -> this.map.put((Direction)direction, true));
    }

    private FluidSides(Direction ... sides) {
        this(Lists.newArrayList((Object[])sides));
    }

    public boolean test(Direction direction) {
        return this.map.get(direction);
    }

    public void forEach(Consumer<Direction> consumer) {
        for (Direction side : Direction.values()) {
            if (!this.test(side)) continue;
            consumer.accept(side);
        }
    }
}

