/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.core;

import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.common.blocks.FluidTankBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.EnergyTraderBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.FluidTapBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.FluidTapBundleBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.NetworkEnergyTraderBlock;
import io.github.lightman314.lctech.common.blocks.traderblocks.NetworkFluidTraderBlock;
import io.github.lightman314.lctech.common.blocks.traderinterface.EnergyTraderInterfaceBlock;
import io.github.lightman314.lctech.common.blocks.traderinterface.FluidTraderInterfaceBlock;
import io.github.lightman314.lctech.common.core.ModRegistries;
import io.github.lightman314.lctech.common.items.FluidTankItem;
import io.github.lightman314.lightmanscurrency.ModCreativeGroups;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final RegistryObject<Block> IRON_TANK = ModBlocks.register("iron_tank", ModCreativeGroups::getMachineGroup, ModBlocks.getFluidTankGenerator(), () -> new FluidTankBlock(() -> (Integer)TechConfig.SERVER.ironTankCapacity.get() * 1000, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> GOLD_TANK = ModBlocks.register("gold_tank", ModCreativeGroups::getMachineGroup, ModBlocks.getFluidTankGenerator(), () -> new FluidTankBlock(() -> (Integer)TechConfig.SERVER.goldTankCapacity.get() * 1000, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_155949_(MaterialColor.f_76366_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> DIAMOND_TANK = ModBlocks.register("diamond_tank", ModCreativeGroups::getMachineGroup, ModBlocks.getFluidTankGenerator(), () -> new FluidTankBlock(() -> (Integer)TechConfig.SERVER.diamondTankCapacity.get() * 1000, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_155949_(MaterialColor.f_76367_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> FLUID_TAP = ModBlocks.register("fluid_tap", ModCreativeGroups::getTradingGroup, () -> new FluidTapBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)));
    public static final RegistryObject<Block> FLUID_TAP_BUNDLE = ModBlocks.register("fluid_tap_bundle", ModCreativeGroups::getTradingGroup, () -> new FluidTapBundleBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_1 = ModBlocks.register("fluid_trader_server_sml", ModCreativeGroups::getTradingGroup, () -> new NetworkFluidTraderBlock(2, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76361_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_2 = ModBlocks.register("fluid_trader_server_med", ModCreativeGroups::getTradingGroup, () -> new NetworkFluidTraderBlock(4, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76361_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_3 = ModBlocks.register("fluid_trader_server_lrg", ModCreativeGroups::getTradingGroup, () -> new NetworkFluidTraderBlock(6, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76361_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_NETWORK_TRADER_4 = ModBlocks.register("fluid_trader_server_xlrg", ModCreativeGroups::getTradingGroup, () -> new NetworkFluidTraderBlock(8, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76361_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> FLUID_TRADER_INTERFACE = ModBlocks.register("fluid_trader_interface", ModCreativeGroups::getMachineGroup, () -> new FluidTraderInterfaceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76361_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> BATTERY_SHOP = ModBlocks.register("battery_shop", ModCreativeGroups::getTradingGroup, () -> new EnergyTraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76419_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ENERGY_NETWORK_TRADER = ModBlocks.register("energy_trader_server", ModCreativeGroups::getTradingGroup, () -> new NetworkEnergyTraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76419_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ENERGY_TRADER_INTERFACE = ModBlocks.register("energy_trader_interface", ModCreativeGroups::getMachineGroup, () -> new EnergyTraderInterfaceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76419_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));

    public static void init() {
    }

    private static Item.Properties propertiesForGroup(CreativeModeTab tab) {
        Item.Properties p = new Item.Properties();
        if (tab != null) {
            p.m_41491_(tab);
        }
        return p;
    }

    private static BiFunction<Block, CreativeModeTab, Item> getDefaultGenerator() {
        return (block, tab) -> new BlockItem(block, ModBlocks.propertiesForGroup(tab));
    }

    private static BiFunction<Block, CreativeModeTab, Item> getFluidTankGenerator() {
        return (block, tab) -> new FluidTankItem((Block)block, ModBlocks.propertiesForGroup(tab));
    }

    private static RegistryObject<Block> register(String name, Supplier<CreativeModeTab> tab, Supplier<Block> sup) {
        return ModBlocks.register(name, tab, ModBlocks.getDefaultGenerator(), sup);
    }

    private static RegistryObject<Block> register(String name, Supplier<CreativeModeTab> tab, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Supplier<Block> sup) {
        RegistryObject block = ModRegistries.BLOCKS.register(name, sup);
        if (block != null) {
            ModRegistries.ITEMS.register(name, () -> (Item)itemGenerator.apply((Block)block.get(), tab == null ? null : (CreativeModeTab)tab.get()));
        }
        return block;
    }
}

