/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import io.github.lightman314.lctech.common.items.IBatteryItem;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BatteryItem
extends Item
implements IBatteryItem {
    private final Supplier<Integer> maxEnergyStorage;

    @Override
    public int getMaxEnergyStorage(ItemStack stack) {
        return this.maxEnergyStorage.get();
    }

    public BatteryItem(Supplier<Integer> maxEnergyStorage, Item.Properties properties) {
        super(properties.m_41487_(1));
        this.maxEnergyStorage = maxEnergyStorage;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)new TextComponent(EnergyUtil.formatEnergyAmount(IBatteryItem.getStoredEnergy(stack)) + "/" + EnergyUtil.formatEnergyAmount(this.getMaxEnergyStorage(stack))).m_130940_(ChatFormatting.AQUA));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return IBatteryItem.createCapability(stack);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return IBatteryItem.isEnergyBarVisible(stack);
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.round((float)Math.min(IBatteryItem.getStoredEnergy(stack), this.getMaxEnergyStorage(stack)) * 13.0f / (float)this.getMaxEnergyStorage(stack));
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return ChatFormatting.AQUA.m_126665_();
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            list.add((Object)new ItemStack((ItemLike)this));
            list.add((Object)IBatteryItem.getFullBattery(this));
        }
    }
}

