/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderinterface.energy;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.energy.EnergyStorageClientTab;
import io.github.lightman314.lctech.common.blockentities.EnergyTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.menu.slots.BatteryInputSlot;
import io.github.lightman314.lctech.common.menu.util.MenuUtil;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnergyStorageTab
extends TraderInterfaceTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();
    BatteryInputSlot inputSlot;
    Container batterySlots = new SimpleContainer(2);

    public EnergyStorageTab(TraderInterfaceMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TraderInterfaceClientTab<?> createClientTab(TraderInterfaceScreen screen) {
        return new EnergyStorageClientTab(screen, this);
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.inputSlot.locked = false;
    }

    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.inputSlot.locked = true;
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        for (int i = 0; i < this.menu.getBE().getUpgradeInventory().m_6643_(); ++i) {
            UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(this.menu.getBE().getUpgradeInventory(), i, 176, 18 + 18 * i, (UpgradeType.IUpgradeable)this.menu.getBE());
            upgradeSlot.active = false;
            upgradeSlot.setListener(this::onUpgradeModified);
            addSlot.apply((Slot)upgradeSlot);
            this.slots.add((SimpleSlot)upgradeSlot);
        }
        this.inputSlot = new BatteryInputSlot(this.batterySlots, 0, 23, 122);
        this.slots.add(this.inputSlot);
        addSlot.apply((Slot)this.inputSlot);
        this.inputSlot.locked = true;
        OutputSlot outputSlot = new OutputSlot(this.batterySlots, 1, 59, 122);
        this.slots.add((SimpleSlot)outputSlot);
        addSlot.apply((Slot)outputSlot);
        SimpleSlot.SetInactive(this.slots);
    }

    private void onUpgradeModified() {
        this.menu.getBE().setUpgradeSlotsDirty();
    }

    public void onMenuClose() {
        MenuUtil.clearContainer(this.menu.player, this.batterySlots);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (event.side.isServer() && event.phase == TickEvent.Phase.START && (traderInterfaceBlockEntity = this.menu.getBE()) instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            if (!this.batterySlots.m_8020_(0).m_41619_() && this.batterySlots.m_8020_(1).m_41619_()) {
                ItemStack batteryStack = this.batterySlots.m_8020_(0);
                ItemStack batteryOutput = this.batteryInteraction(be, batteryStack);
                if (batteryStack.m_41613_() > 1) {
                    batteryStack.m_41774_(1);
                } else {
                    batteryStack = ItemStack.f_41583_;
                }
                this.batterySlots.m_6836_(0, batteryStack);
                this.batterySlots.m_6836_(1, batteryOutput);
            }
        }
    }

    private ItemStack batteryInteraction(EnergyTraderInterfaceBlockEntity be, ItemStack batteryStack) {
        EnergyUtil.EnergyActionResult result = EnergyUtil.tryEmptyContainer(batteryStack, be.getEnergyHandler().tradeHandler, Integer.MAX_VALUE, true);
        if (result.success()) {
            return result.getResult();
        }
        result = EnergyUtil.tryFillContainer(batteryStack, be.getEnergyHandler().tradeHandler, Integer.MAX_VALUE, true);
        if (result.success()) {
            return result.getResult();
        }
        return batteryStack;
    }

    public void toggleInputSlot(Direction side) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (this.menu.getBE().isOwner(this.menu.player) && (traderInterfaceBlockEntity = this.menu.getBE()) instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            be.getEnergyHandler().toggleInputSide(side);
            be.setHandlerDirty((SidedHandler)be.getEnergyHandler());
        }
    }

    public void toggleOutputSlot(Direction side) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (this.menu.getBE().isOwner(this.menu.player) && (traderInterfaceBlockEntity = this.menu.getBE()) instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            be.getEnergyHandler().toggleOutputSide(side);
            be.setHandlerDirty((SidedHandler)be.getEnergyHandler());
        }
    }

    public void receiveMessage(CompoundTag message) {
    }
}

