/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderinterface.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.common.blockentities.FluidTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidStorageTab
extends TraderInterfaceTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();

    public FluidStorageTab(TraderInterfaceMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TraderInterfaceClientTab<?> createClientTab(TraderInterfaceScreen screen) {
        return new FluidStorageClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
    }

    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        for (int i = 0; i < this.menu.getBE().getUpgradeInventory().m_6643_(); ++i) {
            UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(this.menu.getBE().getUpgradeInventory(), i, 176, 18 + 18 * i, (UpgradeType.IUpgradeable)this.menu.getBE());
            upgradeSlot.active = false;
            upgradeSlot.setListener(this::onUpgradeModified);
            addSlot.apply((Slot)upgradeSlot);
            this.slots.add((SimpleSlot)upgradeSlot);
        }
    }

    private void onUpgradeModified() {
        this.menu.getBE().setUpgradeSlotsDirty();
    }

    public void interactWithTank(int tank, boolean shiftHeld) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = this.menu.getBE();
        if (traderInterfaceBlockEntity instanceof FluidTraderInterfaceBlockEntity) {
            ItemStack heldStack;
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("InteractWithTank", tank);
                message.m_128379_("ShiftHeld", shiftHeld);
                this.menu.sendMessage(message);
            }
            if ((heldStack = this.menu.m_142621_()).m_41619_()) {
                return;
            }
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldStack, (IFluidHandler)be.getFluidBuffer(), (int)Integer.MAX_VALUE, (Player)this.menu.player, (boolean)true);
            if (result.isSuccess()) {
                if (this.menu.player.m_7500_() && result.getResult().m_41720_() == Items.f_42446_) {
                    if (shiftHeld) {
                        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldStack).orElse(FluidStack.EMPTY);
                        TraderFluidStorage.FluidEntry entry = be.getFluidBuffer().getTank(fluid);
                        if (entry != null) {
                            entry.setAmount(be.getTankCapacity());
                        }
                    }
                    be.setFluidBufferDirty();
                    return;
                }
                be.setFluidBufferDirty();
                if (heldStack.m_41613_() > 1) {
                    heldStack.m_41774_(1);
                    this.menu.m_142503_(heldStack);
                    ItemHandlerHelper.giveItemToPlayer((Player)this.menu.player, (ItemStack)result.getResult());
                } else {
                    this.menu.m_142503_(result.getResult());
                }
            } else {
                if (tank < 0 || tank >= be.getFluidBuffer().getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry tankEntry = be.getFluidBuffer().getContents().get(tank);
                result = FluidUtil.tryFillContainer((ItemStack)heldStack, (IFluidHandler)tankEntry, (int)Integer.MAX_VALUE, (Player)this.menu.player, (boolean)true);
                if (result.isSuccess()) {
                    if (this.menu.player.m_7500_() && heldStack.m_41720_() == Items.f_42446_) {
                        if (shiftHeld) {
                            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)result.getResult()).orElse(FluidStack.EMPTY);
                            TraderFluidStorage.FluidEntry entry = be.getFluidBuffer().getTank(fluid);
                            if (entry != null) {
                                entry.setAmount(0);
                            }
                        }
                        be.getFluidBuffer().clearInvalidTanks();
                        be.setFluidBufferDirty();
                        return;
                    }
                    be.getFluidBuffer().clearInvalidTanks();
                    be.setFluidBufferDirty();
                    if (heldStack.m_41613_() > 1) {
                        heldStack.m_41774_(1);
                        this.menu.m_142503_(heldStack);
                        ItemHandlerHelper.giveItemToPlayer((Player)this.menu.player, (ItemStack)result.getResult());
                    } else {
                        this.menu.m_142503_(result.getResult());
                    }
                }
            }
        }
    }

    public void toggleInputSlot(Direction side) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (this.menu.getBE().isOwner(this.menu.player) && (traderInterfaceBlockEntity = this.menu.getBE()) instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            be.getFluidHandler().toggleInputSide(side);
            be.setHandlerDirty((SidedHandler)be.getFluidHandler());
        }
    }

    public void toggleOutputSlot(Direction side) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (this.menu.getBE().isOwner(this.menu.player) && (traderInterfaceBlockEntity = this.menu.getBE()) instanceof FluidTraderInterfaceBlockEntity) {
            FluidTraderInterfaceBlockEntity be = (FluidTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            be.getFluidHandler().toggleOutputSide(side);
            be.setHandlerDirty((SidedHandler)be.getFluidHandler());
        }
    }

    public void receiveMessage(CompoundTag message) {
        if (message.m_128425_("InteractWithTank", 3)) {
            this.interactWithTank(message.m_128451_("InteractWithTank"), message.m_128471_("ShiftHeld"));
        }
    }
}

