/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidStorageTab
extends TraderStorageTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();

    public FluidStorageTab(TraderStorageMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new FluidStorageClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            for (int i = 0; i < trader.getUpgrades().m_6643_(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(trader.getUpgrades(), i, 176, 18 + 18 * i, (UpgradeType.IUpgradeable)trader);
                upgradeSlot.active = false;
                addSlot.apply((Slot)upgradeSlot);
                this.slots.add((SimpleSlot)upgradeSlot);
            }
        }
    }

    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
    }

    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
    }

    public void interactWithTank(int tank, boolean shiftHeld) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.builder().setInt("InteractWithTank", tank).setBoolean("ShiftHeld", shiftHeld));
                return;
            }
            ItemStack heldStack = this.menu.m_142621_();
            if (heldStack.m_41619_()) {
                return;
            }
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldStack, (IFluidHandler)trader.getStorage(), (int)Integer.MAX_VALUE, (Player)this.menu.player, (boolean)true);
            if (result.isSuccess()) {
                if (this.menu.player.m_7500_() && result.getResult().m_41720_() == Items.f_42446_) {
                    if (shiftHeld) {
                        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldStack).orElse(FluidStack.EMPTY);
                        TraderFluidStorage.FluidEntry entry = trader.getStorage().getTank(fluid);
                        if (entry != null) {
                            entry.setAmount(trader.getTankCapacity());
                        }
                    }
                    trader.markStorageDirty();
                    return;
                }
                trader.markStorageDirty();
                if (heldStack.m_41613_() > 1) {
                    heldStack.m_41774_(1);
                    this.menu.m_142503_(heldStack);
                    ItemHandlerHelper.giveItemToPlayer((Player)this.menu.player, (ItemStack)result.getResult());
                } else {
                    this.menu.m_142503_(result.getResult());
                }
            } else {
                if (tank < 0 || tank >= trader.getStorage().getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry tankEntry = trader.getStorage().getContents().get(tank);
                result = FluidUtil.tryFillContainer((ItemStack)heldStack, (IFluidHandler)tankEntry, (int)Integer.MAX_VALUE, (Player)this.menu.player, (boolean)true);
                if (result.isSuccess()) {
                    if (this.menu.player.m_7500_() && heldStack.m_41720_() == Items.f_42446_) {
                        if (shiftHeld) {
                            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)result.getResult()).orElse(FluidStack.EMPTY);
                            TraderFluidStorage.FluidEntry entry = trader.getStorage().getTank(fluid);
                            if (entry != null) {
                                entry.setAmount(0);
                            }
                        }
                        trader.getStorage().clearInvalidTanks();
                        trader.markStorageDirty();
                        return;
                    }
                    trader.getStorage().clearInvalidTanks();
                    trader.markStorageDirty();
                    if (heldStack.m_41613_() > 1) {
                        heldStack.m_41774_(1);
                        this.menu.m_142503_(heldStack);
                        ItemHandlerHelper.giveItemToPlayer((Player)this.menu.player, (ItemStack)result.getResult());
                    } else {
                        this.menu.m_142503_(result.getResult());
                    }
                }
            }
        }
    }

    public void toggleDrainFillState(int tank, boolean drainState, boolean newValue) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (!trader.drainCapable()) {
                return;
            }
            if (tank < 0 || tank >= trader.getStorage().getTanks()) {
                return;
            }
            TraderFluidStorage.FluidEntry entry = trader.getStorage().getContents().get(tank);
            if (drainState) {
                entry.drainable = newValue;
            } else {
                entry.fillable = newValue;
            }
            trader.markStorageDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.builder().setInt("ToggleDrainFillSlot", tank).setBoolean("DrainState", drainState).setBoolean("NewValue", newValue));
            }
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("InteractWithTank", (byte)2)) {
            this.interactWithTank(message.getInt("InteractWithTank"), message.getBoolean("ShiftHeld"));
        } else if (message.contains("ToggleDrainFillSlot", (byte)2)) {
            int tank = message.getInt("ToggleDrainFillSlot");
            boolean drainState = message.getBoolean("DrainState");
            boolean newValue = message.getBoolean("NewValue");
            this.toggleDrainFillState(tank, drainState, newValue);
        }
    }
}

