/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.fluid;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidTradeEditClientTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FluidTradeEditTab
extends TraderStorageTab {
    int tradeIndex = -1;

    public FluidTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object menu) {
        return new FluidTradeEditClientTab(menu, this);
    }

    public boolean canOpen(Player player) {
        return this.menu.getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public FluidTradeData getTrade() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.SendMessage(this.menu.createTabChangeMessage(0));
                return null;
            }
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    public void onTabOpen() {
    }

    public void onTabClose() {
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setType(TradeData.TradeDirection type) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTradeDirection(type);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.simpleInt((String)"NewType", (int)type.index));
            }
        }
    }

    public void setQuantity(int amount) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setBucketQuantity(amount);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.simpleInt((String)"NewQuantity", (int)amount));
            }
        }
    }

    public void setPrice(CoinValue price) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.simpleCoinValue((String)"NewPrice", (CoinValue)price));
            }
        }
    }

    public void setFluid(FluidStack fluid) {
        FluidTradeData trade = this.getTrade();
        if (trade != null) {
            FluidTraderData fluidTrader;
            trade.setProduct(fluid);
            this.menu.getTrader().markTradesDirty();
            TraderData traderData = this.menu.getTrader();
            if (traderData instanceof FluidTraderData && (fluidTrader = (FluidTraderData)traderData).getStorage().refactorTanks()) {
                fluidTrader.markStorageDirty();
            }
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.simpleTag((String)"NewFluid", (CompoundTag)fluid.writeToNBT(new CompoundTag())));
            }
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            this.tradeIndex = message.getInt("TradeIndex");
        } else if (message.contains("NewFluid")) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)message.getNBT("NewFluid")));
        } else if (message.contains("NewQuantity")) {
            this.setQuantity(message.getInt("NewQuantity"));
        } else if (message.contains("NewPrice")) {
            this.setPrice(message.getCoinValue("NewPrice"));
        } else if (message.contains("NewType")) {
            this.setType(TradeData.TradeDirection.fromIndex((int)message.getInt("NewType")));
        }
    }
}

