/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.notifications.types;

import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TaxableNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;

public class EnergyTradeNotification
extends TaxableNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lctech", "energy_trade");
    TraderCategory traderData;
    TradeData.TradeDirection tradeType;
    int quantity;
    CoinValue cost = CoinValue.EMPTY;
    String customer;

    protected EnergyTradeNotification(EnergyTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.tradeType = trade.getTradeDirection();
        this.quantity = trade.getAmount();
        this.cost = cost;
        this.customer = customer.getName(false);
    }

    public static NonNullSupplier<Notification> create(EnergyTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        return () -> new EnergyTradeNotification(trade, cost, customer, traderData, taxesPaid);
    }

    public EnergyTradeNotification(CompoundTag compound) {
        this.load(compound);
    }

    public ResourceLocation getType() {
        return TYPE;
    }

    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Nonnull
    public MutableComponent getNormalMessage() {
        MutableComponent boughtText = EasyText.translatable((String)("log.shoplog." + this.tradeType.name().toLowerCase()), (Object[])new Object[0]);
        return EasyText.translatable((String)"notifications.message.energy_trade", (Object[])new Object[]{this.customer, boughtText, EnergyUtil.formatEnergyAmount(this.quantity), this.cost.getString()});
    }

    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeType", this.tradeType.index);
        compound.m_128405_("Quantity", this.quantity);
        compound.m_128365_("Price", (Tag)this.cost.save());
        compound.m_128359_("Customer", this.customer);
    }

    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeType = TradeData.TradeDirection.fromIndex((int)compound.m_128451_("TradeType"));
        this.quantity = compound.m_128451_("Quantity");
        this.cost = CoinValue.safeLoad((CompoundTag)compound, (String)"Price");
        this.customer = compound.m_128461_("Customer");
    }

    protected boolean canMerge(Notification other) {
        if (other instanceof EnergyTradeNotification) {
            EnergyTradeNotification etn = (EnergyTradeNotification)other;
            if (!etn.traderData.matches((NotificationCategory)this.traderData)) {
                return false;
            }
            if (etn.tradeType != this.tradeType) {
                return false;
            }
            if (etn.quantity != this.quantity) {
                return false;
            }
            if (etn.cost.getValueNumber() != this.cost.getValueNumber()) {
                return false;
            }
            if (!etn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(etn);
        }
        return false;
    }
}

