/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.notifications.types;

import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TaxableNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;

public class FluidTradeNotification
extends TaxableNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lctech", "fluid_trade");
    TraderCategory traderData;
    TradeData.TradeDirection tradeType;
    Component fluidName;
    int fluidCount;
    CoinValue cost = CoinValue.EMPTY;
    String customer;

    protected FluidTradeNotification(FluidTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.tradeType = trade.getTradeDirection();
        this.fluidName = FluidFormatUtil.getFluidName(trade.getProduct()).m_130948_(Style.f_131099_);
        this.fluidCount = trade.getQuantity();
        this.cost = cost;
        this.customer = customer.getName(false);
    }

    public static NonNullSupplier<Notification> create(FluidTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        return () -> new FluidTradeNotification(trade, cost, customer, traderData, taxesPaid);
    }

    public FluidTradeNotification(CompoundTag compound) {
        this.load(compound);
    }

    protected ResourceLocation getType() {
        return TYPE;
    }

    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Nonnull
    public MutableComponent getNormalMessage() {
        MutableComponent boughtText = EasyText.translatable((String)("log.shoplog." + this.tradeType.name().toLowerCase()), (Object[])new Object[0]);
        MutableComponent fluidText = EasyText.translatable((String)"log.shoplog.fluid.fluidformat", (Object[])new Object[]{FluidFormatUtil.formatFluidAmount(this.fluidCount), this.fluidName});
        MutableComponent cost = this.cost.getComponent("0");
        return EasyText.translatable((String)"notifications.message.fluid_trade", (Object[])new Object[]{this.customer, boughtText, fluidText, cost});
    }

    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeType", this.tradeType.index);
        compound.m_128359_("Fluid", Component.Serializer.m_130703_((Component)this.fluidName));
        compound.m_128405_("FluidCount", this.fluidCount);
        compound.m_128365_("Price", (Tag)this.cost.save());
        compound.m_128359_("Customer", this.customer);
    }

    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeType = TradeData.TradeDirection.fromIndex((int)compound.m_128451_("TradeType"));
        this.fluidName = Component.Serializer.m_130701_((String)compound.m_128461_("Fluid"));
        this.fluidCount = compound.m_128451_("FluidCount");
        this.cost = CoinValue.safeLoad((CompoundTag)compound, (String)"Price");
        this.customer = compound.m_128461_("Customer");
    }

    protected boolean canMerge(Notification other) {
        if (other instanceof FluidTradeNotification) {
            FluidTradeNotification ftn = (FluidTradeNotification)other;
            if (!ftn.traderData.matches((NotificationCategory)this.traderData)) {
                return false;
            }
            if (ftn.tradeType != this.tradeType) {
                return false;
            }
            if (!ftn.fluidName.getString().equals(this.fluidName.getString())) {
                return false;
            }
            if (ftn.fluidCount != this.fluidCount) {
                return false;
            }
            if (ftn.cost.getValueNumber() != this.cost.getValueNumber()) {
                return false;
            }
            if (!ftn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(ftn);
        }
        return false;
    }
}

