/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.energy.tradedata.client;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.energy.EnergyStorageClientTab;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyTradeButtonRenderer
extends TradeRenderManager<EnergyTradeData> {
    public EnergyTradeButtonRenderer(EnergyTradeData trade) {
        super((TradeData)trade);
    }

    public int tradeButtonWidth(TradeContext context) {
        return 128;
    }

    public LazyOptional<ScreenPosition> arrowPosition(TradeContext tradeContext) {
        if (((EnergyTradeData)this.trade).isSale()) {
            return ScreenPosition.ofOptional((int)36, (int)1);
        }
        return ScreenPosition.ofOptional((int)70, (int)1);
    }

    public void renderAdditional(EasyWidget button, EasyGuiGraphics gui, int mouseX, int mouseY, TradeContext context) {
        if (this.allowsDrainage(context)) {
            gui.resetColor();
            LazyOptional<ScreenPosition> arrowPosOptional = this.arrowPosition(context);
            arrowPosOptional.ifPresent(arrowPos -> {
                gui.pushOffsetZero();
                gui.blit(EnergyStorageClientTab.GUI_TEXTURE, button.getX() + arrowPos.x, button.getY() + arrowPos.y + 9, 36, 18, 8, 7);
                gui.popOffset();
            });
        }
    }

    public TradeButton.DisplayData inputDisplayArea(TradeContext context) {
        if (((EnergyTradeData)this.trade).isSale()) {
            return new TradeButton.DisplayData(1, 1, 34, 16);
        }
        return new TradeButton.DisplayData(1, 1, 68, 16);
    }

    public List<TradeButton.DisplayEntry> getInputDisplays(TradeContext context) {
        if (((EnergyTradeData)this.trade).isSale()) {
            return this.getCostEntry(context);
        }
        return this.getProductEntry();
    }

    public TradeButton.DisplayData outputDisplayArea(TradeContext context) {
        if (((EnergyTradeData)this.trade).isSale()) {
            return new TradeButton.DisplayData(59, 1, 68, 16);
        }
        return new TradeButton.DisplayData(93, 1, 34, 16);
    }

    public List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext context) {
        if (((EnergyTradeData)this.trade).isSale()) {
            return this.getProductEntry();
        }
        return this.getCostEntry(context);
    }

    private List<TradeButton.DisplayEntry> getCostEntry(TradeContext context) {
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of((CoinValue)((EnergyTradeData)this.trade).getCost(context))});
    }

    private List<TradeButton.DisplayEntry> getProductEntry() {
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of((Component)EasyText.literal((String)EnergyUtil.formatEnergyAmount(((EnergyTradeData)this.trade).getAmount())), (TextRenderUtil.TextFormatting)TextRenderUtil.TextFormatting.create().centered().middle())});
    }

    public List<Component> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
        if (this.allowsDrainage(context)) {
            LazyOptional<ScreenPosition> arrowPosOptional = this.arrowPosition(context);
            AtomicBoolean mouseOver = new AtomicBoolean(false);
            arrowPosOptional.ifPresent(arrowPos -> mouseOver.set(arrowPos.offset(ScreenPosition.of((int)0, (int)9)).isMouseInArea(mouseX, mouseY, 8, 8)));
            if (mouseOver.get()) {
                return Lists.newArrayList((Object[])new Component[]{EasyText.translatable((String)"tooltip.lctech.trader.fluid_settings.drainable", (Object[])new Object[0])});
            }
        }
        return null;
    }

    private boolean allowsDrainage(TradeContext context) {
        if (context.isStorageMode || !((EnergyTradeData)this.trade).isSale()) {
            return false;
        }
        TraderData traderData = context.getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            return trader.canDrainExternally() && trader.isPurchaseDrainMode();
        }
        return false;
    }

    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            if (!trader.isCreative()) {
                if (((EnergyTradeData)this.trade).getStock(context) <= 0) {
                    alerts.add(AlertData.warn((MutableComponent)EasyText.translatable((String)"tooltip.lightmanscurrency.outofstock", (Object[])new Object[0])));
                }
                if (!((EnergyTradeData)this.trade).hasSpace(trader)) {
                    alerts.add(AlertData.warn((MutableComponent)EasyText.translatable((String)"tooltip.lightmanscurrency.outofspace", (Object[])new Object[0])));
                }
            }
            if (!((EnergyTradeData)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn((MutableComponent)EasyText.translatable((String)"tooltip.lightmanscurrency.cannotafford", (Object[])new Object[0])));
            }
        }
        if (((EnergyTradeData)this.trade).isSale() && !context.canFitEnergy(((EnergyTradeData)this.trade).getAmount()) && !this.allowsDrainage(context)) {
            alerts.add(AlertData.warn((MutableComponent)EasyText.translatable((String)"tooltip.lightmanscurrency.nooutputcontainer", (Object[])new Object[0])));
        }
    }
}

