/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TraderFluidStorage
implements IFluidHandler {
    private final ITraderFluidFilter filter;
    List<FluidEntry> tanks = new ArrayList<FluidEntry>();

    public List<FluidEntry> getContents() {
        return this.tanks;
    }

    public TraderFluidStorage(ITraderFluidFilter filter) {
        this.filter = filter;
    }

    public CompoundTag save(CompoundTag compound, String tag) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.tanks.size(); ++i) {
            FluidEntry tank = this.tanks.get(i);
            if (tank.filter.isEmpty()) continue;
            CompoundTag fluidTag = new CompoundTag();
            tank.save(fluidTag);
            list.add((Object)fluidTag);
        }
        compound.m_128365_(tag, (Tag)list);
        return compound;
    }

    public void load(CompoundTag compound, String tag) {
        if (compound.m_128425_(tag, 9)) {
            ListTag list = compound.m_128437_(tag, 10);
            this.tanks.clear();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag fluidTag = list.m_128728_(i);
                FluidEntry tank = FluidEntry.load(this, fluidTag);
                if (tank.filter.isEmpty()) continue;
                this.tanks.add(tank);
            }
        }
        this.refactorTanks();
    }

    public void loadFromTrades(ListTag fluidTradeList) {
        for (int i = 0; i < fluidTradeList.size(); ++i) {
            int pendingDrain;
            CompoundTag fluidTrade = fluidTradeList.m_128728_(i);
            if (!fluidTrade.m_128441_("Tank")) continue;
            FluidStack tankContents = FluidStack.loadFluidStackFromNBT((CompoundTag)fluidTrade.m_128469_("Tank"));
            int n = pendingDrain = fluidTrade.m_128441_("PendingDrain") ? fluidTrade.m_128451_("PendingDrain") : 0;
            if (tankContents.isEmpty()) continue;
            this.tanks.add(new FluidEntry(this, tankContents, pendingDrain));
        }
    }

    public boolean isDrainable(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        return entry == null ? false : entry.drainable || !this.allowFluid(entry.filter);
    }

    public int getActualFluidCount(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            return entry.getStoredAmount();
        }
        return 0;
    }

    public int getAvailableFluidCount(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            return entry.getStoredAmount() - entry.getPendingDrain();
        }
        return 0;
    }

    public int getPendingDrain(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            return entry.getPendingDrain();
        }
        return 0;
    }

    public FluidEntry getTank(FluidStack fluid) {
        for (FluidEntry entry : this.tanks) {
            if (!entry.filter.isFluidEqual(fluid)) continue;
            return entry;
        }
        return null;
    }

    public int getFillableAmount(FluidStack fluid) {
        if (!this.allowFluid(fluid)) {
            return 0;
        }
        return Math.max(0, this.getTankCapacity() - this.getActualFluidCount(fluid));
    }

    public boolean allowFluid(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return false;
        }
        return this.filter.isFluidRelevant(fluid);
    }

    public boolean refactorTanks() {
        boolean result = false;
        for (FluidStack fluid : this.filter.getRelevantFluids()) {
            FluidEntry entry = this.getTank(fluid);
            if (entry != null) continue;
            FluidEntry newEntry = new FluidEntry(this, fluid, 0, 0, false, false);
            this.tanks.add(newEntry);
            result = true;
        }
        return this.clearInvalidTanks() || result;
    }

    public boolean clearInvalidTanks() {
        boolean result = false;
        for (int i = 0; i < this.tanks.size(); ++i) {
            FluidEntry entry = this.tanks.get(i);
            if (entry.filter.isEmpty()) {
                this.tanks.remove(i);
                --i;
                result = true;
                continue;
            }
            if (!entry.isEmpty() || this.allowFluid(entry.filter)) continue;
            this.tanks.remove(i);
            --i;
            result = true;
        }
        return result;
    }

    public boolean forceFillTank(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return true;
        }
        FluidEntry entry = this.getTank(fluid);
        if (entry != null) {
            entry.addAmount(fluid.getAmount());
            return true;
        }
        if (this.tanks.size() >= 8) {
            return false;
        }
        this.tanks.add(new FluidEntry(this, fluid, 0));
        return true;
    }

    public void drain(FluidStack fluid) {
        FluidEntry entry = this.getTank(fluid);
        if (entry == null) {
            return;
        }
        entry.removeAmount(fluid.getAmount());
    }

    public int getTanks() {
        return this.tanks.size();
    }

    public FluidStack getFluidInTank(int tank) {
        if (tank < this.tanks.size()) {
            return this.tanks.get(tank).getTankContents();
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return this.getTankCapacity();
    }

    public int getTankCapacity() {
        return this.filter.getTankCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        if (tank < 0 || tank >= this.tanks.size()) {
            return false;
        }
        return this.tanks.get((int)tank).filter.isFluidEqual(stack);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int drainableAmount = Math.min(resource.getAmount(), this.getAvailableFluidCount(resource));
        if (drainableAmount <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack drainedFluid = resource.copy();
        drainedFluid.setAmount(drainableAmount);
        if (action.execute()) {
            this.drain(drainedFluid);
        }
        return drainedFluid;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.allowFluid(resource)) {
            return 0;
        }
        int fillAmount = Math.min(resource.getAmount(), this.getFillableAmount(resource));
        if (fillAmount > 0 && action.execute()) {
            FluidStack fillStack = resource.copy();
            fillStack.setAmount(fillAmount);
            this.forceFillTank(fillStack);
        }
        return fillAmount;
    }

    public static interface ITraderFluidFilter {
        default public boolean isFluidRelevant(FluidStack fluid) {
            for (FluidStack f : this.getRelevantFluids()) {
                if (!f.isFluidEqual(fluid)) continue;
                return true;
            }
            return false;
        }

        public List<FluidStack> getRelevantFluids();

        public int getTankCapacity();
    }

    public static class FluidEntry
    implements IFluidHandler {
        private final TraderFluidStorage parent;
        public final FluidStack filter;
        private int storedAmount = 0;
        private int pendingDrain = 0;
        public boolean drainable = false;
        public boolean fillable = false;

        public int getStoredAmount() {
            return this.storedAmount;
        }

        public boolean isEmpty() {
            return this.storedAmount <= 0;
        }

        public void addAmount(int amount) {
            this.storedAmount += amount;
        }

        public void setAmount(int amount) {
            this.storedAmount = amount;
        }

        public void removeAmount(int amount) {
            this.storedAmount -= amount;
        }

        public FluidStack getTankContents() {
            FluidStack fluid = this.filter.copy();
            if (!fluid.isEmpty()) {
                fluid.setAmount(this.storedAmount);
            }
            return fluid;
        }

        public int getPendingDrain() {
            return this.pendingDrain;
        }

        public boolean hasPendingDrain() {
            return this.pendingDrain > 0;
        }

        public void addPendingDrain(int amount) {
            this.pendingDrain += amount;
        }

        public void removePendingDrain(int amount) {
            this.pendingDrain -= amount;
        }

        private FluidEntry(TraderFluidStorage parent, FluidStack fluid) {
            this.parent = parent;
            this.filter = fluid.copy();
            if (!this.filter.isEmpty()) {
                this.filter.setAmount(1);
            }
            this.storedAmount = fluid.getAmount();
        }

        private FluidEntry(TraderFluidStorage parent, FluidStack fluid, int pendingDrain) {
            this.parent = parent;
            this.filter = fluid.copy();
            if (!this.filter.isEmpty()) {
                this.filter.setAmount(1);
            }
            this.storedAmount = fluid.getAmount();
            this.pendingDrain = pendingDrain;
        }

        private FluidEntry(TraderFluidStorage parent, FluidStack filter, int amount, int pendingDrain, boolean drainable, boolean fillable) {
            this.parent = parent;
            this.filter = filter;
            if (!this.filter.isEmpty()) {
                this.filter.setAmount(1);
            }
            this.storedAmount = amount;
            this.pendingDrain = pendingDrain;
            this.drainable = drainable;
            this.fillable = fillable;
        }

        public static FluidEntry load(TraderFluidStorage parent, CompoundTag compound) {
            FluidStack filter = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("Filter"));
            int amount = compound.m_128451_("Amount");
            int pendingDrain = compound.m_128451_("PendingDrain");
            boolean drainable = compound.m_128471_("Drainable");
            boolean fillable = compound.m_128471_("Fillable");
            return new FluidEntry(parent, filter, amount, pendingDrain, drainable, fillable);
        }

        private void save(CompoundTag compound) {
            CompoundTag filterTag = new CompoundTag();
            this.filter.writeToNBT(filterTag);
            compound.m_128365_("Filter", (Tag)filterTag);
            compound.m_128405_("Amount", this.storedAmount);
            compound.m_128405_("PendingDrain", this.pendingDrain);
            compound.m_128379_("Drainable", this.drainable);
            compound.m_128379_("Fillable", this.fillable);
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.getTankContents();
        }

        public int getTankCapacity(int tank) {
            return this.parent.getTankCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isFluidEqual(this.filter) && !this.filter.isEmpty()) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.filter.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drainableAmount = Math.min(maxDrain, this.storedAmount - this.pendingDrain);
            FluidStack drainStack = this.filter.copy();
            drainStack.setAmount(drainableAmount);
            if (action.execute()) {
                this.removeAmount(drainableAmount);
            }
            return drainStack;
        }
    }
}

