/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.util;

import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemHandlerHelper;

public class EnergyUtil {
    public static final String ENERGY_UNIT = "FE";

    public static LazyOptional<IEnergyStorage> getEnergyHandler(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY);
    }

    public static String formatEnergyAmount(int amount) {
        return EnergyUtil.formatEnergyAmount(amount, true);
    }

    public static String formatEnergyAmount(int amount, boolean addUnit) {
        Object amountText = new DecimalFormat().format(amount);
        if (addUnit) {
            amountText = (String)amountText + ENERGY_UNIT;
        }
        return amountText;
    }

    @Nonnull
    public static EnergyActionResult tryFillContainer(@Nonnull ItemStack container, IEnergyStorage energySource, int maxAmount, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return EnergyUtil.getEnergyHandler(containerCopy).map(containerEnergyHandler -> {
            int simulatedTransfer = EnergyUtil.tryEnergyTransfer(containerEnergyHandler, energySource, maxAmount, false);
            if (simulatedTransfer > 0) {
                if (doFill) {
                    EnergyUtil.tryEnergyTransfer(containerEnergyHandler, energySource, maxAmount, true);
                } else {
                    containerEnergyHandler.receiveEnergy(simulatedTransfer, !doFill);
                }
                return new EnergyActionResult(containerCopy);
            }
            return EnergyActionResult.FAILURE;
        }).orElse(EnergyActionResult.FAILURE);
    }

    @Nonnull
    public static EnergyActionResult tryEmptyContainer(@Nonnull ItemStack container, IEnergyStorage energyDestination, int maxAmount, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return EnergyUtil.getEnergyHandler(containerCopy).map(containerEnergyHandler -> {
            int transfer = EnergyUtil.tryEnergyTransfer(energyDestination, containerEnergyHandler, maxAmount, true);
            if (transfer <= 0) {
                return EnergyActionResult.FAILURE;
            }
            return new EnergyActionResult(containerCopy);
        }).orElse(EnergyActionResult.FAILURE);
    }

    private static int tryEnergyTransfer(IEnergyStorage fluidDestination, IEnergyStorage fluidSource, int maxAmount, boolean doTransfer) {
        int drainable = fluidSource.extractEnergy(maxAmount, true);
        if (drainable > 0) {
            return EnergyUtil.tryEnergyTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return 0;
    }

    @Nonnull
    private static int tryEnergyTransfer_Internal(IEnergyStorage energyDestination, IEnergyStorage energySource, int amount, boolean doTransfer) {
        int fillableAmount = energyDestination.receiveEnergy(amount, true);
        if (fillableAmount > 0) {
            if (doTransfer) {
                int drained = energySource.extractEnergy(fillableAmount, false);
                if (drained > 0) {
                    return energyDestination.receiveEnergy(drained, false);
                }
            } else {
                return fillableAmount;
            }
        }
        return 0;
    }

    public static class EnergyActionResult {
        private static final EnergyActionResult FAILURE = new EnergyActionResult(false, ItemStack.f_41583_);
        private final ItemStack result;
        private final boolean success;

        public final ItemStack getResult() {
            return this.result;
        }

        public final boolean success() {
            return this.success;
        }

        public EnergyActionResult(ItemStack result) {
            this(true, result);
        }

        private EnergyActionResult(boolean success, ItemStack result) {
            this.success = success;
            this.result = result;
        }
    }
}

