/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.common.items.FluidShardItem;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidItemUtil {
    public static ItemStack getFluidDisplayItem(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == Fluids.f_76191_) {
            return new ItemStack((ItemLike)Items.f_42446_);
        }
        ItemStack fluidItem = fluid.getAttributes().getBucket(fluidStack);
        if (!fluidItem.m_41619_()) {
            return fluidItem;
        }
        FluidStack tempStack = fluidStack.copy();
        tempStack.setAmount(1000);
        return FluidShardItem.GetFluidShard(tempStack);
    }

    public static ItemStack getFluidDispayItem(Fluid fluid) {
        return FluidItemUtil.getFluidDisplayItem(new FluidStack(fluid, 1000));
    }

    public static JsonObject convertFluidStack(FluidStack fluid) {
        JsonObject json = new JsonObject();
        json.addProperty("id", fluid.getFluid().getRegistryName().toString());
        json.addProperty("amount", (Number)fluid.getAmount());
        if (fluid.hasTag()) {
            String tag = fluid.getTag().m_7916_();
            json.addProperty("tag", tag);
        }
        return json;
    }

    public static FluidStack parseFluidStack(JsonObject json) throws Exception {
        String id = json.get("id").getAsString();
        int amount = json.get("amount").getAsInt();
        FluidStack result = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(id)), amount);
        try {
            if (json.has("tag")) {
                JsonElement tag = json.get("tag");
                if (tag.isJsonPrimitive() && tag.getAsJsonPrimitive().isString()) {
                    CompoundTag compound = TagParser.m_129359_((String)tag.getAsString());
                    result.setTag(compound);
                } else {
                    CompoundTag compound = TagParser.m_129359_((String)FileUtil.GSON.toJson(tag));
                    result.setTag(compound);
                }
            }
        }
        catch (Exception e) {
            LCTech.LOGGER.error("Error parsing fluid tag data.", (Throwable)e);
        }
        return result;
    }
}

