/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.integration.lcdiscord;

import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lctech.integration.lcdiscord.TechMessages;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.integration.discord.CurrencyMessages;
import io.github.lightman314.lightmanscurrency.integration.discord.events.DiscordTraderSearchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class TechDiscord {
    public static void setup() {
        MinecraftForge.EVENT_BUS.register(TechDiscord.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(TechMessages.class);
    }

    @SubscribeEvent
    public static void onTraderSearch(DiscordTraderSearchEvent event) {
        block8: {
            String searchText;
            TraderData trader;
            block7: {
                trader = event.getTrader();
                searchText = event.getSearchText();
                if (!(trader instanceof FluidTraderData)) break block7;
                FluidTraderData fluidTrader = (FluidTraderData)trader;
                boolean showStock = !fluidTrader.isCreative();
                boolean firstTrade = true;
                for (int i = 0; i < fluidTrader.getTradeCount(); ++i) {
                    String priceText;
                    String fluidName;
                    FluidStack sellFluid;
                    FluidTradeData trade = fluidTrader.getTrade(i);
                    if (!trade.isValid() || !event.acceptTradeType((TradeData)trade)) continue;
                    if (trade.isSale()) {
                        sellFluid = trade.getProduct();
                        fluidName = FluidFormatUtil.getFluidName(sellFluid).getString();
                        if (!searchText.isEmpty() && !fluidName.toLowerCase().contains(searchText)) continue;
                        if (firstTrade) {
                            event.addToOutput(CurrencyMessages.M_SEARCH_TRADER_NAME.format(new Object[]{trader.getOwner().getOwnerName(false), trader.getName()}));
                            firstTrade = false;
                        }
                        priceText = trade.getCost().getString();
                        event.addToOutput(TechMessages.M_SEARCH_TRADE_FLUID_SALE.format(new Object[]{FluidFormatUtil.formatFluidAmount(trade.getQuantity()), fluidName, priceText}));
                        if (!showStock) continue;
                        event.addToOutput(CurrencyMessages.M_SEARCH_TRADE_STOCK.format(new Object[]{trade.getStock(fluidTrader)}));
                        continue;
                    }
                    if (!trade.isPurchase()) continue;
                    sellFluid = trade.getProduct();
                    fluidName = FluidFormatUtil.getFluidName(sellFluid).getString();
                    if (!searchText.isEmpty() && !fluidName.toLowerCase().contains(searchText)) continue;
                    if (firstTrade) {
                        event.addToOutput(CurrencyMessages.M_SEARCH_TRADER_NAME.format(new Object[]{trader.getOwner().getOwnerName(false), trader.getName()}));
                        firstTrade = false;
                    }
                    priceText = trade.getCost().getString();
                    event.addToOutput(TechMessages.M_SEARCH_TRADE_FLUID_PURCHASE.format(new Object[]{FluidFormatUtil.formatFluidAmount(trade.getQuantity()), fluidName, priceText}));
                    if (!showStock) continue;
                    event.addToOutput(CurrencyMessages.M_SEARCH_TRADE_STOCK.format(new Object[]{trade.getStock(fluidTrader)}));
                }
                break block8;
            }
            if (!(trader instanceof EnergyTraderData)) break block8;
            EnergyTraderData energyTrader = (EnergyTraderData)trader;
            boolean showStock = !energyTrader.isCreative();
            boolean firstTrade = true;
            for (int i = 0; i < energyTrader.getTradeCount(); ++i) {
                String priceText;
                EnergyTradeData trade = energyTrader.getTrade(i);
                if (!trade.isValid() || !event.acceptTradeType((TradeData)trade) || !searchText.isEmpty() && !"FE".toLowerCase().contains(searchText) && !"Energy".toLowerCase().contains(searchText)) continue;
                if (firstTrade) {
                    event.addToOutput(CurrencyMessages.M_SEARCH_TRADER_NAME.format(new Object[]{trader.getOwner().getOwnerName(false), trader.getName()}));
                    firstTrade = false;
                }
                if (trade.isSale()) {
                    priceText = trade.getCost().getString();
                    event.addToOutput(TechMessages.M_SEARCH_TRADE_ENERGY_SALE.format(new Object[]{EnergyUtil.formatEnergyAmount(trade.getAmount(), false), priceText}));
                    if (!showStock) continue;
                    event.addToOutput(CurrencyMessages.M_SEARCH_TRADE_STOCK.format(new Object[]{trade.getStock(energyTrader)}));
                    continue;
                }
                if (!trade.isPurchase()) continue;
                priceText = trade.getCost().getString();
                event.addToOutput(TechMessages.M_SEARCH_TRADE_ENERGY_PURCHASE.format(new Object[]{EnergyUtil.formatEnergyAmount(trade.getAmount(), false), priceText}));
                if (!showStock) continue;
                event.addToOutput(CurrencyMessages.M_SEARCH_TRADE_STOCK.format(new Object[]{trade.getStock(energyTrader)}));
            }
        }
    }
}

