/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.common.blocks.SculkShriekerBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SculkBlock
extends OreBlock
implements SculkSpreadable {
    public SculkBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public int spread(SculkSpreadManager.Cursor cursor, LevelAccessor level, BlockPos pos, Random random, SculkSpreadManager manager, boolean shouldConvert) {
        int charge = cursor.getCharge();
        if (charge != 0 && random.nextInt(manager.getSpreadChance()) == 0) {
            BlockPos blockPos = cursor.getPos();
            boolean inRange = blockPos.m_123314_((Vec3i)pos, (double)manager.getMaxDistance());
            if (!inRange && SculkBlock.shouldNotDecay(level, blockPos)) {
                int chance = manager.getExtraBlockChance();
                if (random.nextInt(chance) < charge) {
                    BlockPos growthPos = blockPos.m_7494_();
                    BlockState state = this.getExtraBlockState(level, growthPos, random, manager.isWorldGen());
                    level.m_7731_(growthPos, state, 3);
                    level.m_5594_(null, blockPos, state.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, charge - chance);
            }
            return random.nextInt(manager.getDecayChance()) != 0 ? charge : charge - (inRange ? 1 : SculkBlock.getDecay(manager, blockPos, pos, charge));
        }
        return charge;
    }

    private static int getDecay(SculkSpreadManager manager, BlockPos source, BlockPos target, int charge) {
        int maxDistance = manager.getMaxDistance();
        float range = Mth.m_14207_((float)((float)Math.sqrt(source.m_123331_((Vec3i)target)) - (float)maxDistance));
        int distance = Mth.m_144944_((int)(24 - maxDistance));
        float spread = Math.min(1.0f, range / (float)distance);
        return Math.max(1, (int)((float)charge * spread * 0.5f));
    }

    private BlockState getExtraBlockState(LevelAccessor level, BlockPos pos, Random random, boolean isWorldGen) {
        BlockState state = random.nextInt(11) == 0 ? (BlockState)WBBlocks.SCULK_SHRIEKER.get().m_49966_().m_61124_((Property)SculkShriekerBlock.CAN_SUMMON, (Comparable)Boolean.valueOf(isWorldGen)) : Blocks.f_152500_.m_49966_();
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && !level.m_6425_(pos).m_76178_() ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : state;
    }

    private static boolean shouldNotDecay(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos.m_7494_());
        if (state.m_60795_() || state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            int chance = 0;
            for (BlockPos position : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 2, 4))) {
                BlockState growth = level.m_8055_(position);
                if (growth.m_60713_(Blocks.f_152500_) || growth.m_60713_(WBBlocks.SCULK_SHRIEKER.get())) {
                    ++chance;
                }
                if (chance <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void m_8101_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 0) {
            this.m_49805_(level, pos, 1);
        }
    }

    @Override
    public boolean shouldConvertToSpreadable() {
        return true;
    }
}

