/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.Frog;
import com.cursedcauldron.wildbackport.common.entities.brain.TadpoleBrain;
import com.cursedcauldron.wildbackport.common.registry.WBItems;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Tadpole
extends AbstractFish {
    public static final int MAX_TADPOLE_AGE = Math.abs(-24000);
    private int age;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Tadpole>>> SENSORS = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORIES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26331_);

    public Tadpole(EntityType<? extends AbstractFish> type, Level level) {
        super(type, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected Brain.Provider<Tadpole> m_5490_() {
        return Brain.m_21923_(MEMORIES, SENSORS);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return TadpoleBrain.create((Brain<Tadpole>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Tadpole> m_6274_() {
        return super.m_6274_();
    }

    protected SoundEvent m_5699_() {
        return WBSoundEvents.TADPOLE_FLOP;
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("tadpoleBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("tadpoleActivityUpdate");
        TadpoleBrain.updateActivities(this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22276_, 6.0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.setAge(this.age + 1);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Age", this.age);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAge(tag.m_128451_("Age"));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return WBSoundEvents.TADPOLE_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return WBSoundEvents.TADPOLE_DEATH;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isSlimeBall(stack)) {
            this.eatSlimeBall(player, stack);
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public boolean m_142392_() {
        return true;
    }

    public void m_142139_(boolean fromBucket) {
    }

    public void m_142146_(ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_("Age", this.getAge());
    }

    public void m_142278_(CompoundTag nbt) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)nbt);
        if (nbt.m_128441_("Age")) {
            this.setAge(nbt.m_128451_("Age"));
        }
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)WBItems.TADPOLE_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return WBSoundEvents.BUCKED_FILL_TADPOLE;
    }

    private boolean isSlimeBall(ItemStack stack) {
        return Frog.FOOD.test(stack);
    }

    private void eatSlimeBall(Player player, ItemStack stack) {
        this.decrementItem(player, stack);
        this.increaseAge((int)((float)(this.getTicksUntilGrowth() / 20) * 0.1f));
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
    }

    private void decrementItem(Player player, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    private int getAge() {
        return this.age;
    }

    private void increaseAge(int seconds) {
        this.setAge(this.age + seconds * 20);
    }

    private void setAge(int age) {
        this.age = age;
        if (this.age >= MAX_TADPOLE_AGE) {
            this.growUp();
        }
    }

    private void growUp() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Frog frog = (Frog)WBEntityTypes.FROG.get().m_20615_(this.f_19853_);
            if (frog == null) {
                return;
            }
            frog.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            frog.m_6518_((ServerLevelAccessor)server, this.f_19853_.m_6436_(frog.m_142538_()), MobSpawnType.CONVERSION, null, null);
            frog.m_21557_(this.m_21525_());
            if (this.m_8077_()) {
                frog.m_6593_(this.m_7770_());
                frog.m_20340_(this.m_20151_());
            }
            frog.m_21530_();
            this.m_5496_(WBSoundEvents.TADPOLE_GROW_UP, 0.15f, 1.0f);
            server.m_47205_((Entity)frog);
            this.m_146870_();
        }
    }

    private int getTicksUntilGrowth() {
        return Math.max(0, MAX_TADPOLE_AGE - this.age);
    }

    protected boolean m_6149_() {
        return false;
    }
}

