/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.client.animation.api.AnimationState;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.access.api.Poses;
import com.cursedcauldron.wildbackport.common.entities.brain.WardenBrain;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.SonicBoom;
import com.cursedcauldron.wildbackport.common.entities.warden.Angriness;
import com.cursedcauldron.wildbackport.common.entities.warden.MobPositionSource;
import com.cursedcauldron.wildbackport.common.entities.warden.VibrationHandler;
import com.cursedcauldron.wildbackport.common.entities.warden.WardenAngerManager;
import com.cursedcauldron.wildbackport.common.registry.WBMobEffects;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.tag.WBGameEventTags;
import com.cursedcauldron.wildbackport.common.utils.MobUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class Warden
extends Monster
implements VibrationHandler.VibrationConfig {
    public static final byte PLAY_ATTACK_SOUND = 4;
    public static final byte EARS_TWITCH = 61;
    public static final byte SONIC_BOOM = 62;
    private static final EntityDataAccessor<Integer> ANGER = SynchedEntityData.m_135353_(Warden.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int tendrilPitchEnd;
    private int tendrilPitchStart;
    private int heartPitchEnd;
    private int heartPitchStart;
    public AnimationState roaringAnimationState = new AnimationState();
    public AnimationState sniffingAnimationState = new AnimationState();
    public AnimationState emergingAnimationState = new AnimationState();
    public AnimationState diggingAnimationState = new AnimationState();
    public AnimationState attackingAnimationState = new AnimationState();
    public AnimationState sonicBoomAnimationState = new AnimationState();
    private final GameEventListenerRegistrar gameEventHandler;
    private final VibrationHandler listener;
    private WardenAngerManager angerManager = new WardenAngerManager(this::isValidTarget, Collections.emptyList());

    public Warden(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.listener = new VibrationHandler(new MobPositionSource((Entity)this, this.m_20192_()), 16, this);
        this.gameEventHandler = new GameEventListenerRegistrar((GameEventListener)this.listener);
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.hasPose(Poses.EMERGING.get()) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        if (packet.m_131509_() == 1) {
            this.m_20124_(Poses.EMERGING.get());
        }
    }

    public boolean m_6914_(LevelReader reader) {
        return super.m_6914_(reader) && reader.m_45756_((Entity)this, this.m_6095_().m_20680_().m_20393_(this.m_20182_()));
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public boolean m_6673_(DamageSource source) {
        return this.isDiggingOrEmerging() && !source.m_19378_() || super.m_6673_(source);
    }

    private boolean isDiggingOrEmerging() {
        return this.hasPose(Poses.DIGGING.get()) || this.hasPose(Poses.EMERGING.get());
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.55f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22281_, 30.0);
    }

    public boolean m_142050_() {
        return true;
    }

    protected float m_6121_() {
        return 4.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return !this.hasPose(Poses.ROARING.get()) && !this.isDiggingOrEmerging() ? this.getAngriness().getSound() : null;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return WBSoundEvents.WARDEN_HURT;
    }

    protected SoundEvent m_5592_() {
        return WBSoundEvents.WARDEN_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(WBSoundEvents.WARDEN_STEP, 10.0f, 1.0f);
    }

    public boolean m_7327_(Entity entity) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_(WBSoundEvents.WARDEN_ATTACK_IMPACT, 10.0f, this.m_6100_());
        SonicBoom.setCooldown((LivingEntity)this, 40L);
        return super.m_7327_(entity);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER, (Object)0);
    }

    public int getAnger() {
        return (Integer)this.f_19804_.m_135370_(ANGER);
    }

    private void updateAnger() {
        this.f_19804_.m_135381_(ANGER, (Object)this.getPrimeSuspectAnger());
    }

    public void m_8119_() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.listener.tick((Level)server);
            if (this.m_21532_() || this.m_8023_()) {
                WardenBrain.resetDigCooldown((LivingEntity)this);
            }
        }
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            if (this.f_19797_ % this.getHeartRate() == 0) {
                this.heartPitchEnd = 10;
                if (!this.m_20067_()) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), WBSoundEvents.WARDEN_HEARTBEAT, this.m_5720_(), 5.0f, this.m_6100_(), false);
                }
            }
            this.tendrilPitchStart = this.tendrilPitchEnd;
            if (this.tendrilPitchEnd > 0) {
                --this.tendrilPitchEnd;
            }
            this.heartPitchStart = this.heartPitchEnd;
            if (this.heartPitchEnd > 0) {
                --this.heartPitchEnd;
            }
            if (this.hasPose(Poses.EMERGING.get())) {
                this.addDigParticles(this.emergingAnimationState);
            }
            if (this.hasPose(Poses.DIGGING.get())) {
                this.addDigParticles(this.diggingAnimationState);
            }
        }
    }

    protected void m_8024_() {
        ServerLevel level = (ServerLevel)this.f_19853_;
        level.m_46473_().m_6180_("wardenBrain");
        this.m_6274_().m_21865_(level, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
        if ((this.f_19797_ + this.m_142049_()) % 120 == 0) {
            Warden.addDarknessToClosePlayers(level, this.m_20182_(), (Entity)this, 20);
        }
        if (this.f_19797_ % 20 == 0) {
            this.angerManager.tick(level, this::isValidTarget);
            this.updateAnger();
        }
        WardenBrain.updateActivities(this);
    }

    public void m_7822_(byte status) {
        if (status == 4) {
            this.roaringAnimationState.stop();
            this.attackingAnimationState.start(this.f_19797_);
        } else if (status == 61) {
            this.tendrilPitchEnd = 10;
        } else if (status == 62) {
            this.sonicBoomAnimationState.start(this.f_19797_);
        } else {
            super.m_7822_(status);
        }
    }

    private int getHeartRate() {
        return 40 - Mth.m_14143_((float)(Mth.m_14036_((float)((float)this.getAnger() / (float)Angriness.ANGRY.getThreshold()), (float)0.0f, (float)1.0f) * 30.0f));
    }

    public float getTendrilPitch(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.tendrilPitchStart, (float)this.tendrilPitchEnd) / 10.0f;
    }

    public float getHeartPitch(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.heartPitchStart, (float)this.heartPitchEnd) / 10.0f;
    }

    private void addDigParticles(AnimationState animationState) {
        if ((float)animationState.runningTime() < 4500.0f) {
            Random random = this.m_21187_();
            BlockState state = this.m_20075_();
            if (state.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double x = this.m_20185_() + (double)Mth.m_144924_((Random)random, (float)-0.7f, (float)0.7f);
                    double y = this.m_20186_();
                    double z = this.m_20189_() + (double)Mth.m_144924_((Random)random, (float)-0.7f, (float)0.7f);
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (f_19806_.equals(data)) {
            if (this.hasPose(Poses.EMERGING.get())) {
                this.emergingAnimationState.start(this.f_19797_);
            } else if (this.hasPose(Poses.DIGGING.get())) {
                this.diggingAnimationState.start(this.f_19797_);
            } else if (this.hasPose(Poses.ROARING.get())) {
                this.roaringAnimationState.start(this.f_19797_);
            } else if (this.hasPose(Poses.SNIFFING.get())) {
                this.sniffingAnimationState.start(this.f_19797_);
            }
        }
        super.m_7350_(data);
    }

    public boolean hasPose(Pose pose) {
        return this.m_20089_() == pose;
    }

    public boolean m_6128_() {
        return this.isDiggingOrEmerging();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return WardenBrain.makeBrain(this, dynamic);
    }

    public Brain<Warden> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    @Override
    public TagKey<GameEvent> getListenableEvents() {
        return WBGameEventTags.WARDEN_CAN_LISTEN;
    }

    @Override
    public boolean canTriggerAvoidVibration() {
        return true;
    }

    public boolean isValidTarget(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return this.f_19853_ == entity.f_19853_ && EntitySelector.f_20406_.test(entity) && !this.m_7307_(entity) && living.m_6095_() != EntityType.f_20529_ && living.m_6095_() != WBEntityTypes.WARDEN.get() && !living.m_20147_() && !living.m_21224_() && this.f_19853_.m_6857_().m_61935_(living.m_142469_());
        }
        return false;
    }

    public static void addDarknessToClosePlayers(ServerLevel world, Vec3 pos, @Nullable Entity entity, int range) {
        MobEffectInstance instance = new MobEffectInstance(WBMobEffects.DARKNESS.get(), 260, 0, false, false);
        MobUtils.addEffectToPlayersWithinDistance(world, entity, pos, range, instance, 200);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        WardenAngerManager.codec(this::isValidTarget).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.angerManager).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(manager -> tag.m_128365_("anger", manager));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("anger")) {
            WardenAngerManager.codec(this::isValidTarget).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("anger"))).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(manager -> {
                this.angerManager = manager;
            });
            this.updateAnger();
        }
    }

    private void playListeningSound() {
        if (!this.hasPose(Poses.ROARING.get())) {
            this.m_5496_(this.getAngriness().getListeningSound(), 10.0f, this.m_6100_());
        }
    }

    public Angriness getAngriness() {
        return Angriness.getForAnger(this.getPrimeSuspectAnger());
    }

    public int getPrimeSuspectAnger() {
        return this.angerManager.getAngerFor((Entity)this.m_5448_());
    }

    public void removeSuspect(Entity entity) {
        this.angerManager.removeSuspect(entity);
    }

    public void increaseAngerAt(Entity entity) {
        this.increaseAngerAt(entity, 35, true);
    }

    public void increaseAngerAt(Entity entity, int amount, boolean listening) {
        if (!this.m_21525_() && this.isValidTarget(entity)) {
            WardenBrain.resetDigCooldown((LivingEntity)this);
            boolean targetNotPlayer = !(this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null) instanceof Player);
            int anger = this.angerManager.increaseAngerAt(entity, amount);
            if (entity instanceof Player && targetNotPlayer && Angriness.getForAnger(anger).isAngry()) {
                this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            }
            if (listening) {
                this.playListeningSound();
            }
        }
    }

    public Optional<LivingEntity> getPrimeSuspect() {
        return this.getAngriness().isAngry() ? this.angerManager.getPrimeSuspect() : Optional.empty();
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6785_(double sqrDist) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType spawn, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.m_6274_().m_21882_(WBMemoryModules.DIG_COOLDOWN.get(), (Object)Unit.INSTANCE, 1200L);
        if (spawn == MobSpawnType.TRIGGERED) {
            this.m_20124_(Poses.EMERGING.get());
            this.m_6274_().m_21882_(WBMemoryModules.IS_EMERGING.get(), (Object)Unit.INSTANCE, (long)WardenBrain.EMERGE_DURATION);
            this.m_5496_(WBSoundEvents.WARDEN_AGITATED, 5.0f, 1.0f);
        }
        return super.m_6518_(level, instance, spawn, data, tag);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (!(this.f_19853_.f_46443_ || this.m_21525_() || this.isDiggingOrEmerging())) {
            Entity entity = source.m_7639_();
            this.increaseAngerAt(entity, Angriness.ANGRY.getThreshold() + 20, false);
            if (this.f_20939_.m_21952_(MemoryModuleType.f_26372_).isEmpty() && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (!(source instanceof IndirectEntityDamageSource) || this.m_19950_((Entity)living, 5.0)) {
                    this.updateAttackTarget(living);
                }
            }
        }
        return hurt;
    }

    public void updateAttackTarget(LivingEntity entity) {
        this.m_6274_().m_21936_(WBMemoryModules.ROAR_TARGET.get());
        this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)entity);
        this.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        SonicBoom.setCooldown((LivingEntity)this, 200L);
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions dimensions = super.m_6972_(pose);
        return this.isDiggingOrEmerging() ? EntityDimensions.m_20398_((float)dimensions.f_20377_, (float)1.0f) : dimensions;
    }

    public boolean m_6094_() {
        return !this.isDiggingOrEmerging() && super.m_6094_();
    }

    protected void m_7324_(Entity entity) {
        if (!this.m_21525_() && !this.m_6274_().m_21874_(WBMemoryModules.TOUCH_COOLDOWN.get())) {
            this.m_6274_().m_21882_(WBMemoryModules.TOUCH_COOLDOWN.get(), (Object)Unit.INSTANCE, 20L);
            this.increaseAngerAt(entity);
            WardenBrain.lookAtDisturbance(this, entity.m_142538_());
        }
        super.m_7324_(entity);
    }

    @Override
    public boolean shouldListen(ServerLevel level, GameEventListener listener, BlockPos pos, GameEvent event, @Nullable Entity entity) {
        if (!(this.m_21525_() || this.m_21224_() || this.m_6274_().m_21874_(WBMemoryModules.VIBRATION_COOLDOWN.get()) || this.isDiggingOrEmerging() || !level.m_6857_().m_61937_(pos) || this.m_146910_() || this.f_19853_ != level)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return this.isValidTarget((Entity)living);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSignalReceive(ServerLevel level, GameEventListener listener, BlockPos pos, GameEvent event, @Nullable Entity entity, @Nullable Entity source, float distance) {
        if (!this.m_21224_()) {
            this.f_20939_.m_21882_(WBMemoryModules.VIBRATION_COOLDOWN.get(), (Object)Unit.INSTANCE, 40L);
            level.m_7605_((Entity)this, (byte)61);
            this.m_5496_(WBSoundEvents.WARDEN_TENDRIL_CLICKS, 5.0f, this.m_6100_());
            BlockPos position = pos;
            if (source != null) {
                if (this.m_19950_(source, 30.0)) {
                    if (this.m_6274_().m_21874_(WBMemoryModules.RECENT_PROJECTILE.get())) {
                        if (this.isValidTarget(source)) {
                            position = source.m_142538_();
                        }
                        this.increaseAngerAt(source);
                    } else {
                        this.increaseAngerAt(source, 10, true);
                    }
                }
                this.m_6274_().m_21882_(WBMemoryModules.RECENT_PROJECTILE.get(), (Object)Unit.INSTANCE, 100L);
            } else {
                this.increaseAngerAt(entity);
            }
            if (!this.getAngriness().isAngry()) {
                Optional<LivingEntity> primeSuspect = this.angerManager.getPrimeSuspect();
                if (source != null || primeSuspect.isEmpty() || primeSuspect.get() == entity) {
                    WardenBrain.lookAtDisturbance(this, position);
                }
            }
        }
    }

    @Nullable
    public GameEventListenerRegistrar m_146887_() {
        return this.gameEventHandler;
    }

    public boolean closerThan(Entity entity, double xzRange, double yRange) {
        double x = entity.m_20185_() - this.m_20185_();
        double y = entity.m_20186_() - this.m_20186_();
        double z = entity.m_20189_() - this.m_20189_();
        return Mth.m_211589_((double)x, (double)z) < Mth.m_144952_((double)xzRange) && Mth.m_144952_((double)y) < Mth.m_144952_((double)yRange);
    }
}

