/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain;

import com.cursedcauldron.wildbackport.common.entities.Allay;
import com.cursedcauldron.wildbackport.common.entities.brain.allay.FlyingRandomStroll;
import com.cursedcauldron.wildbackport.common.entities.brain.allay.GiveInventoryToLookTarget;
import com.cursedcauldron.wildbackport.common.entities.brain.allay.StayCloseToTarget;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class AllayBrain {
    public static Brain<?> create(Brain<Allay> brain) {
        AllayBrain.addCoreActivities(brain);
        AllayBrain.addIdleActivities(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<Allay> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(2.5f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(WBMemoryModules.LIKED_NOTEBLOCK_COOLDOWN_TICKS.get()), (Object)new CountDownCooldownTicks(WBMemoryModules.ITEM_PICKUP_COOLDOWN_TICKS.get())));
    }

    private static void addIdleActivities(Brain<Allay> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new GoToWantedItem(entity -> true, 1.75f, true, 32)), (Object)Pair.of((Object)1, new GiveInventoryToLookTarget(AllayBrain::getLookTarget, 2.25f)), (Object)Pair.of((Object)2, new StayCloseToTarget(AllayBrain::getLookTarget, 4, 16, 2.25f)), (Object)Pair.of((Object)3, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(entity -> true, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)((Object)new FlyingRandomStroll(1.0f)), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of());
    }

    public static void updateActivities(Allay allay) {
        allay.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37979_));
    }

    public static void rememberNoteBlock(LivingEntity entity, BlockPos pos) {
        Brain brain = entity.m_6274_();
        GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)entity.m_183503_().m_46472_(), (BlockPos)pos);
        Optional noteblock = brain.m_21952_(WBMemoryModules.LIKED_NOTEBLOCK.get());
        if (noteblock.isEmpty()) {
            brain.m_21879_(WBMemoryModules.LIKED_NOTEBLOCK.get(), (Object)globalPos);
            brain.m_21879_(WBMemoryModules.LIKED_NOTEBLOCK_COOLDOWN_TICKS.get(), (Object)600);
        } else if (((GlobalPos)noteblock.get()).equals((Object)globalPos)) {
            brain.m_21879_(WBMemoryModules.LIKED_NOTEBLOCK_COOLDOWN_TICKS.get(), (Object)600);
        }
    }

    private static Optional<PositionTracker> getLookTarget(LivingEntity entity) {
        Brain brain = entity.m_6274_();
        Optional likedNoteBlock = brain.m_21952_(WBMemoryModules.LIKED_NOTEBLOCK.get());
        if (likedNoteBlock.isPresent()) {
            GlobalPos pos = (GlobalPos)likedNoteBlock.get();
            if (AllayBrain.shouldGoTowardsNoteBlock(entity, brain, pos)) {
                return Optional.of(new BlockPosTracker(pos.m_122646_().m_7494_()));
            }
            brain.m_21936_(WBMemoryModules.LIKED_NOTEBLOCK.get());
        }
        return AllayBrain.getLikedLookTarget(entity);
    }

    private static boolean shouldGoTowardsNoteBlock(LivingEntity entity, Brain<?> brain, GlobalPos pos) {
        Optional cooldownTicks = brain.m_21952_(WBMemoryModules.LIKED_NOTEBLOCK_COOLDOWN_TICKS.get());
        Level level = entity.m_183503_();
        return level.m_46472_() == pos.m_122640_() && level.m_8055_(pos.m_122646_()).m_60713_(Blocks.f_50065_) && cooldownTicks.isPresent();
    }

    private static Optional<PositionTracker> getLikedLookTarget(LivingEntity entity) {
        return AllayBrain.getLikedPlayer(entity).map(player -> new EntityTracker((Entity)player, true));
    }

    public static Optional<ServerPlayer> getLikedPlayer(LivingEntity entity) {
        Level level = entity.m_183503_();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Optional likedPlayer = entity.m_6274_().m_21952_(WBMemoryModules.LIKED_PLAYER.get());
            if (likedPlayer.isPresent()) {
                Entity entity2 = server.m_8791_((UUID)likedPlayer.get());
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity2;
                    if ((player.f_8941_.m_9294_() || player.f_8941_.m_9295_()) && player.m_19950_((Entity)entity, 64.0)) {
                        return Optional.of(player);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

