/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.placers;

import com.cursedcauldron.wildbackport.common.registry.WBRegistries;
import com.cursedcauldron.wildbackport.common.registry.worldgen.RootPlacerType;
import com.cursedcauldron.wildbackport.common.worldgen.decorator.AboveRootPlacement;
import com.cursedcauldron.wildbackport.common.worldgen.features.RootedTreeConfig;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public abstract class RootPlacer {
    public static final Codec<RootPlacer> CODEC = WBRegistries.ROOT_PLACER_TYPES.registry().m_194605_().dispatch(RootPlacer::getType, RootPlacerType::codec);
    protected final IntProvider trunkOffsetY;
    protected final BlockStateProvider rootProvider;
    protected final Optional<AboveRootPlacement> aboveRootPlacement;

    protected static <P extends RootPlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, BlockStateProvider, Optional<AboveRootPlacement>> codec(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)IntProvider.f_146531_.fieldOf("trunk_offset_y").forGetter(placer -> placer.trunkOffsetY), (App)BlockStateProvider.f_68747_.fieldOf("root_provider").forGetter(placer -> placer.rootProvider), (App)AboveRootPlacement.CODEC.optionalFieldOf("above_root_placement").forGetter(placer -> placer.aboveRootPlacement));
    }

    public RootPlacer(IntProvider trunkOffsetY, BlockStateProvider rootProvider, Optional<AboveRootPlacement> aboveRootPlacement) {
        this.trunkOffsetY = trunkOffsetY;
        this.rootProvider = rootProvider;
        this.aboveRootPlacement = aboveRootPlacement;
    }

    protected abstract RootPlacerType<?> getType();

    public abstract boolean generate(LevelSimulatedReader var1, BiConsumer<BlockPos, BlockState> var2, Random var3, BlockPos var4, BlockPos var5, RootedTreeConfig var6);

    protected boolean canGrowThrough(LevelSimulatedReader level, BlockPos pos) {
        return TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos);
    }

    protected void placeRoots(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, Random random, BlockPos pos, RootedTreeConfig config) {
        if (this.canGrowThrough(level, pos)) {
            replacer.accept(pos, this.applyWaterlogging(level, pos, this.rootProvider.m_7112_(random, pos)));
            if (this.aboveRootPlacement.isPresent()) {
                AboveRootPlacement placement = this.aboveRootPlacement.get();
                BlockPos above = pos.m_7494_();
                if (random.nextFloat() < placement.aboveRootPlacementChance() && level.m_7433_(above, BlockBehaviour.BlockStateBase::m_60795_)) {
                    replacer.accept(above, this.applyWaterlogging(level, above, placement.aboveRootProvider().m_7112_(random, above)));
                }
            }
        }
    }

    protected BlockState applyWaterlogging(LevelSimulatedReader level, BlockPos pos, BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, fluid -> fluid.m_205070_(FluidTags.f_13131_)))) : state;
    }

    public BlockPos trunkOffset(BlockPos pos, Random random) {
        return pos.m_6630_(this.trunkOffsetY.m_142270_(random));
    }
}

