/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.core.mixin.common;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.common.effects.EffectFactor;
import com.cursedcauldron.wildbackport.common.effects.FactorCalculationData;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEffect.class})
public class MobEffectMixin
implements EffectFactor {
    private Supplier<FactorCalculationData> factorCalculationData = () -> null;

    @Override
    public MobEffect setFactorCalculationData(Supplier<FactorCalculationData> data) {
        this.factorCalculationData = data;
        return (MobEffect)MobEffect.class.cast(this);
    }

    @Override
    public Supplier<FactorCalculationData> getFactorCalculationData() {
        return this.factorCalculationData;
    }

    @Mixin(value={MobEffectInstance.class})
    public static class MobEffectInstanceMixin
    implements EffectFactor.Instance {
        @Shadow
        @Final
        private MobEffect f_19502_;
        @Shadow
        private int f_19503_;
        private Optional<FactorCalculationData> factorCalculationData;

        @Inject(method={"<init>(Lnet/minecraft/world/effect/MobEffect;IIZZZLnet/minecraft/world/effect/MobEffectInstance;)V"}, at={@At(value="TAIL")})
        private void wb$create(MobEffect effect, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon, MobEffectInstance hiddenEffect, CallbackInfo ci) {
            this.setFactorCalculationData(EffectFactor.create(effect));
        }

        @Inject(method={"<init>(Lnet/minecraft/world/effect/MobEffectInstance;)V"}, at={@At(value="TAIL")})
        private void wb$create(MobEffectInstance instance, CallbackInfo ci) {
            this.setFactorCalculationData(EffectFactor.create(this.f_19502_));
        }

        @Override
        public void setFactorCalculationData(Optional<FactorCalculationData> data) {
            this.factorCalculationData = data;
        }

        @Override
        public Optional<FactorCalculationData> getFactorCalculationData() {
            return this.factorCalculationData;
        }

        @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true)
        private void wb$update(MobEffectInstance instance, CallbackInfoReturnable<Boolean> cir) {
            int i = this.f_19503_;
            if (i != this.f_19503_) {
                this.factorCalculationData.ifPresent(data -> data.effectChangedTimestamp += this.f_19503_ - i);
                cir.setReturnValue((Object)true);
            }
        }

        @Inject(method={"tick"}, at={@At(value="HEAD")})
        private void wb$tick(LivingEntity entity, Runnable runnable, CallbackInfoReturnable<Boolean> cir) {
            this.factorCalculationData.ifPresent(data -> data.update((MobEffectInstance)MobEffectInstance.class.cast(this)));
        }

        @Inject(method={"writeDetailsTo"}, at={@At(value="TAIL")})
        private void wb$write(CompoundTag tag, CallbackInfo ci) {
            this.factorCalculationData.flatMap(instance -> FactorCalculationData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, instance).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0))).ifPresent(data -> tag.m_128365_("FactorCalculationData", data));
        }

        @Inject(method={"loadSpecifiedEffect"}, at={@At(value="TAIL")})
        private static void wb$load(MobEffect effect, CompoundTag tag, CallbackInfoReturnable<MobEffectInstance> cir) {
            Optional data = tag.m_128425_("FactorCalculationData", 10) ? FactorCalculationData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("FactorCalculationData"))).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)) : Optional.empty();
            EffectFactor.Instance.of((MobEffectInstance)cir.getReturnValue()).setFactorCalculationData(data);
        }
    }
}

