/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.command;

import com.davenonymous.bonsaitrees3.BonsaiTrees3;
import com.davenonymous.bonsaitrees3.datagen.server.DatagenSaplings;
import com.davenonymous.bonsaitrees3.setup.Registration;
import com.davenonymous.libnonymous.commands.SimpleCommandReply;
import com.davenonymous.libnonymous.reflections.AbstractTreeGrowerReflection;
import com.davenonymous.libnonymous.reflections.SaplingBlockReflection;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.davenonymous.libnonymous.utils.ComponentUtils;
import com.davenonymous.libnonymous.utils.TeleporterTools;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Unit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.command.ModIdArgument;

public class CommandTreeGenerator
implements Command<CommandSourceStack> {
    private static final CommandTreeGenerator CMD = new CommandTreeGenerator(false, false);
    private static final CommandTreeGenerator CMD_WITH_FILTER = new CommandTreeGenerator(true, false);
    private static final CommandTreeGenerator CMD_WITH_GROUND = new CommandTreeGenerator(true, true);
    boolean hasModFilter;
    boolean setsCustomGround;

    public CommandTreeGenerator(boolean hasModFilter, boolean setsCustomGround) {
        this.hasModFilter = hasModFilter;
        this.setsCustomGround = setsCustomGround;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"generator").requires(cs -> cs.m_6761_(0))).executes((Command)SimpleCommandReply.error((String)"This command can be used to mass generate sapling and model files.\nIt should not be used on actual game worlds!\nIf you know what you are doing, continue by appending 'yes' to the command!"))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"confirm", (ArgumentType)StringArgumentType.word()).executes((Command)CMD)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mod", (ArgumentType)ModIdArgument.modIdArgument()).executes((Command)CMD_WITH_FILTER)).then(Commands.m_82129_((String)"ground", (ArgumentType)BlockStateArgument.m_116120_()).executes((Command)CMD_WITH_GROUND))));
    }

    private int doit(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!player.m_183503_().m_46472_().equals(Registration.GROWTOWN)) {
            ServerLevel destination = player.m_20194_().m_129880_(Registration.GROWTOWN);
            TeleporterTools.teleport((ServerPlayer)player, (ServerLevel)destination, (BlockPos)BlockPos.f_121853_, (boolean)true);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Wrong dimension. Needed to teleport you there first. Please run the command again."));
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("To get back to another dimension run: /execute in <dimension> run teleport <coordinates>"));
            return 0;
        }
        File generatorSaveDir = new File(Minecraft.m_91087_().f_91069_, "bonsai-generated");
        generatorSaveDir.delete();
        generatorSaveDir.mkdirs();
        File modelSaveDir = new File(generatorSaveDir, "models");
        File saplingSaveDir = new File(generatorSaveDir, "saplings");
        modelSaveDir.mkdirs();
        saplingSaveDir.mkdirs();
        final HashMap<Item, ConfiguredFeature> saplingMap = new HashMap<Item, ConfiguredFeature>();
        int count = 0;
        int xOffset = 0;
        List<SaplingBlock> saplingBlocks = ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b instanceof SaplingBlock).map(b -> (SaplingBlock)b).toList();
        for (SaplingBlock saplingBlock : saplingBlocks) {
            String wantedMod;
            String saplingMod;
            if (this.hasModFilter && !(saplingMod = saplingBlock.getRegistryName().m_135827_()).equals(wantedMod = (String)context.getArgument("mod", String.class))) {
                BonsaiTrees3.LOGGER.info("Skipping sapling: {}, wrong mod ({} != {})", (Object)saplingBlock, (Object)saplingMod, (Object)wantedMod);
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentUtils.format((String)"Found sapling block: %s", (Object[])new Object[]{saplingBlock.getRegistryName()}), false);
            BlockPos growPos = new BlockPos(7 + xOffset, 4, 7);
            CommandTreeGenerator.resetChunks((CommandSourceStack)context.getSource(), growPos, 0, false);
            if (this.setsCustomGround) {
                BlockInput blockInfo = BlockStateArgument.m_116123_(context, (String)"ground");
                CommandTreeGenerator.clearArea(player.m_183503_(), xOffset, blockInfo.m_114669_());
            } else {
                CommandTreeGenerator.clearArea(player.m_183503_(), xOffset);
            }
            AbstractTreeGrower grower = SaplingBlockReflection.getTreeGrowerFromSaplingBlock((SaplingBlock)saplingBlock);
            grower.m_6334_(player.m_183503_(), player.m_183503_().m_7726_().m_8481_(), growPos, player.m_183503_().m_8055_(growPos), player.m_183503_().f_46441_);
            ConfiguredFeature feature = AbstractTreeGrowerReflection.getConfiguredFeature((AbstractTreeGrower)grower, (Random)player.m_21187_(), (boolean)false);
            try {
                FeatureConfiguration featureConfiguration;
                BonsaiTrees3.LOGGER.info("Looking at configured feature: {}", (Object)feature);
                if (feature != null && (featureConfiguration = feature.f_65378_()) instanceof TreeConfiguration) {
                    TreeConfiguration tc = (TreeConfiguration)featureConfiguration;
                    BonsaiTrees3.LOGGER.info(" --> TreeConfiguration: {}", (Object)tc);
                    Item saplingItem = Item.m_41439_((Block)saplingBlock);
                    saplingMap.put(saplingItem, feature);
                    BonsaiTrees3.LOGGER.info(" --> Sapling: {}", (Object)saplingItem);
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            player.m_183503_().m_7731_(new BlockPos(x + xOffset, 3, z), Blocks.f_50016_.m_49966_(), 3);
                            player.m_183503_().m_7731_(new BlockPos(x + xOffset, 2, z), Blocks.f_50016_.m_49966_(), 3);
                        }
                    }
                    ResourceLocation featureName = ((ResourceKey)BuiltinRegistries.f_123861_.m_7854_((Object)feature).get()).m_135782_();
                    BonsaiTrees3.LOGGER.info(" --> Feature name: {}", (Object)featureName);
                    MultiblockBlockModel model = new MultiblockBlockModel(new ResourceLocation("bonsaitrees3", "sapling/" + featureName.m_135827_() + "/" + featureName.m_135815_()));
                    model.setBlocksByFloodFill((LevelReader)((CommandSourceStack)context.getSource()).m_81372_(), growPos.m_7494_());
                    File modDir = new File(modelSaveDir, saplingBlock.getRegistryName().m_135827_());
                    modDir.mkdirs();
                    File modelFile = new File(modDir, featureName.m_135815_() + ".json");
                    try {
                        FileWriter writer = new FileWriter(modelFile);
                        writer.write(model.serializePretty());
                        writer.close();
                        ++count;
                    }
                    catch (IOException e) {
                        ((CommandSourceStack)context.getSource()).m_81352_((Component)ComponentUtils.format((String)"Unable to write model for: %s: %s", (Object[])new Object[]{featureName, e.getLocalizedMessage()}));
                    }
                }
            }
            catch (Exception e) {
                BonsaiTrees3.LOGGER.info("Something went wrong during generation of: {}", (Object)saplingBlock.getRegistryName());
                BonsaiTrees3.LOGGER.error("{}", (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
            xOffset += 16;
        }
        DataGenerator dataGen = new DataGenerator(saplingSaveDir.toPath(), Collections.emptySet());
        dataGen.m_123914_((DataProvider)new DatagenSaplings(dataGen){

            @Override
            public void addValues() {
                for (Item saplingItem : saplingMap.keySet()) {
                    ConfiguredFeature feature = (ConfiguredFeature)saplingMap.get(saplingItem);
                    this.addSapling(saplingItem, this.getAsTreeConfiguration(feature));
                }
            }
        });
        try {
            dataGen.m_123917_();
        }
        catch (IOException e) {
            BonsaiTrees3.LOGGER.error("IO Error during data gen: {}", (Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentUtils.format((String)"Done! Wrote %d sapling and model files", (Object[])new Object[]{count}), false);
        return 0;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((String)context.getArgument("confirm", String.class)).equals("yes")) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)ComponentUtils.format((String)"No confirmation received. Append 'yes' to the command if you know what you are doing!", (Object[])new Object[0]));
            return 0;
        }
        return this.doit(context);
    }

    private static void clearArea(ServerLevel level, int xOffset) {
        CommandTreeGenerator.clearArea(level, xOffset, Blocks.f_50034_.m_49966_());
    }

    private static void clearArea(ServerLevel level, int xOffset, BlockState groundState) {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 32; ++y) {
                for (int z = 0; z < 16; ++z) {
                    BlockState wanted = Blocks.f_50016_.m_49966_();
                    if (y == 0) {
                        wanted = Blocks.f_50752_.m_49966_();
                    }
                    if (y == 1) {
                        wanted = Blocks.f_50493_.m_49966_();
                    }
                    if (y == 2) {
                        wanted = groundState;
                    }
                    BlockPos pos = new BlockPos(x + xOffset, y, z);
                    level.m_7731_(pos, wanted, 3);
                }
            }
        }
    }

    private static int resetChunks(CommandSourceStack p_183685_, BlockPos pos, int p_183686_, boolean p_183687_) {
        ServerLevel serverlevel = p_183685_.m_81372_();
        ServerChunkCache serverchunkcache = serverlevel.m_7726_();
        serverchunkcache.f_8325_.m_183825_();
        ChunkPos chunkpos = new ChunkPos(pos);
        int i = chunkpos.f_45579_ - p_183686_;
        int j = chunkpos.f_45579_ + p_183686_;
        int k = chunkpos.f_45578_ - p_183686_;
        int l = chunkpos.f_45578_ + p_183686_;
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                ChunkPos chunkpos1 = new ChunkPos(j1, i1);
                LevelChunk levelchunk = serverchunkcache.m_62227_(j1, i1, false);
                if (levelchunk == null || p_183687_ && levelchunk.m_187675_()) continue;
                for (BlockPos blockpos : BlockPos.m_121976_((int)chunkpos1.m_45604_(), (int)serverlevel.m_141937_(), (int)chunkpos1.m_45605_(), (int)chunkpos1.m_45608_(), (int)(serverlevel.m_151558_() - 1), (int)chunkpos1.m_45609_())) {
                    serverlevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 16);
                }
            }
        }
        ProcessorMailbox processormailbox = ProcessorMailbox.m_18751_((Executor)Util.m_183991_(), (String)"worldgen-resetchunks");
        for (ChunkStatus chunkstatus : ImmutableList.of((Object)ChunkStatus.f_62317_, (Object)ChunkStatus.f_62318_, (Object)ChunkStatus.f_62319_, (Object)ChunkStatus.f_62320_, (Object)ChunkStatus.f_62321_, (Object)ChunkStatus.f_62322_)) {
            CompletionStage<Object> completablefuture = CompletableFuture.supplyAsync(() -> Unit.INSTANCE, arg_0 -> ((ProcessorMailbox)processormailbox).m_6937_(arg_0));
            for (int i2 = chunkpos.f_45579_ - p_183686_; i2 <= chunkpos.f_45579_ + p_183686_; ++i2) {
                for (int j2 = chunkpos.f_45578_ - p_183686_; j2 <= chunkpos.f_45578_ + p_183686_; ++j2) {
                    ChunkPos chunkpos2 = new ChunkPos(j2, i2);
                    LevelChunk levelchunk1 = serverchunkcache.m_62227_(j2, i2, false);
                    if (levelchunk1 == null || p_183687_ && levelchunk1.m_187675_()) continue;
                    ArrayList list = Lists.newArrayList();
                    int k2 = Math.max(1, chunkstatus.m_62488_());
                    for (int l2 = chunkpos2.f_45579_ - k2; l2 <= chunkpos2.f_45579_ + k2; ++l2) {
                        for (int i3 = chunkpos2.f_45578_ - k2; i3 <= chunkpos2.f_45578_ + k2; ++i3) {
                            ChunkAccess chunkaccess = serverchunkcache.m_7587_(i3, l2, chunkstatus.m_62482_(), true);
                            Object chunkaccess1 = chunkaccess instanceof ImposterProtoChunk ? new ImposterProtoChunk(((ImposterProtoChunk)chunkaccess).m_62768_(), true) : (chunkaccess instanceof LevelChunk ? new ImposterProtoChunk((LevelChunk)chunkaccess, true) : chunkaccess);
                            list.add(chunkaccess1);
                        }
                    }
                    completablefuture = completablefuture.thenComposeAsync(p_183678_ -> chunkstatus.m_187788_(arg_0 -> ((ProcessorMailbox)processormailbox).m_6937_(arg_0), serverlevel, serverchunkcache.m_8481_(), serverlevel.m_8875_(), serverchunkcache.m_7827_(), p_183691_ -> {
                        throw new UnsupportedOperationException("Not creating full chunks here");
                    }, list, true).thenApply(p_183681_ -> {
                        if (chunkstatus == ChunkStatus.f_62318_) {
                            p_183681_.left().ifPresent(p_183671_ -> Heightmap.m_64256_((ChunkAccess)p_183671_, (Set)ChunkStatus.f_62328_));
                        }
                        return Unit.INSTANCE;
                    }), arg_0 -> ((ProcessorMailbox)processormailbox).m_6937_(arg_0));
                }
            }
            p_183685_.m_81377_().m_18701_(() -> completablefuture.isDone());
        }
        for (int i4 = chunkpos.f_45579_ - p_183686_; i4 <= chunkpos.f_45579_ + p_183686_; ++i4) {
            for (int l1 = chunkpos.f_45578_ - p_183686_; l1 <= chunkpos.f_45578_ + p_183686_; ++l1) {
                ChunkPos chunkpos3 = new ChunkPos(l1, i4);
                LevelChunk levelchunk2 = serverchunkcache.m_62227_(l1, i4, false);
                if (levelchunk2 == null || p_183687_ && levelchunk2.m_187675_()) continue;
                for (BlockPos blockpos1 : BlockPos.m_121976_((int)chunkpos3.m_45604_(), (int)serverlevel.m_141937_(), (int)chunkpos3.m_45605_(), (int)chunkpos3.m_45608_(), (int)(serverlevel.m_151558_() - 1), (int)chunkpos3.m_45609_())) {
                    serverchunkcache.m_8450_(blockpos1);
                }
            }
        }
        return 1;
    }
}

