/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.registry.sapling;

import com.davenonymous.bonsaitrees3.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.libnonymous.json.MCJsonUtils;
import com.davenonymous.libnonymous.serialization.JsonHelpers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaplingSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<SaplingInfo> {
    private static final Logger LOGGER = LogManager.getLogger();

    private boolean isValidIngredient(JsonObject obj) {
        if (obj == null) {
            return false;
        }
        Item item = MCJsonUtils.getItem((JsonObject)obj, (String)"item");
        return !item.getRegistryName().toString().equals("minecraft:air");
    }

    public SaplingInfo fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient sapling = JsonHelpers.getIngredientFromArrayOrSingle((JsonElement)json.get("sapling"));
        if (sapling.m_43947_()) {
            LOGGER.info("Skipping recipe '{}', contains unknown sapling.", (Object)recipeId);
            return null;
        }
        int baseTicks = 200;
        if (json.has("ticks")) {
            baseTicks = json.get("ticks").getAsInt();
        }
        SaplingInfo result = new SaplingInfo(recipeId, sapling, baseTicks);
        if (json.has("drops")) {
            JsonArray dropsJson = json.getAsJsonArray("drops");
            for (JsonElement element : dropsJson) {
                if (!element.isJsonObject()) continue;
                JsonObject dropObj = element.getAsJsonObject();
                if (!this.isValidIngredient(dropObj.getAsJsonObject("result"))) {
                    LOGGER.info("Skipping recipe '{}', contains unknown drop.", (Object)recipeId);
                    return null;
                }
                SaplingDrop drop = new SaplingDrop(element.getAsJsonObject());
                result.addDrop(drop);
            }
        }
        if (json.has("compatibleSoilTags")) {
            JsonArray tagsJson = json.getAsJsonArray("compatibleSoilTags");
            for (JsonElement element : tagsJson) {
                String tag;
                if (!element.isJsonPrimitive() || (tag = element.getAsString()) == null) continue;
                result.addTag(tag);
            }
        }
        return result;
    }

    @Nullable
    public SaplingInfo fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int baseTicks = buffer.readInt();
        SaplingInfo result = new SaplingInfo(recipeId, ingredient, baseTicks);
        int dropCount = buffer.readInt();
        for (int i = 0; i < dropCount; ++i) {
            result.addDrop(new SaplingDrop(buffer));
        }
        int tagCount = buffer.readInt();
        for (int i = 0; i < tagCount; ++i) {
            result.addTag(buffer.m_130277_());
        }
        return result;
    }

    public void toNetwork(FriendlyByteBuf buffer, SaplingInfo sapling) {
        sapling.ingredient.m_43923_(buffer);
        buffer.writeInt(sapling.baseTicks);
        buffer.writeInt(sapling.drops.size());
        for (SaplingDrop drop : sapling.drops) {
            drop.write(buffer);
        }
        buffer.writeInt(sapling.tags.size());
        for (String tag : sapling.tags) {
            buffer.m_130070_(tag);
        }
    }
}

