/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.screen.v2;

import com.google.common.collect.MapMaker;
import fuzs.puzzleslib.api.client.event.v1.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenOpeningCallback;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class DeferredTooltipRendering {
    private static final Map<AbstractWidget, List<FormattedCharSequence>> WIDGET_TOOLTIPS = new MapMaker().weakKeys().makeMap();
    @Nullable
    private static List<FormattedCharSequence> tooltip;

    private DeferredTooltipRendering() {
    }

    @Deprecated(forRemoval=true)
    public static void setTooltipForNextRenderPass(Minecraft minecraft, Component tooltip) {
        DeferredTooltipRendering.setTooltipForNextRenderPass(tooltip);
    }

    public static void setTooltipForNextRenderPass(Component tooltip) {
        DeferredTooltipRendering.setTooltipForNextRenderPass(DeferredTooltipRendering.splitTooltip(new FormattedText[]{tooltip}));
    }

    public static void setTooltipForNextRenderPass(List<FormattedCharSequence> tooltip) {
        DeferredTooltipRendering.setTooltipForNextRenderPass(tooltip, true);
    }

    public static void setTooltipForNextRenderPass(List<FormattedCharSequence> tooltip, boolean override) {
        if (DeferredTooltipRendering.tooltip == null || override) {
            DeferredTooltipRendering.tooltip = tooltip;
        }
    }

    @Deprecated(forRemoval=true)
    public static List<FormattedCharSequence> splitTooltip(Minecraft minecraft, FormattedText ... tooltip) {
        return DeferredTooltipRendering.splitTooltip(Arrays.asList(tooltip));
    }

    public static List<FormattedCharSequence> splitTooltip(FormattedText ... tooltip) {
        return DeferredTooltipRendering.splitTooltip(Arrays.asList(tooltip));
    }

    @Deprecated(forRemoval=true)
    public static List<FormattedCharSequence> splitTooltip(Minecraft minecraft, List<? extends FormattedText> tooltip) {
        return DeferredTooltipRendering.splitTooltip(tooltip);
    }

    public static List<FormattedCharSequence> splitTooltip(List<? extends FormattedText> tooltip) {
        Font font = Minecraft.m_91087_().f_91062_;
        return tooltip.stream().flatMap(t -> {
            List<FormattedCharSequence> list = font.m_92923_(t, 170);
            if (list.isEmpty()) {
                list = List.of(FormattedCharSequence.f_13691_);
            }
            return list.stream();
        }).toList();
    }

    @Deprecated(forRemoval=true)
    public static void setTooltipForNextRenderPass(Minecraft minecraft, AbstractWidget abstractWidget, FormattedText ... tooltip) {
        DeferredTooltipRendering.setTooltip(abstractWidget, tooltip);
    }

    public static <T extends AbstractWidget> T setTooltip(T abstractWidget, FormattedText ... tooltip) {
        return DeferredTooltipRendering.setTooltip(abstractWidget, Arrays.asList(tooltip));
    }

    @Deprecated(forRemoval=true)
    public static void setTooltipForNextRenderPass(AbstractWidget abstractWidget, List<? extends FormattedText> tooltip) {
        DeferredTooltipRendering.setTooltip(abstractWidget, tooltip);
    }

    public static <T extends AbstractWidget> T setTooltip(T abstractWidget, List<? extends FormattedText> tooltip) {
        return DeferredTooltipRendering.setWidgetTooltip(abstractWidget, DeferredTooltipRendering.splitTooltip(tooltip));
    }

    public static <T extends AbstractWidget> T setWidgetTooltip(T abstractWidget, @Nullable List<FormattedCharSequence> tooltip) {
        if (tooltip != null) {
            WIDGET_TOOLTIPS.put(abstractWidget, tooltip);
        } else {
            WIDGET_TOOLTIPS.remove(abstractWidget);
        }
        return abstractWidget;
    }

    @ApiStatus.Internal
    public static void registerHandlers() {
        ScreenEvents.afterRender(Screen.class).register((screen, poseStack, mouseX, mouseY, tickDelta) -> {
            screen.m_6702_().forEach(DeferredTooltipRendering::updateTooltip);
            if (tooltip != null) {
                screen.m_96617_(poseStack, tooltip, mouseX, mouseY);
                tooltip = null;
            }
        });
        ScreenOpeningCallback.EVENT.register((oldScreen, newScreen) -> {
            tooltip = null;
            return EventResult.PASS;
        });
        ScreenEvents.remove(Screen.class).register(screen -> {
            tooltip = null;
        });
    }

    private static void updateTooltip(GuiEventListener guiEventListener) {
        if (guiEventListener instanceof ContainerEventHandler) {
            ContainerEventHandler containerEventHandler = (ContainerEventHandler)guiEventListener;
            containerEventHandler.m_6702_().forEach(DeferredTooltipRendering::updateTooltip);
        } else if (guiEventListener instanceof AbstractWidget) {
            List<FormattedCharSequence> tooltip;
            AbstractWidget abstractWidget = (AbstractWidget)guiEventListener;
            if (abstractWidget.f_93624_ && abstractWidget.m_198029_() && (tooltip = WIDGET_TOOLTIPS.get(abstractWidget)) != null) {
                DeferredTooltipRendering.setTooltipForNextRenderPass(tooltip, abstractWidget.m_93696_());
            }
        }
    }
}

