/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public final class AbstractLootProvider {
    public static LootTableProvider createProvider(DataGenerator packOutput, final Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> provider, final LootContextParamSet paramSet) {
        return new LootTableProvider(packOutput){

            protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
                return ImmutableList.of((Object)Pair.of(() -> provider, (Object)paramSet));
            }

            protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
            }
        };
    }

    public static abstract class Simple
    extends LootTableProvider
    implements DataProvider,
    Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> provider;
        private final Map<ResourceLocation, LootTable.Builder> values = Maps.newHashMap();

        @Deprecated(forRemoval=true)
        public Simple(DataGenerator packOutput, LootContextParamSet paramSet) {
            this(paramSet, packOutput, "");
        }

        public Simple(LootContextParamSet paramSet, GatherDataEvent evt, String modId) {
            this(paramSet, evt.getGenerator(), modId);
        }

        public Simple(LootContextParamSet paramSet, DataGenerator packOutput, String modId) {
            super(packOutput);
            this.provider = ImmutableList.of((Object)Pair.of(() -> this, (Object)paramSet));
        }

        public String m_6055_() {
            return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName()), (char)' ');
        }

        protected void validate(Map<ResourceLocation, LootTable> tables, ValidationContext context) {
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return this.provider;
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.generate();
            this.values.forEach(consumer);
        }

        protected void add(ResourceLocation table, LootTable.Builder builder) {
            this.values.put(table, builder);
        }

        public abstract void generate();
    }

    public static abstract class EntityTypes
    extends EntityLoot
    implements DataProvider {
        private final LootTableProvider provider;
        private final String modId;

        public EntityTypes(GatherDataEvent evt, String modId) {
            this(evt.getGenerator(), modId);
        }

        public EntityTypes(DataGenerator packOutput, String modId) {
            this.provider = AbstractLootProvider.createProvider(packOutput, (Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>)((Object)this), LootContextParamSets.f_81415_);
            this.modId = modId;
        }

        public final void m_6865_(HashCache output) {
            this.provider.m_6865_(output);
        }

        public String m_6055_() {
            return "Entity Type Loot Tables";
        }

        public abstract void generate();

        protected final void addTables() {
            this.generate();
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId)).map(Map.Entry::getValue).collect(Collectors.toSet());
        }

        protected boolean isNonLiving(EntityType<?> entityType) {
            return entityType.m_20674_() == MobCategory.MISC;
        }
    }

    public static abstract class Blocks
    extends BlockLoot
    implements DataProvider {
        private final LootTableProvider provider;
        private final String modId;

        public Blocks(GatherDataEvent evt, String modId) {
            this(evt.getGenerator(), modId);
        }

        public Blocks(DataGenerator packOutput, String modId) {
            this.provider = AbstractLootProvider.createProvider(packOutput, (Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>)((Object)this), LootContextParamSets.f_81421_);
            this.modId = modId;
        }

        public final void m_6865_(HashCache output) {
            this.provider.m_6865_(output);
        }

        public String m_6055_() {
            return "Block Loot Tables";
        }

        public abstract void generate();

        public final void addTables() {
            this.generate();
        }

        protected void dropNothing(Block block) {
            this.m_124165_(block, Blocks.m_124125_());
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId)).map(Map.Entry::getValue).collect(Collectors.toSet());
        }
    }
}

