/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractModelProvider
extends BlockStateProvider {
    public AbstractModelProvider(GatherDataEvent evt, String modId) {
        this(evt.getGenerator(), evt.getExistingFileHelper(), modId);
    }

    public AbstractModelProvider(DataGenerator packOutput, ExistingFileHelper fileHelper, String modId) {
        super(packOutput, modId, fileHelper);
    }

    @Deprecated(forRemoval=true)
    public AbstractModelProvider(DataGenerator packOutput, String modId, ExistingFileHelper fileHelper) {
        this(packOutput, fileHelper, modId);
    }

    protected abstract void registerStatesAndModels();

    public void simpleExistingBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.existingBlockModel(block));
    }

    public void simpleExistingBlockWithItem(Block block) {
        ModelFile.ExistingModelFile model = this.existingBlockModel(block);
        this.simpleBlock(block, (ModelFile)model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    public ModelFile.ExistingModelFile existingBlockModel(Block block) {
        return new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper);
    }

    public void builtInBlock(Block block, Block particleTexture) {
        this.builtInBlock(block, this.blockTexture(particleTexture));
    }

    public void builtInBlock(Block block, ResourceLocation particleTexture) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", particleTexture));
    }

    public void cubeBottomTopBlock(Block block) {
        this.cubeBottomTopBlock(block, this.extend(this.blockTexture(block), "_side"), this.extend(this.blockTexture(block), "_bottom"), this.extend(this.blockTexture(block), "_top"));
        this.itemModels().withExistingParent(this.name(block), this.extendKey(block, "block"));
    }

    public void cubeBottomTopBlock(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), side, bottom, top));
    }

    public ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
    }

    public String name(Block block) {
        return this.key(block).m_135815_();
    }

    public String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).m_135815_();
    }

    public ItemModelBuilder builtInItem(Item item, Block texture) {
        return this.builtInItem(item, texture, this.mcLoc("builtin/entity"));
    }

    public ItemModelBuilder builtInItem(Item item, Block texture, ResourceLocation parent) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.itemName(item))).parent((ModelFile)this.itemModels().getExistingFile(parent))).texture("particle", this.blockTexture(texture));
    }

    public ResourceLocation extendKey(Block block, String ... extensions) {
        ResourceLocation loc = this.key(block);
        extensions = (String[])ArrayUtils.add((Object[])extensions, (Object)loc.m_135815_());
        return new ResourceLocation(loc.m_135827_(), String.join((CharSequence)"/", extensions));
    }

    public ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    public ItemModelBuilder basicItem(Item item) {
        return this.itemModels().basicItem(item);
    }

    public ItemModelBuilder basicItem(ResourceLocation item) {
        return this.itemModels().basicItem(item);
    }

    public ItemModelBuilder spawnEgg(Item item) {
        return this.spawnEgg(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item)));
    }

    public ItemModelBuilder spawnEgg(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/template_spawn_egg"));
    }

    public ItemModelBuilder handheldItem(Item item) {
        return this.handheldItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item)));
    }

    public ItemModelBuilder handheldItem(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", new ResourceLocation(item.m_135827_(), "item/" + item.m_135815_()));
    }

    public ItemModelBuilder basicItem(Item item, ResourceLocation texture) {
        return this.basicItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item)), texture);
    }

    public ItemModelBuilder basicItem(ResourceLocation item, Item texture) {
        return this.basicItem(item, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)texture)));
    }

    public ItemModelBuilder basicItem(ResourceLocation item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(texture.m_135827_(), "item/" + texture.m_135815_()));
    }
}

