/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.event;

import com.mojang.blaze3d.shaders.FogShape;
import fuzs.puzzleslib.api.client.event.v1.ClientChunkEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientLevelTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientPlayerEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.ContainerScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.CustomizeChatPanelCallback;
import fuzs.puzzleslib.api.client.event.v1.FogEvents;
import fuzs.puzzleslib.api.client.event.v1.GameRenderEvents;
import fuzs.puzzleslib.api.client.event.v1.InputEvents;
import fuzs.puzzleslib.api.client.event.v1.InteractionInputEvents;
import fuzs.puzzleslib.api.client.event.v1.InventoryMobEffectsCallback;
import fuzs.puzzleslib.api.client.event.v1.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.ModelEvents;
import fuzs.puzzleslib.api.client.event.v1.MovementInputUpdateCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderBlockOverlayCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiElementEvents;
import fuzs.puzzleslib.api.client.event.v1.RenderHandCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderHighlightCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.RenderNameTagCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderPlayerEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenKeyboardEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.event.v1.ScreenTooltipEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.impl.client.event.ForgeButtonList;
import fuzs.puzzleslib.impl.client.event.ScreenCloseEvent;
import fuzs.puzzleslib.impl.event.ForgeEventInvokerRegistryImpl;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public final class ForgeClientEventInvokers {
    @Nullable
    private static Frustum capturedFrustum;

    public static void register() {
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientTickEvents.Start.class, TickEvent.ClientTickEvent.class, (callback, evt) -> {
            if (evt.phase == TickEvent.Phase.START) {
                callback.onStartTick(Minecraft.m_91087_());
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientTickEvents.End.class, TickEvent.ClientTickEvent.class, (callback, evt) -> {
            if (evt.phase == TickEvent.Phase.END) {
                callback.onEndTick(Minecraft.m_91087_());
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderGuiCallback.class, RenderGameOverlayEvent.Post.class, (callback, evt) -> {
            if (evt.getType() != RenderGameOverlayEvent.ElementType.ALL) {
                return;
            }
            callback.onRenderGui(Minecraft.m_91087_(), evt.getMatrixStack(), evt.getPartialTicks(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ItemTooltipCallback.class, ItemTooltipEvent.class, (callback, evt) -> callback.onItemTooltip(evt.getItemStack(), evt.getPlayer(), evt.getToolTip(), evt.getFlags()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderNameTagCallback.class, RenderNameplateEvent.class, (callback, evt) -> {
            DefaultedValue<Component> content = DefaultedValue.fromEvent(arg_0 -> ((RenderNameplateEvent)evt).setContent(arg_0), () -> ((RenderNameplateEvent)evt).getContent(), () -> ((RenderNameplateEvent)evt).getOriginalContent());
            EventResult result = callback.onRenderNameTag(evt.getEntity(), content, evt.getEntityRenderer(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTick());
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ContainerScreenEvents.Background.class, ContainerScreenEvent.DrawBackground.class, (callback, evt) -> callback.onDrawBackground(evt.getContainerScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ContainerScreenEvents.Foreground.class, ContainerScreenEvent.DrawForeground.class, (callback, evt) -> callback.onDrawForeground(evt.getContainerScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InventoryMobEffectsCallback.class, ScreenEvent.PotionSizeEvent.class, (callback, evt) -> {
            AbstractContainerScreen screen = (AbstractContainerScreen)evt.getScreen();
            MutableInt horizontalOffset = MutableInt.fromValue(screen.getGuiLeft() + screen.getXSize() + 2);
            int availableSpace = screen.f_96543_ - horizontalOffset.getAsInt();
            MutableBoolean fullSizeRendering = MutableBoolean.fromEvent(flag -> evt.setResult(flag != false ? Event.Result.ALLOW : Event.Result.DENY), () -> availableSpace < 120 && evt.getResult() == Event.Result.DEFAULT || evt.getResult() == Event.Result.ALLOW);
            callback.onInventoryMobEffects(evt.getScreen(), availableSpace, fullSizeRendering, horizontalOffset);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ScreenOpeningCallback.class, ScreenOpenEvent.class, (callback, evt) -> {
            Screen oldScreen = Minecraft.m_91087_().f_91080_;
            DefaultedValue<Screen> newScreen = DefaultedValue.fromEvent(arg_0 -> ((ScreenOpenEvent)evt).setScreen(arg_0), () -> ((ScreenOpenEvent)evt).getScreen(), () -> ((ScreenOpenEvent)evt).getScreen());
            EventResult result = callback.onScreenOpening(oldScreen, newScreen);
            if (result.isInterrupt() || newScreen.getAsOptional().filter(screen -> screen == oldScreen).isPresent()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ComputeFovModifierCallback.class, FOVModifierEvent.class, (callback, evt) -> {
            float fovEffectScale = Minecraft.m_91087_().f_91066_.f_92070_;
            if (fovEffectScale == 0.0f) {
                return;
            }
            Consumer<Float> consumer = value -> evt.setNewfov(Mth.m_14179_((float)fovEffectScale, (float)1.0f, (float)value.floatValue()));
            Supplier<Float> supplier = () -> Float.valueOf((evt.getNewfov() - 1.0f) / fovEffectScale + 1.0f);
            callback.onComputeFovModifier(evt.getEntity(), DefaultedFloat.fromEvent(consumer, supplier, () -> ((FOVModifierEvent)evt).getFov()));
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ScreenEvents.BeforeInit.class, ScreenEvent.InitScreenEvent.Pre.class, (callback, evt) -> callback.onBeforeInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_)));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ScreenEvents.AfterInit.class, ScreenEvent.InitScreenEvent.Post.class, (callback, evt) -> callback.onAfterInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_), arg_0 -> ((ScreenEvent.InitScreenEvent.Post)evt).addListener(arg_0), arg_0 -> ((ScreenEvent.InitScreenEvent.Post)evt).removeListener(arg_0)));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.Remove.class, ScreenCloseEvent.class, (callback, evt) -> callback.onRemove(evt.getScreen()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeRender.class, ScreenEvent.DrawScreenEvent.Pre.class, (callback, evt) -> callback.onBeforeRender(evt.getScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTicks()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterRender.class, ScreenEvent.DrawScreenEvent.Post.class, (callback, evt) -> callback.onAfterRender(evt.getScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTicks()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseClick.class, ScreenEvent.MouseClickedEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseClick.class, ScreenEvent.MouseClickedEvent.Post.class, (callback, evt) -> callback.onAfterMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseRelease.class, ScreenEvent.MouseReleasedEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseRelease.class, ScreenEvent.MouseReleasedEvent.Post.class, (callback, evt) -> callback.onAfterMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseScroll.class, ScreenEvent.MouseScrollEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDelta(), evt.getScrollDelta());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseScroll.class, ScreenEvent.MouseScrollEvent.Post.class, (callback, evt) -> callback.onAfterMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDelta(), evt.getScrollDelta()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseDrag.class, ScreenEvent.MouseDragEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseDrag.class, ScreenEvent.MouseDragEvent.Post.class, (callback, evt) -> callback.onAfterMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyPress.class, ScreenEvent.KeyboardKeyPressedEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyPress.class, ScreenEvent.KeyboardKeyPressedEvent.Post.class, (callback, evt) -> callback.onAfterKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyRelease.class, ScreenEvent.KeyboardKeyReleasedEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyRelease.class, ScreenEvent.KeyboardKeyReleasedEvent.Post.class, (callback, evt) -> callback.onAfterKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderGuiElementEvents.Before.class, RenderGameOverlayEvent.PreLayer.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            RenderGuiElementEvents.GuiOverlay overlay = (RenderGuiElementEvents.GuiOverlay)context;
            OverlayRegistry.OverlayEntry entry = OverlayRegistry.getEntry((IIngameOverlay)evt.getOverlay());
            Minecraft minecraft = Minecraft.m_91087_();
            if (entry == null || !Objects.equals(overlay.id().toString(), entry.getDisplayName()) || !overlay.filter().test(minecraft)) {
                return;
            }
            EventResult result = callback.onBeforeRenderGuiElement(minecraft, evt.getMatrixStack(), evt.getPartialTicks(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderGuiElementEvents.After.class, RenderGameOverlayEvent.PostLayer.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            RenderGuiElementEvents.GuiOverlay overlay = (RenderGuiElementEvents.GuiOverlay)context;
            OverlayRegistry.OverlayEntry entry = OverlayRegistry.getEntry((IIngameOverlay)evt.getOverlay());
            Minecraft minecraft = Minecraft.m_91087_();
            if (entry == null || !Objects.equals(overlay.id().toString(), entry.getDisplayName()) || !overlay.filter().test(minecraft)) {
                return;
            }
            callback.onAfterRenderGuiElement(minecraft, evt.getMatrixStack(), evt.getPartialTicks(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(CustomizeChatPanelCallback.class, RenderGameOverlayEvent.Chat.class, (callback, evt) -> {
            MutableInt posX = MutableInt.fromEvent(arg_0 -> ((RenderGameOverlayEvent.Chat)evt).setPosX(arg_0), () -> ((RenderGameOverlayEvent.Chat)evt).getPosX());
            MutableInt posY = MutableInt.fromEvent(arg_0 -> ((RenderGameOverlayEvent.Chat)evt).setPosY(arg_0), () -> ((RenderGameOverlayEvent.Chat)evt).getPosY());
            callback.onRenderChatPanel(evt.getWindow(), evt.getMatrixStack(), evt.getPartialTicks(), posX, posY);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientEntityLevelEvents.Load.class, EntityJoinWorldEvent.class, (callback, evt) -> {
            if (!evt.getWorld().f_46443_) {
                return;
            }
            if (callback.onEntityLoad(evt.getEntity(), (ClientLevel)evt.getWorld()).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientEntityLevelEvents.Unload.class, EntityLeaveWorldEvent.class, (callback, evt) -> {
            if (!evt.getWorld().f_46443_) {
                return;
            }
            callback.onEntityUnload(evt.getEntity(), (ClientLevel)evt.getWorld());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.BeforeMouseAction.class, InputEvent.RawMouseEvent.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseAction(evt.getButton(), evt.getAction(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.AfterMouseAction.class, InputEvent.MouseInputEvent.class, (callback, evt) -> callback.onAfterMouseAction(evt.getButton(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.BeforeMouseScroll.class, InputEvent.MouseScrollEvent.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseScroll(evt.isLeftDown(), evt.isMiddleDown(), evt.isRightDown(), evt.getScrollDelta(), evt.getScrollDelta());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.AfterMouseScroll.class, InputEvent.MouseScrollEvent.class, (callback, evt) -> callback.onAfterMouseScroll(evt.isLeftDown(), evt.isMiddleDown(), evt.isRightDown(), evt.getScrollDelta(), evt.getScrollDelta()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.BeforeKeyAction.class, InputEvent.KeyInputEvent.class, (callback, evt) -> callback.onBeforeKeyAction(evt.getKey(), evt.getScanCode(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InputEvents.AfterKeyAction.class, InputEvent.KeyInputEvent.class, (callback, evt) -> callback.onAfterKeyAction(evt.getKey(), evt.getScanCode(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ComputeCameraAnglesCallback.class, EntityViewRenderEvent.CameraSetup.class, (callback, evt) -> {
            MutableFloat pitch = MutableFloat.fromEvent(arg_0 -> ((EntityViewRenderEvent.CameraSetup)evt).setPitch(arg_0), () -> ((EntityViewRenderEvent.CameraSetup)evt).getPitch());
            MutableFloat yaw = MutableFloat.fromEvent(arg_0 -> ((EntityViewRenderEvent.CameraSetup)evt).setYaw(arg_0), () -> ((EntityViewRenderEvent.CameraSetup)evt).getYaw());
            MutableFloat roll = MutableFloat.fromEvent(arg_0 -> ((EntityViewRenderEvent.CameraSetup)evt).setRoll(arg_0), () -> ((EntityViewRenderEvent.CameraSetup)evt).getRoll());
            callback.onComputeCameraAngles(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTicks(), pitch, yaw, roll);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderPlayerEvents.Before.class, RenderPlayerEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeRenderPlayer(evt.getPlayer(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderPlayerEvents.After.class, RenderPlayerEvent.Post.class, (callback, evt) -> callback.onAfterRenderPlayer(evt.getPlayer(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderHandCallback.class, RenderHandEvent.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            EventResult result = callback.onRenderHand((Player)minecraft.f_91074_, evt.getHand(), evt.getItemStack(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTicks(), evt.getInterpolatedPitch(), evt.getSwingProgress(), evt.getEquipProgress());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientLevelTickEvents.Start.class, TickEvent.WorldTickEvent.class, (callback, evt) -> {
            Level patt19890$temp;
            if (evt.phase != TickEvent.Phase.START || !((patt19890$temp = evt.world) instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt19890$temp;
            callback.onStartLevelTick(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientLevelTickEvents.End.class, TickEvent.WorldTickEvent.class, (callback, evt) -> {
            Level patt20239$temp;
            if (evt.phase != TickEvent.Phase.END || !((patt20239$temp = evt.world) instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt20239$temp;
            callback.onEndLevelTick(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientChunkEvents.Load.class, ChunkEvent.Load.class, (callback, evt) -> {
            LevelAccessor patt20531$temp = evt.getWorld();
            if (!(patt20531$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt20531$temp;
            callback.onChunkLoad(level, evt.getChunk());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientChunkEvents.Unload.class, ChunkEvent.Unload.class, (callback, evt) -> {
            LevelAccessor patt20819$temp = evt.getWorld();
            if (!(patt20819$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt20819$temp;
            callback.onChunkUnload(level, evt.getChunk());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientPlayerEvents.LoggedIn.class, ClientPlayerNetworkEvent.LoggedInEvent.class, (callback, evt) -> callback.onLoggedIn(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientPlayerEvents.LoggedOut.class, ClientPlayerNetworkEvent.LoggedOutEvent.class, (callback, evt) -> {
            if (evt.getPlayer() == null || evt.getMultiPlayerGameMode() == null) {
                return;
            }
            Objects.requireNonNull(evt.getConnection(), "connection is null");
            callback.onLoggedOut(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection());
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientPlayerEvents.Copy.class, ClientPlayerNetworkEvent.RespawnEvent.class, (callback, evt) -> callback.onCopy(evt.getOldPlayer(), evt.getNewPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(InteractionInputEvents.Attack.class, InputEvent.ClickInputEvent.class, (callback, evt) -> {
            if (!evt.isAttack()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (callback.onAttackInteraction(minecraft, minecraft.f_91074_).isInterrupt()) {
                evt.setSwingHand(false);
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientLevelEvents.Load.class, WorldEvent.Load.class, (callback, evt) -> {
            LevelAccessor patt22881$temp = evt.getWorld();
            if (!(patt22881$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt22881$temp;
            callback.onLevelLoad(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ClientLevelEvents.Unload.class, WorldEvent.Unload.class, (callback, evt) -> {
            LevelAccessor patt23178$temp = evt.getWorld();
            if (!(patt23178$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt23178$temp;
            callback.onLevelUnload(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(MovementInputUpdateCallback.class, MovementInputUpdateEvent.class, (callback, evt) -> callback.onMovementInputUpdate((LocalPlayer)evt.getEntity(), evt.getInput()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ModelEvents.ModifyBakingResult.class, ModelBakeEvent.class, (callback, evt) -> callback.onModifyBakingResult(evt.getModelRegistry(), () -> ((ModelBakeEvent)evt).getModelLoader()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ModelEvents.BakingCompleted.class, ModelBakeEvent.class, (callback, evt) -> callback.onBakingCompleted(() -> ((ModelBakeEvent)evt).getModelManager(), Collections.unmodifiableMap(evt.getModelRegistry()), () -> ((ModelBakeEvent)evt).getModelLoader()));
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderBlockOverlayCallback.class, RenderBlockOverlayEvent.class, (callback, evt) -> {
            EventResult result = callback.onRenderBlockOverlay((LocalPlayer)evt.getPlayer(), evt.getPoseStack(), evt.getBlockState());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(FogEvents.Render.class, EntityViewRenderEvent.RenderFogEvent.class, (callback, evt) -> {
            MutableFloat nearPlaneDistance = MutableFloat.fromEvent(t -> {
                evt.setNearPlaneDistance(t.floatValue());
                evt.setCanceled(true);
            }, () -> ((EntityViewRenderEvent.RenderFogEvent)evt).getNearPlaneDistance());
            MutableFloat farPlaneDistance = MutableFloat.fromEvent(t -> {
                evt.setFarPlaneDistance(t.floatValue());
                evt.setCanceled(true);
            }, () -> ((EntityViewRenderEvent.RenderFogEvent)evt).getFarPlaneDistance());
            MutableValue<FogShape> fogShape = MutableValue.fromEvent(t -> {
                evt.setFogShape(t);
                evt.setCanceled(true);
            }, () -> ((EntityViewRenderEvent.RenderFogEvent)evt).getFogShape());
            callback.onRenderFog(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTicks(), evt.getMode(), evt.getCamera().m_167685_(), nearPlaneDistance, farPlaneDistance, fogShape);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(FogEvents.ComputeColor.class, EntityViewRenderEvent.FogColors.class, (callback, evt) -> {
            MutableFloat red = MutableFloat.fromEvent(arg_0 -> ((EntityViewRenderEvent.FogColors)evt).setRed(arg_0), () -> ((EntityViewRenderEvent.FogColors)evt).getRed());
            MutableFloat green = MutableFloat.fromEvent(arg_0 -> ((EntityViewRenderEvent.FogColors)evt).setGreen(arg_0), () -> ((EntityViewRenderEvent.FogColors)evt).getGreen());
            MutableFloat blue = MutableFloat.fromEvent(arg_0 -> ((EntityViewRenderEvent.FogColors)evt).setBlue(arg_0), () -> ((EntityViewRenderEvent.FogColors)evt).getBlue());
            callback.onComputeFogColor(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTicks(), red, green, blue);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(ScreenTooltipEvents.Render.class, RenderTooltipEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onRenderTooltip(evt.getPoseStack(), evt.getX(), evt.getY(), evt.getScreenWidth(), evt.getScreenHeight(), evt.getFont(), evt.getComponents());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderHighlightCallback.class, DrawSelectionEvent.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (!(minecraft.m_91288_() instanceof Player) || minecraft.f_91066_.f_92062_) {
                return;
            }
            EventResult result = callback.onRenderHighlight(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getTarget(), evt.getPartialTicks(), evt.getPoseStack(), evt.getMultiBufferSource(), minecraft.f_91073_);
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderLevelEvents.AfterTerrain.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterTerrain(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.f_91073_);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderLevelEvents.AfterEntities.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterEntities(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.f_91073_);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderLevelEvents.AfterTranslucent.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterTranslucent(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.f_91073_);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(RenderLevelEvents.AfterLevel.class, RenderLevelLastEvent.class, (callback, evt) -> {
            Objects.requireNonNull(capturedFrustum, "captured frustum is null");
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterLevel(evt.getLevelRenderer(), minecraft.f_91063_.m_109153_(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), capturedFrustum, minecraft.f_91073_);
            capturedFrustum = null;
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(GameRenderEvents.Before.class, TickEvent.RenderTickEvent.class, (callback, evt) -> {
            if (evt.phase != TickEvent.Phase.START) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onBeforeGameRender(minecraft, minecraft.f_91063_, evt.renderTickTime);
        });
        ForgeEventInvokerRegistryImpl.INSTANCE.register(GameRenderEvents.After.class, TickEvent.RenderTickEvent.class, (callback, evt) -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onAfterGameRender(minecraft, minecraft.f_91063_, evt.renderTickTime);
        });
    }

    private static <T, E extends ScreenEvent> void registerScreenEvent(Class<T> clazz, Class<E> event, BiConsumer<T, E> converter) {
        ForgeEventInvokerRegistryImpl.INSTANCE.register(clazz, event, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            if (!((Class)context).isInstance(evt.getScreen())) {
                return;
            }
            converter.accept(callback, evt);
        });
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                return;
            }
            capturedFrustum = evt.getFrustum();
        });
    }
}

