/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.event;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.core.ForgeEventInvokerRegistry;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.ProjectileImpactCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.BabyEntitySpawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.CheckMobDespawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ItemAttributeModifiersCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingChangeTargetCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LootingLevelCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilRepairCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilUpdateCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BonemealCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemTossCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemTouchCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerXpEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.level.GatherPotentialSpawnsCallback;
import fuzs.puzzleslib.api.event.v1.level.PlayLevelSoundEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerChunkEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelTickEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterCommandsCallback;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import fuzs.puzzleslib.api.event.v1.server.SyncDataPackContentsCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.impl.client.event.ForgeClientEventInvokers;
import fuzs.puzzleslib.impl.event.AttributeModifiersMultimap;
import fuzs.puzzleslib.impl.event.LivingJumpHelper;
import fuzs.puzzleslib.impl.event.LootTableModifyEvent;
import fuzs.puzzleslib.impl.event.PotentialSpawnsList;
import fuzs.puzzleslib.impl.event.SpawnTypeMob;
import fuzs.puzzleslib.impl.event.core.EventInvokerLike;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public final class ForgeEventInvokerRegistryImpl
implements ForgeEventInvokerRegistry {
    public static final ForgeEventInvokerRegistryImpl INSTANCE = new ForgeEventInvokerRegistryImpl();
    private static final Map<Class<?>, EventInvokerLike<?>> EVENT_INVOKER_LOOKUP = Collections.synchronizedMap(Maps.newIdentityHashMap());

    public <T> EventInvoker<T> lookup(Class<T> clazz, @Nullable Object context) {
        Objects.requireNonNull(clazz, "type is null");
        EventInvokerLike<?> invokerLike = EVENT_INVOKER_LOOKUP.get(clazz);
        Objects.requireNonNull(invokerLike, "invoker for type %s is null".formatted(clazz));
        EventInvoker<?> invoker = invokerLike.asEventInvoker(context);
        Objects.requireNonNull(invoker, "invoker for type %s is null".formatted(clazz));
        return invoker;
    }

    @Override
    public <T, E extends Event> void register(Class<T> clazz, Class<E> event, ForgeEventInvokerRegistry.ForgeEventContextConsumer<T, E> converter) {
        FMLJavaModLoadingContext context;
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(converter, "converter is null");
        IEventBus eventBus = IModBusEvent.class.isAssignableFrom(event) ? ((context = FMLJavaModLoadingContext.get()) != null ? context.getModEventBus() : null) : MinecraftForge.EVENT_BUS;
        ForgeEventInvokerRegistryImpl.register(clazz, new ForgeEventInvoker<T, E>(eventBus, event, converter));
    }

    private static <T> void register(Class<T> clazz, EventInvokerLike<T> invoker) {
        if (EVENT_INVOKER_LOOKUP.put(clazz, invoker) != null) {
            throw new IllegalArgumentException("duplicate event invoker for type %s".formatted(clazz));
        }
    }

    static {
        INSTANCE.register(PlayerInteractEvents.UseBlock.class, PlayerInteractEvent.RightClickBlock.class, (T callback, E evt) -> {
            EventResultHolder<InteractionResult> result = callback.onUseBlock(evt.getPlayer(), evt.getWorld(), evt.getHand(), evt.getHitVec());
            if (result.isInterrupt()) {
                evt.setCancellationResult(result.getInterrupt().orElseThrow());
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.AttackBlock.class, PlayerInteractEvent.LeftClickBlock.class, (T callback, E evt) -> {
            EventResultHolder<InteractionResult> result = callback.onAttackBlock(evt.getPlayer(), evt.getWorld(), evt.getHand(), evt.getPos(), evt.getFace());
            if (result.isInterrupt()) {
                evt.setCancellationResult(result.getInterrupt().orElseThrow());
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseItem.class, PlayerInteractEvent.RightClickItem.class, (T callback, E evt) -> {
            EventResultHolder<InteractionResultHolder<ItemStack>> result = callback.onUseItem(evt.getPlayer(), evt.getWorld(), evt.getHand());
            if (result.isInterrupt()) {
                evt.setCancellationResult(result.getInterrupt().orElseThrow().m_19089_());
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseEntity.class, PlayerInteractEvent.EntityInteract.class, (T callback, E evt) -> {
            EventResultHolder<InteractionResult> result = callback.onUseEntity(evt.getPlayer(), evt.getWorld(), evt.getHand(), evt.getTarget());
            if (result.isInterrupt()) {
                evt.setCancellationResult(result.getInterrupt().orElseThrow());
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseEntityAt.class, PlayerInteractEvent.EntityInteractSpecific.class, (T callback, E evt) -> {
            EventResultHolder<InteractionResult> result = callback.onUseEntityAt(evt.getPlayer(), evt.getWorld(), evt.getHand(), evt.getTarget(), evt.getLocalPos());
            if (result.isInterrupt()) {
                evt.setCancellationResult(result.getInterrupt().orElseThrow());
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.AttackEntity.class, AttackEntityEvent.class, (T callback, E evt) -> {
            if (callback.onAttackEntity(evt.getPlayer(), evt.getPlayer().f_19853_, InteractionHand.MAIN_HAND, evt.getTarget()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerXpEvents.PickupXp.class, PlayerXpEvent.PickupXp.class, (T callback, E evt) -> {
            if (callback.onPickupXp(evt.getPlayer(), evt.getOrb()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BonemealCallback.class, BonemealEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onBonemeal(evt.getWorld(), evt.getPos(), evt.getBlock(), evt.getStack());
            if (result.isInterrupt()) {
                if (result.getAsBoolean()) {
                    evt.setResult(Event.Result.ALLOW);
                } else {
                    evt.setCanceled(true);
                }
            }
        });
        INSTANCE.register(LivingExperienceDropCallback.class, LivingExperienceDropEvent.class, (T callback, E evt) -> {
            DefaultedInt droppedExperience = DefaultedInt.fromEvent(arg_0 -> ((LivingExperienceDropEvent)evt).setDroppedExperience(arg_0), () -> ((LivingExperienceDropEvent)evt).getDroppedExperience(), () -> ((LivingExperienceDropEvent)evt).getOriginalExperience());
            if (callback.onLivingExperienceDrop(evt.getEntityLiving(), evt.getAttackingPlayer(), droppedExperience).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BlockEvents.FarmlandTrample.class, BlockEvent.FarmlandTrampleEvent.class, (T callback, E evt) -> {
            if (callback.onFarmlandTrample((Level)evt.getWorld(), evt.getPos(), evt.getState(), evt.getFallDistance(), evt.getEntity()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerTickEvents.Start.class, TickEvent.PlayerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.START) {
                return;
            }
            callback.onStartPlayerTick(evt.player);
        });
        INSTANCE.register(PlayerTickEvents.End.class, TickEvent.PlayerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            callback.onEndPlayerTick(evt.player);
        });
        INSTANCE.register(LivingFallCallback.class, LivingFallEvent.class, (T callback, E evt) -> {
            MutableFloat fallDistance = MutableFloat.fromEvent(arg_0 -> ((LivingFallEvent)evt).setDistance(arg_0), () -> ((LivingFallEvent)evt).getDistance());
            MutableFloat damageMultiplier = MutableFloat.fromEvent(arg_0 -> ((LivingFallEvent)evt).setDamageMultiplier(arg_0), () -> ((LivingFallEvent)evt).getDamageMultiplier());
            if (callback.onLivingFall(evt.getEntityLiving(), fallDistance, damageMultiplier).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(RegisterCommandsCallback.class, RegisterCommandsEvent.class, (T callback, E evt) -> callback.onRegisterCommands((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getEnvironment()));
        INSTANCE.register(LootTableLoadEvents.Replace.class, LootTableLoadEvent.class, (T callback, E evt) -> {
            MutableValue<LootTable> table = MutableValue.fromEvent(arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0), () -> ((LootTableLoadEvent)evt).getTable());
            callback.onReplaceLootTable(evt.getLootTableManager(), evt.getName(), table);
        });
        INSTANCE.register(LootTableLoadEvents.Modify.class, LootTableModifyEvent.class, (T callback, E evt) -> callback.onModifyLootTable(evt.getLootDataManager(), evt.getIdentifier(), evt::addPool, evt::removePool));
        INSTANCE.register(AnvilRepairCallback.class, AnvilRepairEvent.class, (T callback, E evt) -> {
            MutableFloat breakChance = MutableFloat.fromEvent(arg_0 -> ((AnvilRepairEvent)evt).setBreakChance(arg_0), () -> ((AnvilRepairEvent)evt).getBreakChance());
            callback.onAnvilRepair(evt.getPlayer(), evt.getItemInput(), evt.getIngredientInput(), evt.getItemResult(), breakChance);
        });
        INSTANCE.register(ItemTouchCallback.class, EntityItemPickupEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onItemTouch(evt.getPlayer(), evt.getItem());
            if (result.isInterrupt()) {
                if (result.getAsBoolean()) {
                    evt.setResult(Event.Result.ALLOW);
                } else {
                    evt.setCanceled(true);
                }
            }
        });
        INSTANCE.register(PlayerEvents.ItemPickup.class, PlayerEvent.ItemPickupEvent.class, (T callback, E evt) -> callback.onItemPickup(evt.getPlayer(), evt.getOriginalEntity(), evt.getStack()));
        INSTANCE.register(LootingLevelCallback.class, LootingLevelEvent.class, (T callback, E evt) -> {
            MutableInt lootingLevel = MutableInt.fromEvent(arg_0 -> ((LootingLevelEvent)evt).setLootingLevel(arg_0), () -> ((LootingLevelEvent)evt).getLootingLevel());
            callback.onLootingLevel(evt.getEntityLiving(), evt.getDamageSource(), lootingLevel);
        });
        INSTANCE.register(AnvilUpdateCallback.class, AnvilUpdateEvent.class, (T callback, E evt) -> {
            MutableValue<ItemStack> output = MutableValue.fromEvent(arg_0 -> ((AnvilUpdateEvent)evt).setOutput(arg_0), () -> ((AnvilUpdateEvent)evt).getOutput());
            MutableInt enchantmentCost = MutableInt.fromEvent(arg_0 -> ((AnvilUpdateEvent)evt).setCost(arg_0), () -> ((AnvilUpdateEvent)evt).getCost());
            MutableInt materialCost = MutableInt.fromEvent(arg_0 -> ((AnvilUpdateEvent)evt).setMaterialCost(arg_0), () -> ((AnvilUpdateEvent)evt).getMaterialCost());
            EventResult result = callback.onAnvilUpdate(evt.getLeft(), evt.getRight(), output, evt.getName(), enchantmentCost, materialCost, evt.getPlayer());
            if (result.isInterrupt()) {
                if (!result.getAsBoolean()) {
                    evt.setCanceled(true);
                }
            } else {
                evt.setOutput(ItemStack.f_41583_);
            }
        });
        INSTANCE.register(LivingDropsCallback.class, LivingDropsEvent.class, (T callback, E evt) -> {
            if (callback.onLivingDrops(evt.getEntityLiving(), evt.getSource(), evt.getDrops(), evt.getLootingLevel(), evt.isRecentlyHit()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingEvents.Tick.class, LivingEvent.LivingUpdateEvent.class, (T callback, E evt) -> {
            if (callback.onLivingTick(evt.getEntityLiving()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ArrowLooseCallback.class, ArrowLooseEvent.class, (T callback, E evt) -> {
            MutableInt charge = MutableInt.fromEvent(arg_0 -> ((ArrowLooseEvent)evt).setCharge(arg_0), () -> ((ArrowLooseEvent)evt).getCharge());
            if (callback.onArrowLoose(evt.getPlayer(), evt.getBow(), evt.getWorld(), charge, evt.hasAmmo()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingHurtCallback.class, LivingHurtEvent.class, (T callback, E evt) -> {
            MutableFloat amount = MutableFloat.fromEvent(arg_0 -> ((LivingHurtEvent)evt).setAmount(arg_0), () -> ((LivingHurtEvent)evt).getAmount());
            if (callback.onLivingHurt(evt.getEntityLiving(), evt.getSource(), amount).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Start.class, LivingEntityUseItemEvent.Start.class, (T callback, E evt) -> {
            MutableInt useDuration = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Start)evt).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Start)evt).getDuration());
            if (callback.onUseItemStart(evt.getEntityLiving(), evt.getItem(), useDuration).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Tick.class, LivingEntityUseItemEvent.Tick.class, (T callback, E evt) -> {
            MutableInt useItemRemaining = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Tick)evt).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Tick)evt).getDuration());
            if (callback.onUseItemTick(evt.getEntityLiving(), evt.getItem(), useItemRemaining).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Stop.class, LivingEntityUseItemEvent.Stop.class, (T callback, E evt) -> {
            if (callback.onUseItemStop(evt.getEntityLiving(), evt.getItem(), evt.getDuration()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Finish.class, LivingEntityUseItemEvent.Finish.class, (T callback, E evt) -> {
            MutableValue<ItemStack> stack = MutableValue.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Finish)evt).setResultStack(arg_0), () -> ((LivingEntityUseItemEvent.Finish)evt).getResultStack());
            callback.onUseItemFinish(evt.getEntityLiving(), stack, evt.getDuration(), evt.getItem());
        });
        INSTANCE.register(ShieldBlockCallback.class, ShieldBlockEvent.class, (T callback, E evt) -> {
            DefaultedFloat blockedDamage = DefaultedFloat.fromEvent(arg_0 -> ((ShieldBlockEvent)evt).setBlockedDamage(arg_0), () -> ((ShieldBlockEvent)evt).getBlockedDamage(), () -> ((ShieldBlockEvent)evt).getOriginalBlockedDamage());
            if (callback.onShieldBlock(evt.getEntityLiving(), evt.getDamageSource(), blockedDamage).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(TagsUpdatedCallback.class, TagsUpdatedEvent.class, (T callback, E evt) -> callback.onTagsUpdated(evt.getTagManager(), evt.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED));
        INSTANCE.register(ExplosionEvents.Start.class, ExplosionEvent.Start.class, (T callback, E evt) -> {
            if (callback.onExplosionStart(evt.getWorld(), evt.getExplosion()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ExplosionEvents.Detonate.class, ExplosionEvent.Detonate.class, (T callback, E evt) -> callback.onExplosionDetonate(evt.getWorld(), evt.getExplosion(), evt.getAffectedBlocks(), evt.getAffectedEntities()));
        INSTANCE.register(SyncDataPackContentsCallback.class, OnDatapackSyncEvent.class, (T callback, E evt) -> {
            if (evt.getPlayer() != null) {
                callback.onSyncDataPackContents(evt.getPlayer(), true);
                return;
            }
            for (ServerPlayer player : evt.getPlayerList().m_11314_()) {
                callback.onSyncDataPackContents(player, false);
            }
        });
        INSTANCE.register(ServerLifecycleEvents.ServerStarting.class, ServerStartingEvent.class, (T callback, E evt) -> callback.onServerStarting(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.ServerStarted.class, ServerStartedEvent.class, (T callback, E evt) -> callback.onServerStarted(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.ServerStopping.class, ServerStoppingEvent.class, (T callback, E evt) -> callback.onServerStopping(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.ServerStopped.class, ServerStoppedEvent.class, (T callback, E evt) -> callback.onServerStopped(evt.getServer()));
        INSTANCE.register(PlayLevelSoundEvents.AtPosition.class, PlaySoundAtEntityEvent.class, (T callback, E evt) -> {});
        INSTANCE.register(PlayLevelSoundEvents.AtEntity.class, PlaySoundAtEntityEvent.class, (T callback, E evt) -> {});
        INSTANCE.register(ServerEntityLevelEvents.Load.class, EntityJoinWorldEvent.class, (T callback, E evt) -> {
            MobSpawnType mobSpawnType;
            Entity patt20938$temp;
            if (evt.getWorld().f_46443_) {
                return;
            }
            Entity entity = evt.getEntity();
            ServerLevel serverLevel = (ServerLevel)evt.getWorld();
            if (!evt.loadedFromDisk() && (patt20938$temp = evt.getEntity()) instanceof SpawnTypeMob) {
                SpawnTypeMob mob = (SpawnTypeMob)patt20938$temp;
                mobSpawnType = mob.puzzleslib$getSpawnType();
            } else {
                mobSpawnType = null;
            }
            if (callback.onEntityLoad(entity, serverLevel, mobSpawnType).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.LoadV2.class, EntityJoinWorldEvent.class, (T callback, E evt) -> {
            if (evt.getWorld().f_46443_ || !evt.loadedFromDisk()) {
                return;
            }
            if (callback.onEntityLoad(evt.getEntity(), (ServerLevel)evt.getWorld()).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from loading in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Spawn.class, EntityJoinWorldEvent.class, (T callback, E evt) -> {
            MobSpawnType mobSpawnType;
            if (evt.getWorld().f_46443_ || evt.loadedFromDisk()) {
                return;
            }
            Entity entity = evt.getEntity();
            ServerLevel serverLevel = (ServerLevel)evt.getWorld();
            Entity patt22505$temp = evt.getEntity();
            if (patt22505$temp instanceof SpawnTypeMob) {
                SpawnTypeMob mob = (SpawnTypeMob)patt22505$temp;
                mobSpawnType = mob.puzzleslib$getSpawnType();
            } else {
                mobSpawnType = null;
            }
            if (callback.onEntitySpawn(entity, serverLevel, mobSpawnType).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Remove.class, EntityLeaveWorldEvent.class, (T callback, E evt) -> {
            if (evt.getWorld().f_46443_) {
                return;
            }
            callback.onEntityRemove(evt.getEntity(), (ServerLevel)evt.getWorld());
        });
        INSTANCE.register(LivingDeathCallback.class, LivingDeathEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onLivingDeath(evt.getEntityLiving(), evt.getSource());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerEvents.StartTracking.class, PlayerEvent.StartTracking.class, (T callback, E evt) -> callback.onStartTracking(evt.getTarget(), (ServerPlayer)evt.getEntity()));
        INSTANCE.register(PlayerEvents.StopTracking.class, PlayerEvent.StopTracking.class, (T callback, E evt) -> callback.onStopTracking(evt.getTarget(), (ServerPlayer)evt.getEntity()));
        INSTANCE.register(PlayerEvents.LoggedIn.class, PlayerEvent.PlayerLoggedInEvent.class, (T callback, E evt) -> callback.onLoggedIn((ServerPlayer)evt.getEntity()));
        INSTANCE.register(PlayerEvents.LoggedOut.class, PlayerEvent.PlayerLoggedOutEvent.class, (T callback, E evt) -> callback.onLoggedOut((ServerPlayer)evt.getEntity()));
        INSTANCE.register(PlayerEvents.AfterChangeDimension.class, PlayerEvent.PlayerChangedDimensionEvent.class, (T callback, E evt) -> {
            MinecraftServer server = Proxy.INSTANCE.getGameServer();
            ServerLevel from = server.m_129880_(evt.getFrom());
            ServerLevel to = server.m_129880_(evt.getTo());
            Objects.requireNonNull(from, "level origin is null");
            Objects.requireNonNull(to, "level destination is null");
            callback.onAfterChangeDimension((ServerPlayer)evt.getEntity(), from, to);
        });
        INSTANCE.register(BabyEntitySpawnCallback.class, BabyEntitySpawnEvent.class, (T callback, E evt) -> {
            MutableValue<AgeableMob> child = MutableValue.fromEvent(arg_0 -> ((BabyEntitySpawnEvent)evt).setChild(arg_0), () -> ((BabyEntitySpawnEvent)evt).getChild());
            if (callback.onBabyEntitySpawn(evt.getParentA(), evt.getParentB(), child).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(AnimalTameCallback.class, AnimalTameEvent.class, (T callback, E evt) -> {
            if (callback.onAnimalTame(evt.getAnimal(), evt.getTamer()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingAttackCallback.class, LivingAttackEvent.class, (T callback, E evt) -> {
            if (callback.onLivingAttack(evt.getEntityLiving(), evt.getSource(), evt.getAmount()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerEvents.Copy.class, PlayerEvent.Clone.class, (T callback, E evt) -> {
            evt.getOriginal().reviveCaps();
            callback.onCopy((ServerPlayer)evt.getOriginal(), (ServerPlayer)evt.getEntity(), !evt.isWasDeath());
            evt.getOriginal().invalidateCaps();
        });
        INSTANCE.register(PlayerEvents.Respawn.class, PlayerEvent.PlayerRespawnEvent.class, (T callback, E evt) -> callback.onRespawn((ServerPlayer)evt.getEntity(), evt.isEndConquered()));
        INSTANCE.register(ServerTickEvents.Start.class, TickEvent.ServerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.START) {
                return;
            }
            callback.onStartServerTick(Proxy.INSTANCE.getGameServer());
        });
        INSTANCE.register(ServerTickEvents.End.class, TickEvent.ServerTickEvent.class, (T callback, E evt) -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            callback.onEndServerTick(Proxy.INSTANCE.getGameServer());
        });
        INSTANCE.register(ServerLevelTickEvents.Start.class, TickEvent.WorldTickEvent.class, (T callback, E evt) -> {
            Level patt27732$temp;
            if (evt.phase != TickEvent.Phase.START || !((patt27732$temp = evt.world) instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt27732$temp;
            callback.onStartLevelTick(level.m_142572_(), level);
        });
        INSTANCE.register(ServerLevelTickEvents.End.class, TickEvent.WorldTickEvent.class, (T callback, E evt) -> {
            Level patt28075$temp;
            if (evt.phase != TickEvent.Phase.END || !((patt28075$temp = evt.world) instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt28075$temp;
            callback.onEndLevelTick(level.m_142572_(), level);
        });
        INSTANCE.register(ServerLevelEvents.Load.class, WorldEvent.Load.class, (T callback, E evt) -> {
            LevelAccessor patt28361$temp = evt.getWorld();
            if (!(patt28361$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt28361$temp;
            callback.onLevelLoad(level.m_142572_(), level);
        });
        INSTANCE.register(ServerLevelEvents.Unload.class, WorldEvent.Unload.class, (T callback, E evt) -> {
            LevelAccessor patt28652$temp = evt.getWorld();
            if (!(patt28652$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt28652$temp;
            callback.onLevelUnload(level.m_142572_(), level);
        });
        INSTANCE.register(ServerChunkEvents.Load.class, ChunkEvent.Load.class, (T callback, E evt) -> {
            LevelAccessor patt28937$temp = evt.getWorld();
            if (!(patt28937$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt28937$temp;
            callback.onChunkLoad(level, evt.getChunk());
        });
        INSTANCE.register(ServerChunkEvents.Unload.class, ChunkEvent.Unload.class, (T callback, E evt) -> {
            LevelAccessor patt29225$temp = evt.getWorld();
            if (!(patt29225$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt29225$temp;
            callback.onChunkUnload(level, evt.getChunk());
        });
        INSTANCE.register(ItemTossCallback.class, ItemTossEvent.class, (T callback, E evt) -> {
            if (callback.onItemToss(evt.getEntityItem(), evt.getPlayer()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingKnockBackCallback.class, LivingKnockBackEvent.class, (T callback, E evt) -> {
            DefaultedDouble strength = DefaultedDouble.fromEvent(v -> evt.setStrength((float)v), () -> ((LivingKnockBackEvent)evt).getStrength(), () -> ((LivingKnockBackEvent)evt).getOriginalStrength());
            DefaultedDouble ratioX = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)evt).setRatioX(arg_0), () -> ((LivingKnockBackEvent)evt).getRatioX(), () -> ((LivingKnockBackEvent)evt).getOriginalRatioX());
            DefaultedDouble ratioZ = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)evt).setRatioZ(arg_0), () -> ((LivingKnockBackEvent)evt).getRatioZ(), () -> ((LivingKnockBackEvent)evt).getOriginalRatioZ());
            if (callback.onLivingKnockBack(evt.getEntityLiving(), strength, ratioX, ratioZ).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ItemAttributeModifiersCallback.class, ItemAttributeModifierEvent.class, (T callback, E evt) -> {
            AttributeModifiersMultimap attributeModifiers = new AttributeModifiersMultimap(() -> ((ItemAttributeModifierEvent)evt).getModifiers(), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)evt).addModifier(arg_0, arg_1), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)evt).removeModifier(arg_0, arg_1), arg_0 -> ((ItemAttributeModifierEvent)evt).removeAttribute(arg_0), () -> ((ItemAttributeModifierEvent)evt).clearModifiers());
            callback.onItemAttributeModifiers(evt.getItemStack(), evt.getSlotType(), (Multimap<Attribute, AttributeModifier>)attributeModifiers, (Multimap<Attribute, AttributeModifier>)evt.getOriginalModifiers());
        });
        INSTANCE.register(ProjectileImpactCallback.class, ProjectileImpactEvent.class, (T callback, E evt) -> {
            if (callback.onProjectileImpact(evt.getProjectile(), evt.getRayTraceResult()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerEvents.BreakSpeed.class, PlayerEvent.BreakSpeed.class, (T callback, E evt) -> {
            DefaultedFloat breakSpeed = DefaultedFloat.fromEvent(arg_0 -> ((PlayerEvent.BreakSpeed)evt).setNewSpeed(arg_0), () -> ((PlayerEvent.BreakSpeed)evt).getNewSpeed(), () -> ((PlayerEvent.BreakSpeed)evt).getOriginalSpeed());
            if (callback.onBreakSpeed(evt.getPlayer(), evt.getState(), breakSpeed).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Affects.class, PotionEvent.PotionApplicableEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onMobEffectAffects(evt.getEntityLiving(), evt.getPotionEffect());
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
            }
        });
        INSTANCE.register(MobEffectEvents.Apply.class, PotionEvent.PotionAddedEvent.class, (T callback, E evt) -> callback.onMobEffectApply(evt.getEntityLiving(), evt.getPotionEffect(), evt.getOldPotionEffect(), evt.getPotionSource()));
        INSTANCE.register(MobEffectEvents.Remove.class, PotionEvent.PotionRemoveEvent.class, (T callback, E evt) -> {
            if (callback.onMobEffectRemove(evt.getEntityLiving(), evt.getPotionEffect()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Expire.class, PotionEvent.PotionExpiryEvent.class, (T callback, E evt) -> callback.onMobEffectExpire(evt.getEntityLiving(), evt.getPotionEffect()));
        INSTANCE.register(LivingEvents.Jump.class, LivingEvent.LivingJumpEvent.class, (T callback, E evt) -> LivingJumpHelper.onLivingJump(callback, evt.getEntityLiving()));
        INSTANCE.register(LivingEvents.Visibility.class, LivingEvent.LivingVisibilityEvent.class, (T callback, E evt) -> callback.onLivingVisibility(evt.getEntityLiving(), evt.getLookingEntity(), MutableDouble.fromEvent(visibilityModifier -> evt.modifyVisibility(visibilityModifier / evt.getVisibilityModifier()), () -> ((LivingEvent.LivingVisibilityEvent)evt).getVisibilityModifier())));
        INSTANCE.register(LivingChangeTargetCallback.class, LivingChangeTargetEvent.class, (T callback, E evt) -> {
            DefaultedValue<LivingEntity> target = DefaultedValue.fromEvent(arg_0 -> ((LivingChangeTargetEvent)evt).setNewTarget(arg_0), () -> ((LivingChangeTargetEvent)evt).getNewTarget(), () -> ((LivingChangeTargetEvent)evt).getOriginalTarget());
            if (callback.onLivingChangeTarget(evt.getEntityLiving(), target).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LoadCompleteCallback.class, FMLLoadCompleteEvent.class, (T callback, E evt) -> callback.onLoadComplete());
        INSTANCE.register(CheckMobDespawnCallback.class, LivingSpawnEvent.AllowDespawn.class, (T callback, E evt) -> {
            EventResult result = callback.onCheckMobDespawn((Mob)evt.getEntityLiving(), (ServerLevel)evt.getWorld());
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
            }
        });
        INSTANCE.register(GatherPotentialSpawnsCallback.class, WorldEvent.PotentialSpawns.class, (T callback, E evt) -> {
            ServerLevel level = (ServerLevel)evt.getWorld();
            PotentialSpawnsList<MobSpawnSettings.SpawnerData> mobsAt = new PotentialSpawnsList<MobSpawnSettings.SpawnerData>(evt.getSpawnerDataList(), spawnerData -> {
                evt.addSpawnerData(spawnerData);
                return true;
            }, arg_0 -> ((WorldEvent.PotentialSpawns)evt).removeSpawnerData(arg_0));
            callback.onGatherPotentialSpawns(level, level.m_8595_(), level.m_7726_().m_8481_(), evt.getMobCategory(), evt.getPos(), mobsAt);
        });
        INSTANCE.register(EntityRidingEvents.Start.class, EntityMountEvent.class, (T callback, E evt) -> {
            if (evt.isDismounting()) {
                return;
            }
            if (callback.onStartRiding(evt.getWorldObj(), evt.getEntity(), evt.getEntityBeingMounted()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(EntityRidingEvents.Stop.class, EntityMountEvent.class, (T callback, E evt) -> {
            if (evt.isMounting()) {
                return;
            }
            if (callback.onStopRiding(evt.getWorldObj(), evt.getEntity(), evt.getEntityBeingMounted()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            ForgeClientEventInvokers.register();
        }
    }

    private record ForgeEventInvoker<T, E extends Event>(@Nullable IEventBus eventBus, Class<E> event, ForgeEventInvokerRegistry.ForgeEventContextConsumer<T, E> converter) implements EventInvokerLike<T>
    {
        private static final Map<EventPhase, EventPriority> PHASE_TO_PRIORITY = Map.of(EventPhase.FIRST, EventPriority.HIGHEST, EventPhase.BEFORE, EventPriority.HIGH, EventPhase.DEFAULT, EventPriority.NORMAL, EventPhase.AFTER, EventPriority.LOW, EventPhase.LAST, EventPriority.LOWEST);

        @Override
        public EventInvoker<T> asEventInvoker(@Nullable Object context) {
            return (phase, callback) -> this.register(phase, callback, context);
        }

        private void register(EventPhase phase, T callback, @Nullable Object context) {
            Objects.requireNonNull(phase, "phase is null");
            Objects.requireNonNull(callback, "callback is null");
            EventPriority eventPriority = PHASE_TO_PRIORITY.getOrDefault(phase, EventPriority.NORMAL);
            IEventBus eventBus = this.eventBus;
            if (eventBus == null) {
                Objects.requireNonNull(context, "mod id context is null");
                eventBus = ModContainerHelper.findModEventBus((String)context).orElseThrow();
            }
            if (eventBus != MinecraftForge.EVENT_BUS && eventPriority != EventPriority.NORMAL) {
                throw new IllegalStateException("mod event bus does not support event phases");
            }
            eventBus.addListener(eventPriority, false, this.event, evt -> this.converter.accept(callback, (Event)evt, context));
        }
    }
}

