/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.item.v2.DisplayItemsOutput;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class CreativeModeTabConfiguratorImpl
implements CreativeModeTabConfigurator {
    private static final Item[] POTION_ITEMS = new Item[]{Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42738_};
    private final ResourceLocation identifier;
    @Nullable
    private Supplier<ItemStack> icon;
    @Nullable
    private Supplier<ItemStack[]> icons;
    private Consumer<DisplayItemsOutput> displayItemsGenerator = displayItemsOutput -> {};
    private boolean hasSearchBar;
    private boolean appendEnchantmentsAndPotions;

    public CreativeModeTabConfiguratorImpl(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public Supplier<ItemStack> getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Objects.requireNonNull(this.icons, "both icon suppliers are null");
        if (!ModLoaderEnvironment.INSTANCE.isForge()) {
            return () -> {
                ItemStack[] icons = this.icons.get();
                Preconditions.checkPositionIndex((int)1, (int)icons.length, (String)"icons is empty");
                return icons[0];
            };
        }
        return this.icon;
    }

    @Nullable
    public Supplier<ItemStack[]> getIcons() {
        return this.icons;
    }

    public Consumer<DisplayItemsOutput> getDisplayItemsGenerator() {
        if (this.appendEnchantmentsAndPotions) {
            return output -> {
                this.displayItemsGenerator.accept((DisplayItemsOutput)output);
                CreativeModeTabConfiguratorImpl.appendAllEnchantments(this.identifier.m_135827_(), output::accept);
                CreativeModeTabConfiguratorImpl.appendAllPotions(this.identifier.m_135827_(), output::accept);
            };
        }
        return this.displayItemsGenerator;
    }

    public boolean isHasSearchBar() {
        return this.hasSearchBar;
    }

    @Override
    public CreativeModeTabConfigurator icon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator icons(Supplier<ItemStack[]> icons) {
        this.icons = icons;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator displayItems(Consumer<DisplayItemsOutput> displayItemsGenerator) {
        this.displayItemsGenerator = displayItemsGenerator;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator withSearchBar() {
        this.hasSearchBar = true;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator appendEnchantmentsAndPotions() {
        this.appendEnchantmentsAndPotions = true;
        return this;
    }

    private static void appendAllEnchantments(String namespace, Consumer<ItemStack> itemStacks) {
        Comparator<Map.Entry> comparator = Comparator.comparing(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135815_());
        CreativeModeTabConfiguratorImpl.getNamespacedEntries(Registry.f_122825_, namespace).sorted(comparator).map(Map.Entry::getValue).forEach(enchantment -> itemStacks.accept(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.m_6586_()))));
    }

    private static void appendAllPotions(String namespace, Consumer<ItemStack> itemStacks) {
        Comparator<Potion> comparator = Comparator.comparing(potion -> {
            if (potion.m_43488_().isEmpty()) {
                throw new IllegalArgumentException("Cannot compare potions with empty effects!");
            }
            MobEffect effect = ((MobEffectInstance)potion.m_43488_().get(0)).m_19544_();
            ResourceLocation key = Registry.f_122823_.m_7981_((Object)effect);
            Objects.requireNonNull(key, "Mob effect key for class %s is null".formatted(effect.getClass()));
            return key.m_135815_();
        }).thenComparingInt(potion -> ((MobEffectInstance)potion.m_43488_().get(0)).m_19564_()).thenComparingInt(potion -> ((MobEffectInstance)potion.m_43488_().get(0)).m_19557_());
        Potion[] potions = (Potion[])CreativeModeTabConfiguratorImpl.getNamespacedEntries(Registry.f_122828_, namespace).map(Map.Entry::getValue).filter(potion -> !potion.m_43488_().isEmpty()).sorted(comparator).toArray(Potion[]::new);
        for (Item item : POTION_ITEMS) {
            for (Potion potion2 : potions) {
                itemStacks.accept(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)potion2));
            }
        }
    }

    private static <T> Stream<Map.Entry<ResourceKey<T>, T>> getNamespacedEntries(Registry<T> registry, String namespace) {
        return registry.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(namespace));
    }
}

