/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.core.ForgeProxy;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistryImpl;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandlerForgeV3
extends NetworkHandlerRegistryImpl {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private SimpleChannel channel;
    private final AtomicInteger discriminator = new AtomicInteger();

    public NetworkHandlerForgeV3(String modId) {
        super(modId);
    }

    @Override
    public <T extends Record> void registerClientbound$Internal(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerForgeV3.lambda$registerClientbound$Internal$0((ForgeProxy)Proxy.INSTANCE, arg_0, arg_1), NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T extends Record> void registerServerbound$Internal(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerForgeV3.lambda$registerServerbound$Internal$1((ForgeProxy)Proxy.INSTANCE, arg_0, arg_1), NetworkDirection.PLAY_TO_SERVER);
    }

    private <T> void register(Class<T> clazz, BiConsumer<T, Supplier<NetworkEvent.Context>> handle, NetworkDirection networkDirection) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Message of type %s is not a record".formatted(clazz));
        }
        Objects.requireNonNull(this.channel, "channel is null");
        BiConsumer<Object, FriendlyByteBuf> encode = (t, friendlyByteBuf) -> MessageSerializers.findByType(clazz).write((FriendlyByteBuf)friendlyByteBuf, t);
        Function<FriendlyByteBuf, Object> decode = MessageSerializers.findByType(clazz)::read;
        this.channel.registerMessage(this.discriminator.getAndIncrement(), clazz, encode, decode, handle, Optional.of(networkDirection));
    }

    @Override
    public <T extends Record> Packet<ClientGamePacketListener> toClientboundPacket(T message) {
        Objects.requireNonNull(this.channel, "channel is null");
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T extends Record> Packet<ServerGamePacketListener> toServerboundPacket(T message) {
        Objects.requireNonNull(this.channel, "channel is null");
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    public void build() {
        if (this.channel != null) {
            throw new IllegalStateException("channel is already built");
        }
        this.channel = NetworkHandlerForgeV3.buildSimpleChannel(this.modId, this.clientAcceptsVanillaOrMissing, this.serverAcceptsVanillaOrMissing);
        super.build();
    }

    private static SimpleChannel buildSimpleChannel(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, "play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions((Predicate)(clientAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).serverAcceptedVersions((Predicate)(serverAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).simpleChannel();
    }

    private static /* synthetic */ void lambda$registerServerbound$Internal$1(ForgeProxy rec$, Object x$0, Supplier x$1) {
        rec$.registerServerReceiverV2((Record)x$0, x$1);
    }

    private static /* synthetic */ void lambda$registerClientbound$Internal$0(ForgeProxy rec$, Object x$0, Supplier x$1) {
        rec$.registerClientReceiverV2((Record)x$0, x$1);
    }
}

