/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import pie.ilikepiefoo.events.EntityEnterChunkEventJS;
import pie.ilikepiefoo.events.EntityTameEventJS;
import pie.ilikepiefoo.events.FarmlandTrampleEventJS;
import pie.ilikepiefoo.events.PlayerChangeDimensionEventJS;
import pie.ilikepiefoo.events.PlayerCloneEventJS;
import pie.ilikepiefoo.events.PlayerRespawnEventJS;

public class EventHandler {
    public static void init() {
        PlayerEvent.CHANGE_DIMENSION.register(EventHandler::onPlayerChangeDimension);
        PlayerEvent.PLAYER_CLONE.register(EventHandler::onPlayerClone);
        PlayerEvent.PLAYER_RESPAWN.register(EventHandler::onPlayerRespawn);
        InteractionEvent.FARMLAND_TRAMPLE.register(EventHandler::onFarmlandTrampled);
        EntityEvent.ENTER_SECTION.register(EventHandler::onEntityEnterChunk);
        EntityEvent.ANIMAL_TAME.register(EventHandler::onEntityTame);
    }

    public static void onPlayerChangeDimension(ServerPlayer player, ResourceKey<Level> oldLevel, ResourceKey<Level> newLevel) {
        PlayerChangeDimensionEventJS.of(player, oldLevel, newLevel).post(ScriptType.SERVER, "player.change_dimension");
    }

    private static void onPlayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean conqueredEnd) {
        PlayerCloneEventJS.of(oldPlayer, newPlayer, conqueredEnd).post(ScriptType.SERVER, "player.clone");
    }

    private static void onPlayerRespawn(ServerPlayer serverPlayer, boolean conqueredEnd) {
        PlayerRespawnEventJS.of(serverPlayer, conqueredEnd).post(ScriptType.SERVER, "player.respawn");
    }

    private static EventResult onFarmlandTrampled(Level world, BlockPos pos, BlockState state, float distance, Entity entity) {
        FarmlandTrampleEventJS event = FarmlandTrampleEventJS.of(world, pos, state, distance, entity);
        event.post("block.trample");
        if (event.isCancelled()) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void onEntityEnterChunk(Entity entity, int chunkX, int chunkY, int chunkZ, int prevX, int prevY, int prevZ) {
        EntityEnterChunkEventJS.of(entity, chunkX, chunkY, chunkZ, prevX, prevY, prevZ).post("entity.enter_chunk");
    }

    private static EventResult onEntityTame(Animal animal, Player player) {
        EntityTameEventJS event = EntityTameEventJS.of(animal, player);
        event.post("entity.tame");
        if (event.isCancelled()) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

