/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.util.MapJS;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidTagJS
extends FluidStackJS {
    private final ResourceLocation tag;
    private final String fluid;
    private long amount;
    private CompoundTag nbt;
    private FluidStack cached;

    public FluidTagJS(ResourceLocation location) {
        this.tag = location;
        this.fluid = this.tag.toString();
        this.amount = FluidStack.bucketAmount();
        this.nbt = null;
        this.cached = null;
    }

    public String getId() {
        return this.fluid;
    }

    public FluidStack getFluidStack() {
        if (this.cached == null) {
            this.cached = FluidStack.create(this::getFluid, (long)this.amount, (CompoundTag)this.nbt);
        }
        return this.cached;
    }

    public Fluid getFluid() {
        if (KubeJSRegistries.fluids().contains(this.tag)) {
            return (Fluid)KubeJSRegistries.fluids().get(this.tag);
        }
        throw new UnsupportedOperationException("Using getFluid on FluidTags is not supported. This should only be used with recipes.");
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
        this.cached = null;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public void setNbt(@Nullable CompoundTag nbt) {
        this.nbt = nbt;
        this.cached = null;
    }

    public FluidStackJS copy() {
        FluidTagJS fluidTagJS = new FluidTagJS(this.tag);
        fluidTagJS.amount = this.amount;
        fluidTagJS.nbt = this.nbt == null ? null : this.nbt.m_6426_();
        return fluidTagJS;
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(o.toString());
        }
        FluidStackJS stack = FluidStackJS.of((Object)o);
        if (stack.isEmpty()) {
            return false;
        }
        return stack.hasTag(this.tag) && this.getAmount() == stack.getAmount() && Objects.equals(this.getNbt(), stack.getNbt());
    }

    public Collection<ResourceLocation> getTags() {
        return Collections.singleton(this.tag);
    }

    public boolean hasTag(ResourceLocation tag) {
        return this.tag.equals((Object)tag);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getNbt());
    }

    public JsonObject toJson() {
        JsonObject o = new JsonObject();
        o.addProperty("fluidTag", this.getId());
        if (this.getAmount() != FluidStack.bucketAmount()) {
            o.addProperty("amount", (Number)this.getAmount());
        }
        if (this.getNbt() != null) {
            o.add("nbt", (JsonElement)MapJS.json((Object)this.getNbt()));
        }
        if (this.hasChance()) {
            o.addProperty("chance", (Number)this.getChance());
        }
        return o;
    }
}

