/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo.mixin;

import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.core.PlayerSelector;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LevelJS.class}, remap=false)
public abstract class MixinWorldJS {
    @Shadow
    @Final
    public Level minecraftLevel;

    public void tickChunk(ChunkPos pos) {
        this.tickChunk(pos.f_45578_, pos.f_45579_);
    }

    public void tickChunk(int x, int z) {
        if (this.getServerLevel() != null) {
            this.getServerLevel().m_8714_(this.getServerLevel().m_6325_(x, z), 1);
        }
    }

    @javax.annotation.Nullable
    public ServerLevel getServerLevel() {
        if (this.minecraftLevel instanceof ServerLevel) {
            return (ServerLevel)this.minecraftLevel;
        }
        return null;
    }

    public void tickChunk(int x, int z, int tickCount) {
        if (this.getServerLevel() != null) {
            this.getServerLevel().m_8714_(this.getServerLevel().m_6325_(x, z), tickCount);
        }
    }

    public void forceLoadChunk(ChunkPos pos, boolean forceLoad) {
        this.forceLoadChunk(pos.f_45578_, pos.f_45579_, forceLoad);
    }

    public void forceLoadChunk(int x, int z, boolean forceLoad) {
        if (this.getServerLevel() != null) {
            this.getServerLevel().m_8602_(x, z, true);
        }
    }

    public List<ChunkPos> getForceLoadedChunks() {
        if (this.getServerLevel() != null) {
            return this.getServerLevel().m_8902_().stream().map(ChunkPos::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @javax.annotation.Nullable
    public Pair<BlockPos, Holder<Biome>> findNearestBiome(Predicate<Holder<Biome>> biomePredicate, BlockPos pos, int i, int j) {
        Pair biome = null;
        if (this.getServerLevel() != null) {
            biome = this.getServerLevel().m_207571_(biomePredicate, pos, i, j);
        }
        return biome;
    }

    @javax.annotation.Nullable
    public BlockContainerJS findNearestMapFeature(TagKey<ConfiguredStructureFeature<?, ?>> structureFeature, BlockPos pos, int i, boolean bl) {
        BlockPos featurePos = null;
        if (this.getServerLevel() != null) {
            featurePos = this.getServerLevel().m_207561_(structureFeature, pos, i, bl);
        }
        return featurePos == null ? null : this.getBlock(featurePos);
    }

    @Shadow
    public abstract BlockContainerJS getBlock(BlockPos var1);

    public int countTickableBlocks() {
        if (this.getServerLevel() != null) {
            return this.getServerLevel().m_183326_().m_183574_();
        }
        return -1;
    }

    public void spawnNetherPortal(BlockPos pos, Direction.Axis axis) {
        if (this.getServerLevel() != null) {
            this.getServerLevel().m_8871_().m_77666_(pos, axis);
        }
    }

    @javax.annotation.Nullable
    public PlayerJS getRandomPlayer() {
        if (this.getServerLevel() != null && this.getServer() != null) {
            return this.getServer().getPlayer(PlayerSelector.mc((Player)this.getServerLevel().m_8890_()));
        }
        return null;
    }

    @Shadow
    @Nullable
    public abstract ServerJS getServer();
}

