/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ReflectionUtils {
    public static <T> Pair<Class<?>, T> retrieveEventClass(Class<?> eventProvider, String fieldName, Class<T> eventType) throws IllegalArgumentException {
        if (eventProvider == null) {
            throw new IllegalArgumentException("Event Provider cannot be null!");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Field Name cannot be null!");
        }
        Field field = null;
        try {
            field = eventProvider.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field Name must be a valid field!");
        }
        if (eventType != null && !eventType.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Field must be of type Event!");
        }
        if (!Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Event Field must be public static!");
        }
        Object event = null;
        try {
            event = field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Event Field must be public static!");
        }
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Event Field must contain a be parameterized type!");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getActualTypeArguments()[0];
        Class eventClass = null;
        if (type2 instanceof Class) {
            Class clazz;
            eventClass = clazz = (Class)type2;
        }
        if (eventClass == null && type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType2 = (ParameterizedType)type2;
            eventClass = (Class)parameterizedType2.getRawType();
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("Event Field must contain a either a parameterized type or a class!");
        }
        if (!eventClass.isInterface()) {
            throw new IllegalArgumentException("Event Type must be an interface!");
        }
        return new Pair<Class, Object>(eventClass, event);
    }

    public static class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }
    }
}

