/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.poi.fast_portals;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PoiManager.class})
public abstract class PoiManagerMixin
extends SectionStorage<PoiSection> {
    @Shadow
    @Final
    private LongSet f_27030_;
    private final LongSet preloadedCenterChunks = new LongOpenHashSet();
    private int preloadRadius = 0;

    public PoiManagerMixin(Path path, Function<Runnable, Codec<PoiSection>> codecFactory, Function<Runnable, PoiSection> factory, DataFixer dataFixer, DataFixTypes dataFixTypes, boolean dsync, LevelHeightAccessor world) {
        super(path, codecFactory, factory, dataFixer, dataFixTypes, dsync, world);
    }

    @Overwrite
    public void m_27056_(LevelReader worldView, BlockPos pos, int radius) {
        long chunkPos;
        if (this.preloadRadius != radius) {
            this.preloadedCenterChunks.clear();
            this.preloadRadius = radius;
        }
        if (this.preloadedCenterChunks.contains(chunkPos = ChunkPos.m_151388_((BlockPos)pos))) {
            return;
        }
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        int chunkRadius = Math.floorDiv(radius, 16);
        int maxHeight = this.f_156618_.m_151561_() - 1;
        int minHeight = this.f_156618_.m_151560_();
        int xMax = chunkX + chunkRadius;
        for (int x = chunkX - chunkRadius; x <= xMax; ++x) {
            int zMax = chunkZ + chunkRadius;
            for (int z = chunkZ - chunkRadius; z <= zMax; ++z) {
                this.preloadChunkIfAnySubChunkContainsPOI(worldView, x, z, minHeight, maxHeight);
            }
        }
        this.preloadedCenterChunks.add(chunkPos);
    }

    private void preloadChunkIfAnySubChunkContainsPOI(LevelReader worldView, int x, int z, int minSubChunk, int maxSubChunk) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        long longChunkPos = chunkPos.m_45588_();
        if (this.f_27030_.contains(longChunkPos)) {
            return;
        }
        for (int y = minSubChunk; y <= maxSubChunk; ++y) {
            boolean result;
            Optional section = this.m_63823_(SectionPos.m_123209_((int)x, (int)y, (int)z));
            if (!section.isPresent() || !(result = ((PoiSection)section.get()).m_27272_())) continue;
            if (!this.f_27030_.add(longChunkPos)) break;
            worldView.m_46819_(x, z, ChunkStatus.f_62314_);
            break;
        }
    }
}

